import requests
from bs4 import BeautifulSoup
import csv
# Page URL for weather page and response page
page_link = 'https://weather.com/weather/tenday/l/New把혾儣壓���:1:US'
page_response = requests.get(page_link, timeout=5)
# Get ALL THE CONTENT!
soup = BeautifulSoup(page_response.content, "html.parser")
print("NOW EXECUTING OPERATION... KRASIVI BORSCH! (aka Beautiful Soup)")

# Get the results for the entire week from the body of a table (<tbody>)
week = soup.find("tbody")
# Sort results by each table row (<tr>)
result = week.find_all("tr")
result_csv = open('borsch.csv', 'w')
writer = csv.writer(result_csv)
# Write the column headers
writer.writerow(["Date", "Temperature", "Description", "Wind"])
# Loop time, lezgoooooo!
for day in result:
    # Find the various details based on CSS classes
    date  = day.find(class_="day-detail clearfix").getText()
    temp = day.find(class_="temp").getText()
    description = day.find(class_="description").getText()
    wind = day.find(class_="wind").getText()
    writer.writerow([date, temp, description, wind])

# Close the file... until next time!
result_csv.close();
print("OPERATION... KRASIVI BORSCH (aka Beautiful Soup) HAS FINISHED!")
