import numpy as np
import timeit


x = np.array([[1,2],[3,4]], dtype=np.float64)
y = np.array([[5,6],[7,8]], dtype=np.float64)

# Elementwise sum; both produce the array
# [[ 6.0  8.0]
#  [10.0 12.0]]
print(x + y)
print(np.add(x, y))

# Elementwise difference; both produce the array
# [[-4.0 -4.0]
#  [-4.0 -4.0]]
print(x - y)
print(np.subtract(x, y))

z1 = np.array(list(range(10)))
z2 = np.array(list(range(10)))
print("z1 is ", z1)
print("z1 * z2 ", np.multiply(z1,z2))
print("z1 dot z2 ", np.dot(z1,z2))
print("z1 * 4", np.multiply(z1,4))

# grouping
data = np.arange(1, 7)
groups = np.array([0,0,1,2,2,1])

unique_groups = np.unique(groups)
sums = []
for group in unique_groups:
    sums.append(data[groups == group].sum())

# Now look at the speed
# I'm actually surprised that python is not that bad.
s ="""\
import numpy as nn
z1 = nn.array(range(10000))
z2 = nn.array(range(10000))
z3 = nn.multiply(z1,z2)
z4 = nn.dot(z1,z2)
"""
print("time of z1 * z2 in numpy", timeit.timeit(stmt=s, number=100))
s ="""\
z1 = (range(10000))
z2 = (range(10000))
i = 0
sum = 0
while (i < len(z1)):
        x = z1[i] * z2[i]
        sum+= x
        i+= 1
"""
print("time of z1 * z2 in python", timeit.timeit(stmt=s, number=100))
