"""
A sample Flask based database driven web application
"""

from flask import Flask, g, render_template, request
import sqlite3

DATABASE_PATH = 'aliceinwonderland.db'

app = Flask(__name__)

@app.before_request
def set_up():
    """
    Connect to SQLITE 3 database before anything else is done.
    """
    g.db = sqlite3.connect(DATABASE_PATH)

@app.teardown_request
def teardown(exception):
    """
    Close database connection when the app is closed.
    """
    g.db.close()

@app.route('/')
def home():
    return render_template('index.html')

@app.route('/project', methods=['POST'])
def project():
    """
    THIS IS WHAT YOU MODIFY
    """
    cur = g.db.cursor()
    search_query = request.form['name'] # Get the search query from the form
    cur.execute('''
	SELECT publication.pubid, publication.title FROM publication, pubproject WHERE publication.pubid = pubproject.pubid and pubproject.project = ?
        ''', (search_query,))
    row = cur.fetchall()
    result = [name[1] for name in row]
    return render_template('results.html', items=result)

@app.route('/author', methods=['POST'])
def author():
    """
    THIS IS WHAT YOU MODIFY
    """
    cur = g.db.cursor()
    search_query = request.form['name'] # Get the search query from the form
    cur.execute('''
	SELECT publication.pubid, publication.title FROM publication, pubauthor WHERE publication.pubid = pubauthor.pubid and pubauthor.author = ?
        ''', (search_query,))
    row = cur.fetchall()
    result = [name[1] for name in row]
    return render_template('results.html', items=result)


if __name__ == "__main__":
    app.run(debug=True)
