/* 

NoTippingAppletStub

version 1.0
 Prasad Tadimalla, 2003

used in version 2.0 of No Tipping by:
Alex Halter, Azam Asl, Michal Novemsky, 2011
*/

import java.applet.AppletStub;
import java.applet.Applet;
import java.applet.AppletContext;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.NoSuchElementException;
import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * 
 * @author Prasad Tadimalla
 * class that sets up the interface between the applet and the environment in which it is running
 */
public class NoTippingAppletStub implements AppletStub {
    private Hashtable _properties;
    private Applet _applet;

    /**
     * @param argv[] Command line arguments passed to Main
     * @param a An Applet instance
     */
    public NoTippingAppletStub (String argv[], Applet a) {
      _applet = a;
      _properties = new Hashtable();
      for ( int i = 0; i < argv.length; i++ ) {
        try {
          StringTokenizer parser =
           new StringTokenizer (
            argv[i], "=");
          String name = parser.nextToken(
                          ).toString();
          String value = parser.nextToken(
             "\"").toString();
          value = value.substring(1);
          _properties.put (name, value);
        } catch (NoSuchElementException e) {
          e.printStackTrace();
        }
      }
    }

    /**
     * Calls the applet's resize
     * @param width
     * @param height
     */
    public void appletResize (
       int width, int height) {
      _applet.resize (width, height);
    }

    /**
     * Returns the applet's context, which is
     * null in this case. This is an area where more
     * creative programming
     * work can be done to try and provide a context
     * @return AppletContext Always null
     */
    public AppletContext getAppletContext () {
      return null;
    }

    /**
     * Returns the CodeBase. If a host parameter
     * isn't provided
     * in the command line arguments, the URL is based
     * on InetAddress.getLocalHost().
     * The protocol is "file:"
     * @return URL
     */
    public java.net.URL getCodeBase() {
      String host;
      if ( (host=getParameter (
        "host")) == null ) {
        try {
          host = InetAddress.getLocalHost(
                          ).getHostName();
        } catch (UnknownHostException e) {
          e.printStackTrace();
        }
      }

      java.net.URL u  = null;
      try {
        u = new java.net.URL (
         "file://"+host);
      } catch (Exception e) { }
      return u;
    }

    /**
     * Returns getCodeBase
     * @return URL
     */
    public java.net.URL getDocumentBase() {
      return getCodeBase();
    }

    /**
     * Returns the corresponding command line value
     * @return String
     */
    public String getParameter (
                      String p) {
      return (String)_properties.get (p);
    }

    /**
     * Applet is always true
     * @return boolean True
     */
    public boolean isActive () {
      return true;
    }

}
