//*****************************
//  VInfo.Java
//  Information popup box for Voronoi Game
//  by Monty Faidley and
//  Chris Poultney
//  December 2, 1996
//*****************************

import java.awt.*;
import java.util.Properties;

public class VInfo extends Frame {

  MenuBar menubar;
  Menu file;

  private TextArea textArea = new TextArea( 20, 60);

  private String Info_1 =  "\n\nWritten by Monty Faidley and Chris Poultney\n" +
                           "Conceptualized by Dennis Shasha\n\n";

  private String Info_2 =  "The objective of the Voronoi game is to claim as much area as possible\n" +
                           "by clicking in the space provided.  The players take turns placing\n" +
                           "\'stones\' on the board.  Each stone captures the area of the board\n" +
                           "which is closer to it that any other stone.  As each new stone is placed,\n" +
                           "the areas of the previously placed stones are recalcuated.  The player\n" +
                           "whose stones control the largest area at the end of the game is the winner.\n\n";

  private String Info_3 = "There are four computer players.  Each one plays with a different strategy.\n" +
                          "Thunker\t\tPicks and plays in a random place.\n" +
                          "GetWinner\tDivides the biggest polygon of the player with the\n" +
                          "\t\tmost area.\n" +
                          "BigPoly\t\tDivides the polygon with the biggest area.\n" +
                          "GoodGuess\tPicks 10 points at random and plays at the point that\n" +
                          "\t\tyields the most area.\n\n";

  public VInfo( Properties strings )
  {
    setTitle( "Voronoi Game Play" );
    //Below here is the text for the info window
    textArea.setEditable(false);
    String s = new String();
    s += "Welcome To The Voronoi Game";
    s += Info_1;
    s += "Instructions\n";
    s += Info_2;
    s += Info_3;
    s += "Good Luck!\n";
    textArea.setText( strings.getProperty("strings.info.text", s) );

    menubar = new MenuBar();
    file = new Menu( "File" );
    file.add(new MenuItem("Exit"));
    menubar.add(file);
    //setMenuBar( menubar );

    setLayout(new FlowLayout(FlowLayout.CENTER,10,10));
    add( textArea );
    pack();
    show();
  }

  public boolean handleEvent(Event e)
  {
    if( e.target instanceof MenuItem)
    {
      if( ((String)e.arg).equals("Exit") )
      {
        hide();
        dispose();
        return true;
      }
      return false;
    } else if( e.id == 201 ) {
      hide();
      dispose();
      return true;
    } else {
      return false;
    }
  }//end handleEvent()
}//End of class VInfo
