package noon;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;

import noon.Board.HunterStep;
import noon.Board.PreyStep;
import noon.Board.Wall;

import org.json.JSONException;

public class PlayerConnector {
	
	static class PlayerTimer extends TimerTask {
		public void run() {
			try {
				throw new Exception();
			} catch (Exception e) {
				
			}
		}
	}
	
	public static class NetPlayer {
		protected Socket socket;
		protected String name;
		protected InputStream in;
		protected PrintStream out;
		protected Scanner scanner;
		protected int timeLeft;
		protected int N;
		protected int M;
		private static int totalTime = 120500;
		/**
		 * Disconnect
		 * @throws IOException 
		 */
		public void close(Game.Result result) {
			String message = "";
			
			if (result.hunterTimeout && result.preyTimeout) {
				message = "Game Over: Time exceeded for both. Replay needed..";
			}
			else if (result.preyTimeout || result.preyInvalid) {
				message = "Game Over: Hunter won, prey lost..";
			}
			// They may run over their time at the same time.
			else if (result.hunterTimeout || result.hunterInvalid) {
				message = "Game Over: Prey won, hunter lost..";
			}
			else {
				message = "Game Over: Hunter won, score: " + result.board.getTime();
			}
			try {
				this.out.print(message);
				this.in.close();
				this.out.close();
				this.scanner.close();
				this.socket.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
			
//			throw new RuntimeException();
		}
		public NetPlayer(Socket socket, Board.Parameter parameter) {
			this.socket = socket;
			try {
				this.in = this.socket.getInputStream();
				this.scanner = new Scanner(this.in);
				this.out = new PrintStream(this.socket.getOutputStream(), true);
			} catch (IOException e) {
				// if something wrong happen, throw an exception and stop the server
				throw new RuntimeException(e);
			}
			// Let's make it 121 * 1000...
			this.timeLeft = totalTime;
			this.N = parameter.wallCoolDown;
			this.M = parameter.wallMaximum;
		}
		
		public String toString(Board board) {
			String message = "H " + board.getHunterPosition().x + " " + board.getHunterPosition().y + " P " + board.getPreyPosition().x + " " + board.getPreyPosition().y + " W ";
			String wallStr = "";
			if (board.getWalls().size() == 0) {
				message += "0";
			}
			else {
				// walls are separated by ','
				for (Wall wall : board.getWalls()) {
					wallStr = wall.position.x + " " + wall.position.y;
					if (wall.isHorizontal) {
						int x = wall.position.x + wall.length;
						wallStr += " " + x + " " + wall.position.y + ",";
					} 
					else {
						int y = wall.position.y + wall.length;
						wallStr += " " + wall.position.x + " " + y + ",";
					}
					message += wallStr;
				}
				message = message.substring(0, message.length() - 1);
			}
			return message;
		}
		
	}
	
	public static class Hunter extends NetPlayer implements Game.HunterPlayer {

		public Hunter(Socket socket, Board.Parameter parameter) {
			super(socket, parameter);
			this.out.println("Hunter " + this.N + " " + this.M);
			// get name
			this.name = this.scanner.nextLine();
			System.err.println("Message Received: " + this.name);
		}

		@Override
		public String getName() {
			return this.name;
		}

		@Override
		public HunterStep getHunterStep(Board board, Collection<PreyStep> preySteps) {
			// send current position to hunter
			String message = this.toString(board);
			String hunter_move = "";

			try {
				this.out.println("# " + board.toJson().toString());
			} catch (JSONException e1) {
				e1.printStackTrace();
			}
			this.out.println(message);

			// Ask Hunter's wall manipulation at current time step (time counting down start)
			long ticker_start = System.currentTimeMillis();
			// Use Socket.setSoTimeout() to stop waiting
			// If run over time, return null
			try {
				System.err.println("Time left: " + this.timeLeft);
//				this.socket.setSoTimeout(this.timeLeft);
				
				
				
				Timer t = new Timer();
//				t.schedule(new PlayerTimer(), timeLeft);
				t.schedule(new TimerTask() {
					@Override
					public void run() {
						try {
							String message = "Game Over: Prey won, hunter lost..";
							out.print(message);
							Hunter.this.socket.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}, timeLeft);
								
				// Get Hunter's message and check if it is valid (time counting stop)
				do {
					hunter_move = this.scanner.nextLine();
				} while (hunter_move.startsWith("#"));
				t.cancel();
				timeLeft -= System.currentTimeMillis() - ticker_start;
				String[] position = hunter_move.split(" ");
				// If Hunter doesn't want to do anything, position = [0].
				if (position.length == 1 && position[0].equals("0")) {
					// return hunter step with a null wall
					return new HunterStep(null);
				}
				else if (position.length == 4){
					// X1 Y1 X2 Y2
					boolean isHorizontal = false;
					int length = 0;
					int X1 = Integer.parseInt(position[0]);
					int Y1 = Integer.parseInt(position[1]);
					int X2 = Integer.parseInt(position[2]);
					int Y2 = Integer.parseInt(position[3]);
					// length >= 0. (X1, Y1) may not be the start position.
//					if (!checkStep(X1, Y1, X2, Y2))
//						return null;
					XY xy;
					if (Y1 == Y2) {
						isHorizontal = true; 
						if (X2 >= X1) {
							xy = new XY(X1, Y1);
							length = X2 - X1;
						}
						else {
							xy = new XY(X2, Y2);
							length = X1 - X2;
						}
					}
					else {
						if (Y2 >= Y1) {
							xy = new XY(X1, Y1);
							length = Y2 - Y1;
						}
						else {
							xy = new XY(X2, Y2);
							length = Y1 - Y2;
						}
					}
					// return hunter step
					return new HunterStep(new Wall(isHorizontal, xy, length));
				}
				else {
					return null;
				}
			} catch (Exception e) {
				System.err.println("Time out!");
				return null;
			}
		}
		/*private boolean checkStep(int x1, int y1, int x2, int y2) {
			if (x1 < 0 || x1 > 500 || y1 < 0 || y1 > 500 || x2 < 0 || x2 > 500 || y2 < 0 || y2 > 500) {
				return false;
			}
			if (x1 != x2 && y1 != y2) {
				return false;
			}
			return true;
		}*/
	}
	
	public static class Prey extends NetPlayer implements Game.PreyPlayer {

		public Prey(Socket socket, Board.Parameter parameter) {
			super(socket, parameter);
			this.out.println("Prey " + this.N + " " + this.M);
			// get name
			this.name = this.scanner.nextLine();
			System.err.println("Message Received: " + this.name);
		}

		@Override
		public String getName() {
			return this.name;
		}

		/*private boolean checkStep(int x) {
			int[] validNums = {-1, 0, 1};
			for(int num : validNums) {
				if (num == x)
					return true;
			}
			return false;
		}*/
		@Override
		public PreyStep getPreyPlayer(Board board,
				Collection<HunterStep> hunterSteps) {
			
			// send current position to hunter
			String message = this.toString(board);
			String prey_move = "";

			try {
				this.out.println("# " + board.toJson().toString());
			} catch (JSONException e1) {
				e1.printStackTrace();
			}
			this.out.println(message);

			// Ask Hunter's wall manipulation at current time step 
			long ticker_start = System.currentTimeMillis();
			// Use Socket.setSoTimeout() to stop waiting
			// If run over time, return null
			try {
//				this.socket.setSoTimeout(this.timeLeft);
				
				Timer t = new Timer();
//				t.schedule(new PlayerTimer(), timeLeft);
				t.schedule(new TimerTask() {
					@Override
					public void run() {
						try {
							String message = "Game Over: Hunter won, prey lost..";
							out.print(message);
							Prey.this.socket.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}, timeLeft);
				// Get Prey's message and check if it is valid
				do {
					prey_move = this.scanner.nextLine();
				} while (prey_move.startsWith("#"));
				t.cancel();
				timeLeft -= System.currentTimeMillis() - ticker_start;
				
				String[] position = prey_move.split(" ");
				int x = Integer.parseInt(position[0]);
				int	y = Integer.parseInt(position[1]);
				
//				if (!(checkStep(x) && checkStep(y)))
//					return null;
				// return prey step
				return new PreyStep(x, y);
			} catch (Exception e) {
				System.err.println("Time out!");
				return null;
			}
		}

	}
	
	private Hunter hunter;
	private Prey prey;
	
	/**
	 * Listen and establish connections to both players.
	 * this.hunter and this.prey should be valid before it returns.
	 */
	public void waitPlayers(int port, Board.Parameter parameter, ObserverConnector observer) {
		try {
			ServerSocket serverSocket = new ServerSocket(port);
			serverSocket.setReuseAddress(true);
			System.err.println("Server started");
			
			// initialize hunter/prey
			hunter = new Hunter(serverSocket.accept(), parameter);
			prey = new Prey(serverSocket.accept(), parameter);
		} catch (IOException e) {
			// if something wrong happen, throw an exception and stop the server
			throw new RuntimeException(e);
		}
	}
	public Game.HunterPlayer getHunter() {
		return hunter;
	}
	public Game.PreyPlayer getPrey() {
		return prey;
	}
	public void close(Game.Result result) {
		hunter.close(result);
		prey.close(result);
	}
}
