package noon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Random;

import javax.swing.*;

import noon.Board.Wall;


public class ObserverConnectorBak {
	
	JFrame frame;
	JPanel canvas;
	JLabel hunterLabel;
	JLabel preyLabel;
	String hunterName;
	String preyName;
	Graphics g;
	/**
	 * Start listening. No need to wait for a connection.
	 * Make an empty JFrame.
	 */
	public void start(int port) {
		if (port >= 0) {
			try {
				SwingUtilities.invokeAndWait(new Runnable() {
					@Override
					public void run() {
						frame = new JFrame();
						canvas = new JPanel();
						JPanel labels = new JPanel();
						hunterLabel = new JLabel("AAA");
						preyLabel = new JLabel("BBB");
						labels.add(hunterLabel);
						labels.add(preyLabel);
						
						frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
						canvas.setPreferredSize(new Dimension(500, 500));
						canvas.setBorder(BorderFactory.createLineBorder(Color.black));
						canvas.setBackground(Color.BLACK);
						labels.setBackground(Color.WHITE);
						frame.getContentPane().add(canvas);
						frame.setPreferredSize(new Dimension(600, 600));
						frame.setVisible(true);

						Container cp = frame.getContentPane();
						cp.setLayout(new BorderLayout());
						cp.add(labels, BorderLayout.PAGE_START);
						cp.add(canvas, BorderLayout.CENTER);
						
						frame.pack();
					}
				});
			} catch (Exception e) {
				e.printStackTrace();
			} 
		}
	}
	
	/**
	 * Notify that both players are connected
	 * @param hunter
	 * @param prey
	 */
	public void connected(Game.Player hunter, Game.Player prey) {
		this.hunterName = hunter == null ? "AAA" : hunter.getName();
		this.preyName = prey == null ? "BBB" : hunter.getName();
		try {
			SwingUtilities.invokeAndWait(new Runnable() {
				@Override
				public void run() {
					hunterLabel.setText("Hunter: " + hunterName);
					preyLabel.setText("Prey: " + preyName);
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}

	XY hunterPosition;
	XY preyPosition;
	int time;
	int wallLeft;
	Collection<Wall> walls;
	
	public void paint(Graphics g) {
		Random r = new Random();
		g.setColor(Color.BLACK);
		g.clearRect(canvas.getX(), canvas.getY(), canvas.getWidth(), canvas.getHeight());
		g.fillRect(canvas.getX(), canvas.getY(), canvas.getWidth(), canvas.getHeight());
		g.setColor(Color.RED);
		g.drawRect(hunterPosition.x, hunterPosition.y, 1, 1);
//		g.drawRect(r.nextInt(500), r.nextInt(500), 1, 1);
		g.setColor(Color.BLUE);
		g.drawRect(preyPosition.x, preyPosition.y, 1, 1);
		g.setColor(Color.DARK_GRAY);
		for (Wall a : walls) {
			g.drawLine(a.position.x,a.position.y,a.isHorizontal? a.position.x + a.length : a.position.x, a.isHorizontal? a.position.y : a.position.y + a.length);
		}
		g.setColor(Color.BLACK);
		g.drawString("Score: " + time, 0, 520);
		g.drawString("Wall left: " + wallLeft, 0, 540);
	}
	public void update(Graphics g) {
		paint(g);
	}
	/**
	 * Notify that the board is updated.
	 * @param board
	 */
	public void update(Board board) {
		
		try {
			final Board b = new Board(board);
			SwingUtilities.invokeAndWait(new Runnable() {
				
				@Override
				public void run() {
					hunterPosition = b.getHunterPosition();
					preyPosition = b.getPreyPosition();
					time = b.getTime();
					wallLeft = b.getWallCountDown();
					walls = b.getWalls();
					g = canvas.getGraphics();
					while (true) {
						update(g);
						try {
							Thread.sleep(1000);
						} catch (InterruptedException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
//					canvas.update(g);
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}
	
	/**
	 * Just say something.
	 * @param who "S": server "H": hunter "P": prey
	 */
	public void log(String who, String text) {
		System.err.println("[" + who + "]" + text);
		// TODO Auto-generated method stub
	}
	
	/**
	 * Notify that the game is over.
	 * @param result
	 */
	public void over(Game.Result result) {
		canvas.removeAll();
		canvas = new JPanel() {
			 @Override
			   public void paintComponent(Graphics g) {
			      super.paintComponent(g);  // paint parent's background
			      g.setFont(new Font("a", Font.BOLD, 20));
			      g.drawString("Game Over", 0, 0);
			   } 
		};
	}
	
	/**
	 * Disconnect to client.
	 */
	public void close() {
		
	}
	
	public static void main(String[] args) {
		ObserverConnectorBak oc = new ObserverConnectorBak();
		oc.start(0);
		oc.connected(null, null);
		Board b = new Board(new Board.Parameter(Config.DEFAULT_COOLDOWN, Config.DEFAULT_MAXIMUM));
		oc.update(b);
		
	}
}
