package noon;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JApplet;
import javax.swing.SwingUtilities;


public class EvasionApplet extends JApplet{
	private String hunter;
	private String prey;
	private String winner;
	private String score;
	private int wallCoolDown;
	private int wallMaximum;
	
	@Override
	public void init() {
		this.winner = "not set";
		this.score = "not set";
		this.hunter = "not set";
		this.prey = "not set";
		if (this.getParameter("hunter") != null) {
			this.hunter = this.getParameter("hunter");
		}
		if (this.getParameter("prey") != null) {
			this.prey = this.getParameter("prey");
		}
		wallCoolDown = Config.DEFAULT_COOLDOWN;
		wallMaximum = Config.DEFAULT_MAXIMUM;
		if (this.getParameter("wallCoolDown") != null) {
			wallCoolDown = Integer.parseInt(this.getParameter("wallCoolDown"));
		}
		if (this.getParameter("wallMaximum") != null) {
			wallMaximum = Integer.parseInt(this.getParameter("wallMaximum"));
		}
	}
	
	@Override
	public void start() {
		this.setBackground(Color.BLACK);
		this.getContentPane().setBackground(Color.BLACK);
		gameStart();
	}
	
	@Override
	public void stop() {
		System.out.println("Output from using stop method");
	}
	
	public void gameStart() {
		this.setFocusable(true);
		new Thread() {
			public void run() {
				test(wallCoolDown, wallMaximum);				
			}
		}.start();			

/*		this.setFocusable(true);
		this.addKeyListener(new KeyListener() {
			private boolean started = false;
			public void keyTyped(KeyEvent e) {
			}
			public void keyPressed(KeyEvent e) {
				if (started) return;
				if (e.getKeyCode() != KeyEvent.VK_SPACE) return;
				started = true;
				new Thread() {
					public void run() {
						test(wallCoolDown, wallMaximum);				
					}
				}.start();			
			}
			public void keyReleased(KeyEvent e) {
			}
		});*/
	}
	
	@Override
	public void destroy() {
		System.out.println("Output from using destroy method");
	}
	
	private void test(int wallCoolDown, int wallMaximum) {
		
		System.out.println("Arguments: ");
		System.out.println("  N=" + wallCoolDown);
		System.out.println("  M=" + wallMaximum);
		// start observer
		ObserverConnector observerConn = new ObserverConnector();
		observerConn.start(1, this);
		// start players  
		Board.Parameter parameter = new Board.Parameter(wallCoolDown, wallMaximum);
//		PlayerConnector playerConn = new PlayerConnector();
//		playerConn.waitPlayers(playerPort, parameter, observerConn);
		Game.HunterPlayer hunter = observerConn.getHunter();
		Game.PreyPlayer prey = observerConn.getPrey();
		observerConn.connected(hunter, prey);
		// play game
		Game.Result result = Game.play(parameter, hunter, prey, observerConn);
		observerConn.over(result);
		// cleanup
//		playerConn.close(result);
		observerConn.close();
		
		this.winner = this.hunter;
		this.score = ((Integer) result.time).toString();
	}

	public String getWinner() {
		return winner;
	}

	public void setWinner(String winner) {
		this.winner = winner;
	}

	public String getScore() {
		return score;
	}

	public void setScore(String score) {
		this.score = score;
	}
	
}
