
/* 

NoTippingComponent

 version 1.X

 Tyler Neylon, 2002

version 2.0 by:
Alex Halter, Azam Asl, Michal Novemsky, 2011
*/

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;

/**
 * 
 * @author HalterA,AAsl,MNovemsky,AAsl,MNovemsky
 * class for Weights
 */
class Weight {
	public Weight(int w, int whose, int place, int p) {
		this.w = w; //weight
		this.whose = whose; //color
		this.place = place; //sky, disc, or grass
		position = p; //legacy, from 1-D, also used for position of layout in sky and grass
		discPos = null; //coordinates
		do_draw = true; //for the invisible weight and for moving weights around
	}
	public Point2D.Double discPos;
	public int w;
	public int whose;
	public int place;
	public boolean do_draw;
	public int position;
}

/**
 * 
 * @author HalterA,AAsl,MNovemsky
 * class for Moves, for future undo functionality
 */
class Move {
	public Move(int w_index, int who, int p) {
		this.w_index = w_index;
		this.who = who;
		position = p;
	}

	public int w_index, who, position;
}



/**
 * 
 * @author HalterA,AAsl,MNovemsky
 * The major class for the game and display logic
 */
 public class NoTippingComponent
        extends Component
        implements MouseListener, ActionListener,
        	MouseMotionListener, ItemListener {

	 
	private static final long serialVersionUID = 1L;

	//horizontal offset for the disc:
	private final static int OFFSET = 200;
		
	//vertical offset for the disc
	private final static int YOFFSET = 150;
		
	//distance btwn the balances (it's an equilateral triangle with sides of length DISTANCE)
	private final static double DISTANCE = 80.0;
	private int width, height, meter, ss_width, horizon, ss_height, f_height;
	private ArrayList<Weight> weights;
	private int weight_selected, selected_x, selected_y;
	private int whose_turn;
	private int s_torque, ne_torque, nw_torque; //to replace left_torque and right_torque
	
	private int ne_dragged = 0;
	private int nw_dragged = 0;
	private int s_dragged = 0;
	
	public boolean game_over;
	private Stack<Move> moves;
	private int phase, num_on_grass, who_lost;
	public int who_won;
	private BufferedImage image;
	private int numPlayers;
	private int numWeights;
	private Point2D.Double discCenter;
	private double radius;

	private Line2D.Double ne,nw,s;
	private Point2D.Double balance1,balance2,balance3;
		
	/**
	 * 
	 * @param w the weight 
	 * @return the rectangle that is the weight
	 * Class for constructing the weight rectangle
	 * 
	 */
	private Rectangle computeRectangle(Weight w) {
		int h = 17;
		if (w.place == 0) {
			if (w.whose == 0) {
				return new Rectangle(20*w.w+15, 15 + (8*2), 18, h); //changed 12 to 18
			} else if (w.whose == 1)
			{
				return new Rectangle(width-20*(8-w.w)-170, 15 + (8*2), 18, h); //changed -10 to -85, 12 to 18 
			} else if (w.whose == 2)
			{
				
				return new Rectangle(20*w.w+15, 15 + (8*2) + 50, 18, h);
			} else  //(w.whose == 3 )
			{
				return new Rectangle(width-20*(8-w.w)-170, 15 + (8*2)+50, 18, h);
			}
		} else if (w.place == 1) {
			return new Rectangle((int)w.discPos.x,
								(int)w.discPos.y,
								 18, h); //changed 12 to 18
		} else {
			// it's on the grass (removed)
			return new Rectangle(20*w.position+10, height-40+(8)*2, 18, h); //changed 12 to 18
		}
	}

	/**
	 * For input from toolbar, for now just restart.
	 * This is a listener for actions on the toolbar.
	 */
	public void actionPerformed(ActionEvent e) {
		System.out.println("actionPerformed(" + e.getActionCommand() + ")");
   
		if (e.getActionCommand().equals("Restart")) {
			
			begin();
			update(getGraphics());
			return;
		} 
	}


	/**
	 * @Override
	 * Returns the preferred size for awt.component.
	 * 
	 */
    public Dimension getPreferredSize() {
		System.out.println("getPreferredSize()");
		return new Dimension(900, 750); 
	}

    /**
     *  @Override
     *  Sets the size for the window.
     */
	public void setSize(int width, int height) {
		System.out.println("setSize(int, int)");
		this.width = width;
		this.height = height;
		super.setSize(width, height);
	}

    /**
     *  @Override
     *  sets the size for the component
     */
	public void setBounds(int x, int y, int width, int height) {
		System.out.println("setBounds(" + x + ", " +
			y + ", " + width + ", " + height + ")");

		if (this.width == width && this.height == height) return;

		this.width = width;
		this.height = height;

		super.setBounds(x, y, width, height);

		image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
	}

	
	/**
	 *  Constructor, sets defaults and mouse listeners.
	 */
    public NoTippingComponent() {

		System.out.println("NoTippingComponent() v2.0" );

		addMouseListener(this);
		addMouseMotionListener(this);
		
		//defaults:
		numPlayers = 2;
		numWeights = 10;
		begin();
	}

    /**
     * This is the function to call from an observer to get an updated UI
     */
	public void update(Graphics g) {
		System.out.println("update(Graphics()");
		
		paint(g);
	}

	
	
	/**
	 * Sets up/Resets the game.
	 */
	private void begin() {

		weights = new ArrayList<Weight>();
		weight_selected = -1;
		whose_turn = 0;
		game_over = false;
		moves = new Stack<Move>();
		phase = 0;
		num_on_grass = 0;
		
		//hard coded 900...
		radius = (900 - 2*OFFSET) / 2;
		discCenter = new Point2D.Double(OFFSET + radius , YOFFSET+ radius );
		
		//add the weights
		for (int i=1; i<=numWeights; i++) {
			Weight w = new Weight(i, 0, 0, 0); //red
			weights.add(w);
			w = new Weight(i, 1, 0, 0); //blue
			weights.add(w);
			for (int j = 2;j<numPlayers;j++) {
				w = new Weight(i,j,0,0);
				weights.add(w);
			}
		}
		Weight w = new Weight(3, 4, 1, -4); //changed 2 to 4 to change color of initial weight
		//note that default is 3.
		//this is a position to put the initial weight that does not tip
		//If you change the layout, you may need to move this weight.
		w.discPos = new Point2D.Double(330,350);
		weights.add(w);
		
		//the invisible weight at the center.
		//default weight is 3.
		w = new Weight(3, 2, 1, 0);
		w.discPos = discCenter;
		w.do_draw = false;
		weights.add(w);


	}

	/**
	 * The master function to update the display.
	 */
    public void paint(Graphics real_g) {
		System.out.println("paint(Graphics)");

		horizon = height*4/5;
		ss_height = height/16;
		f_height = height/10;
		ss_width = width - 100; //originally changed -100 + 16 to -300 + 200
		meter = (ss_width - 16) / 30; //changed 20 to 30

		// find the torques
	
		int n = weights.size();

		Graphics g = image.createGraphics();

		g.setColor(new Color(245, 245, 220));
		g.drawRect(0, 0, width-1, height-200);
		//g.setColor(new Color(110, 110, 110));
		g.fillRect(0, 0, width-1, height-200);
		g.setColor(new Color(204, 204, 204));
		g.drawRect(0, height-200, width-1, 200);
		g.fillRect(0, height-200, width-1, 200);

	
		Graphics2D g2 = (Graphics2D) g;
		
		// draw the disc
		radius = (width - 2*OFFSET) / 2;
	
		Shape circle = new Ellipse2D.Double(OFFSET, YOFFSET, radius*2,radius*2);
		
		g2.setColor(new Color(150, 235, 150));
	
		g2.fill(circle);
	
		//draw the concentric circles
		Shape conCir;
		for (double j = 0;j<radius;j += 40)
		{
			conCir = new Ellipse2D.Double(OFFSET +j, YOFFSET +j, (radius-j)*2,(radius-j)*2);
			g2.setColor(new Color(154, 205, 50));
			g2.draw(conCir);
		}
			
		g2.setPaint(Color.black);
	
	
		
		
		Shape center = new Ellipse2D.Double(discCenter.x -5, discCenter.y -5,10,10);
		g2.setPaint(Color.orange); //changed from black, to distinguish center from fulcrums
		g2.fill(center);
	
		g2.setPaint(Color.black); 
		balance1 = new Point2D.Double(discCenter.x-70,discCenter.y-DISTANCE +30 );
	
		g2.fill(new Ellipse2D.Double(balance1.x -5, balance1.y -5,10,10));
		balance2 = new Point2D.Double (discCenter.x + ((DISTANCE /2)* Math.sqrt(3)) -70, discCenter.y + (DISTANCE/2) +30);
		
		g2.fill(new Ellipse2D.Double(balance2.x -5, balance2.y -5,10,10));
		balance3 = new Point2D.Double (discCenter.x - (DISTANCE/2 * Math.sqrt(3))-70,discCenter.y + DISTANCE/2 +30);
		g2.fill(new Ellipse2D.Double(balance3.x -5, balance3.y -5,10,10));
		
	
		ne = extendLine(balance1.getX(), balance1.getY(), balance2.getX(), balance2.getY());
	
		nw = extendLine(balance1.getX(), balance1.getY(), balance3.getX(), balance3.getY());
	
		s = extendLine(balance2.getX(), balance2.getY(), balance3.getX(), balance3.getY());
	
	
		computeTorque();
	
		//show current torques above the disc
		String torque1_str = Integer.toString(ne_torque);
		String torque2_str = Integer.toString(nw_torque);
		String torque3_str = Integer.toString(s_torque);
		
		String torques = new String("torques: " + torque1_str + " " + torque2_str + " " + torque3_str);
		Color torqueColor = Color.black;
		g.setColor(torqueColor);
		g.drawString(torques, 400, 100);
		Font prevFont = g.getFont();
		g.setFont(new Font(prevFont.getFontName(), Font.BOLD, prevFont.getSize()));
		String directions = new String("NE    NW    S");
		g.drawString(directions, 460, 80);
		g.setFont(prevFont);
		
		
		// draw the weights
		n = weights.size();
		for (int i=0; i<n; i++) {
			Color c;
			Weight w = (Weight)weights.get(i);
			switch(w.whose) {
				case 0:
					c = new Color(200, 0, 0); //red
					break;
				case 1:
					c = new Color(0, 0, 200); //blue
					break;
				case 2: 
					c = Color.GREEN;
					break;
				case 3:
					c = Color.CYAN;
					break;
				default:
					c = Color.MAGENTA;
					break;
			}
			g2.setColor(c);
			Rectangle r = computeRectangle(w);
			if (w.do_draw && (!game_over || w.place == 1)) {
				//System.out.println("should be here");
				g2.fillRect(r.x, r.y, r.width, r.height);
				g2.setColor(new Color(255, 255, 255));
				g2.drawString(Integer.toString(w.w), r.x+2, r.y+r.height-2);
			}
		}

		if (weight_selected >= 0) {
			Weight w = (Weight)weights.get(weight_selected);
			Color c;
			switch(w.whose) {
				case 0:
					c = new Color(200, 0, 0); //red
					break;
				case 1:
					c = new Color(0, 0, 200); //blue
					break;
				case 2: 
					c = Color.GREEN;
					break;
				case 3:
					c = Color.CYAN;
					break;
				default:
					c = Color.MAGENTA;
					break;
			}
			
			g2.setColor(c);
			Rectangle r = new Rectangle(selected_x, selected_y, 18, 17); //changed 12 to 18
			g2.fillRect(r.x, r.y, r.width, r.height);
			g2.setColor(new Color(255, 255, 255));
			//show the new torques that would result if a weight is selected for adding or removal
			if (phase == 0 || phase == 1) {
				String torquesDragged = new String("new torques would be: " + Integer.toString(ne_dragged) + " " + Integer.toString(nw_dragged) + " " + Integer.toString(s_dragged));
				c = Color.black;
				g2.setColor(c);
				g2.drawString(torquesDragged, 600, 120);
			}
			
		}
		
		//when game is over, output the winner and official loser (the tipper)
		if (game_over) {
			Font font = new Font("SansSerif", Font.BOLD, 30);
			g2.setPaint(Color.black);
			g2.fill(circle);
			
			g.setFont(font);
			g.setColor(Color.LIGHT_GRAY);
			g.drawString("Bummer, dude,", 300, 300);

			if (who_lost == 0) {
				// red lost
				g.setColor(Color.red);
				g.drawString("Red tipped the disc :(", 300, 340);
			} else if (who_lost == 1){
				// blue lost
				g.setColor(Color.blue);
				g.drawString("Blue tipped the disc :(", 300, 340);
			}
			else if (who_lost == 2){
				// green lost
				g.setColor(Color.green);
				g.drawString("Green tipped the disc :(", 300, 340);
			}
			else if (who_lost == 3){
				// cyan lost
				g.setColor(Color.cyan);
				g.drawString("Cyan tipped the disc :(", 300, 340);
			}
			
			//the winner is the player who went before the tipper
			 who_won = 0;
			 if(who_lost == 0)
				 who_won = numPlayers - 1;
			 else
				who_won = who_lost - 1;
			 
			 if(who_won == 0)
			 {
				 g.setColor(Color.red);
				 g.drawString("But yay, red won! :)", 300, 380);
				 
			 }
			 else if(who_won == 1)
			 {
				 g.setColor(Color.blue);
				 g.drawString("But yay, blue won! :)", 300, 380);
			 }
			 else if(who_won == 2)
			 {
				 g.setColor(Color.green);
				 g.drawString("But yay, green won! :)", 300, 380);
			 }
			 else if(who_won == 3)
			 {
				 g.setColor(Color.cyan);
				 g.drawString("But yay, cyan won! :)", 300, 380);
			 }
		}
		
		

		// draw the status string (that is, whose turn and which phase it is)
		if (!game_over) {
			Color c;
			String s;
			if (whose_turn == 0) {
				// red's turn
				c = new Color(150, 0, 0);
				s = new String("It's Red's turn");
			} else if (whose_turn == 1){
				// blue's turn
				c = new Color(0, 0, 150);
				s = new String("It's Blue's turn");
			}
			else if (whose_turn == 2)
			{
				//green's turn
				c = Color.GREEN;
				s = new String("It's Green's turn");
				
			}
			else //if (whose_turn == 3)
			{
				//cyan's turn
				c = Color.cyan;
				s = new String("It's Cyan's turn");
			}
			g.setColor(c);
			g.setFont(new Font(Font.SANS_SERIF,Font.BOLD,16));
			g.drawString(s, 30, 110);

			c = new Color(0, 0, 0);
			g.setColor(c);
			if (phase == 0) {
				s = new String("Adding phase");
			} else {
				s = new String("Removing phase");
			}
			g.drawString(s, 30, 130);
		}

		// render the image to the screen

		real_g.drawImage(image, 0, 0, null);

    }

    
    /**
     * Listener for dragging a weight with the mouse
     * Contains the logic for displaying the potential torques
     */
    public void mouseDragged(MouseEvent e) { 
		System.out.println("mouseDragged(MouseEvent)");
		int x = e.getX();
		int y = e.getY();
		if (x < 0) x = 0;
		if (x >= width) x = width-1;
		if (y < 0) y = 0;
		if (y >= height) y = height-1;


		if (weight_selected < 0) return;

		Weight w = (Weight)weights.get(weight_selected);
		int h = 17;
		selected_x = x-6;
		selected_y = y-h/2;
		
		Point p = new Point(selected_x, selected_y);
	
		
		if(discCenter.distance(p) < radius && phase == 0) //weight is in disc, adding phase
		{
			ne_dragged = (int)(computeTorque(selected_x, selected_y, ne, ne_torque));
			nw_dragged = (int)(computeTorque(selected_x, selected_y, nw, nw_torque));
			s_dragged = (int)(computeTorque(selected_x, selected_y, s, s_torque));
			
		}
		
		 else if(phase == 1) //calculate the torques with the selected weight removed
		{
			
			ne_dragged = (int)(computeTorqueRemoved(w, ne, ne_torque));
			nw_dragged = (int)(computeTorqueRemoved(w, nw, nw_torque));
			s_dragged = (int)(computeTorqueRemoved(w, s, s_torque));
		}
		
		else //if weight is not inside disc and it's not the removal phase
		{
			ne_dragged = ne_torque;
			nw_dragged = nw_torque;
			s_dragged = s_torque;
		}
		

		update(getGraphics());
		// repaint();
	}

	public void mouseMoved(MouseEvent e) {}


	// MouseListener stuff

	public void mouseClicked(MouseEvent e) {}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}

	/**
	 * Contains the logic for picking up a weight
	 */
	public void mousePressed(MouseEvent e) {
		System.out.println("mousePressed(MouseEvent)");

		// check if it was pressed on a weight
		int n = weights.size();
		int i;
		for (i=0; i<n; i++) {
			Weight w = (Weight)weights.get(i);
			Rectangle r = computeRectangle(w);
			if (r.contains(e.getPoint())) {
				//if phase 0, you can only pick up weights that are yours
				if (w.whose != whose_turn && phase == 0) continue;
				//if phase 0, you can't pick up weights on the disc
				if (w.place == 1 && phase == 0) continue;
				System.out.println("weight hit");
				weight_selected = i;
				//once it's picked up it should disappear.
				w.do_draw = false;
				selected_x = r.x;
				selected_y = r.y;
				update(getGraphics());
				// repaint();
				break;
			}
		}

	}

	/**
	 * Most of the game logic revolves around mouse release events.
	 * This function checks the state of the game 
	 * and updates states based on where and what the mouse is doing
	 * For example in phase 0, if you release the mouse when you 
	 * have a weight and are over the disc, you release the weight there.
	 * 
	 */
	public void mouseReleased(MouseEvent e) {
		System.out.println("mouseReleased(MouseEvent)");

		if (weight_selected < 0) return;
		Weight w = (Weight)weights.get(weight_selected);
		w.do_draw = true;
		Point p = e.getPoint();

		//from old game--"the grass" is where you can remove weights
		Rectangle grass_rect = new Rectangle(0, height-200, width, 200);
		if (grass_rect.contains(p) && phase == 1) {
			// see if we can remove this piece
			//weight was placed in gray removal area and it's the removal phase

			// remove the piece
			w.place = 2;
			moves.push(new Move(weight_selected, whose_turn, w.position));

			w.position = num_on_grass;
			num_on_grass++;

			changeTurns();
			weight_selected = -1;
			update(getGraphics());
			
			// repaint();
			return;

		}
		
		//weight was placed in disc and it's the removal phase
		//don't allow players to move weights.
		else if(discCenter.distance(p) < radius && phase ==1)
		{
			weight_selected = -1;
			update(getGraphics());
			return;
		}
		
		
		//weight was placed in disc and it's the adding phase
		//make sure that it wasn't placed on top of another weight
		else if ( discCenter.distance(p) < radius && phase == 0)
		{
			
			//make sure weight wasn't placed inside the triangle of fulcrums
			if(ne.relativeCCW(p) > 0 && nw.relativeCCW(p) < 0 && s.relativeCCW(p) > 0)
			{
				weight_selected = -1;
				update(getGraphics());
				return;
			}
			//make sure the weight wasn't placed on top of another weight:
			for (int j=0; j<weights.size(); j++) {
				Weight w2 = (Weight)weights.get(j);
				Rectangle dummy = new Rectangle(p.x,p.y,18,17);
				if (w2.place == 1 && w2.do_draw) /*on the disc, weight is visible*/{
					Rectangle r = computeRectangle(w2);
					if (r.intersects(dummy)) { 
						//System.out.println("should be here");
						weight_selected = -1;
						update(getGraphics());

						return;
					}//inner if
				}//outer if
			}//for
			
			//if we got here, then it's valid to put the weight here:
			w.discPos = new Point2D.Double(selected_x,selected_y); //changed from p.x and p.y
			w.place = 1;
			weight_selected = -1;
			moves.push(new Move(weight_selected, whose_turn, w.position));
			
			//after all the weights have been used by all players, move to next phase
			if (moves.size() == numWeights * numPlayers) phase++;
			
			changeTurns();
			
			update(getGraphics());
		
			
			return;
		}//else if

		weight_selected = -1;
		update(getGraphics());

	}
	
	/**
	 * Used to extend an imaginary line across the disc for computing torques
	 * Inputs are the x and y of the the 2 balances from which to extend the line
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @return a new line that runs across the disc.
	 */
	private Line2D.Double extendLine(double x1,double y1,double x2,double y2)
	{
		double newX1 = x2+ ((x2-x1)/Point2D.distance(x1, y1, x2, y2)*(radius+DISTANCE));
		double newY1 = y2 + ((y2-y1)/Point2D.distance(x1, y1, x2, y2)*(radius+DISTANCE));	
		double newX2 = x1 + ((x1 - x2 )/Point2D.distance(x1, y1, x2, y2)*(radius+DISTANCE));
		double newY2 = y1+ ((y1-y2)/Point2D.distance(x1, y1, x2, y2)*(radius+DISTANCE));
		return new Line2D.Double(newX1,newY1,newX2,newY2);
	}

	/**
	 * Sets the torque variables from scratch by computing for each weight on the disc.
	 * For each balance I compute the torque on both sides of a line that connects each balance.
	 */
	private void computeTorque() {

		ne_torque = 0;
		nw_torque = 0;
		s_torque = 0;
		
		for (int i=0; i< weights.size(); i++) {
			Weight w = (Weight)weights.get(i);	
			if (w.place == 1) {
				ne_torque += ne.relativeCCW(w.discPos)*ne.ptLineDist(w.discPos)*w.w;

				nw_torque += nw.relativeCCW(w.discPos)*nw.ptLineDist(w.discPos)*w.w;
				//nw_torque should be negative to avoid tipping
				

				s_torque += s.relativeCCW(w.discPos)*s.ptLineDist(w.discPos)*w.w;
	
			}
		}
		//System.out.println(ne_torque +" "+ nw_torque + " "+ s_torque);
				

	
		//if nw torque is positive, ne torque is negative, or s torque is negative,
		//the disc has tipped
		if (nw_torque > 0 || ne_torque < 0 || s_torque < 0) {
			if (!game_over) {
				//System.out.println("game over " + whose_turn);
				if (whose_turn == 0) {
					who_lost = numPlayers-1;
				} else {
					who_lost = whose_turn -1 ;
				//	System.out.println("loser " + who_lost);
				}
				for (int i=0; i<weights.size(); i++) {
					Weight w = (Weight)weights.get(i);
					if (w.place == 0) {
						w.do_draw = false;
					}
				}
			}
			game_over = true;
		}
		return;

	}
	
	
/**
 * Computes one of the torques without a particular weight.
 * Used for display in removal phase.
 * @param w
 * @param wall
 * @param torque
 * @return
 */
	private double computeTorqueRemoved(Weight w,Line2D.Double wall, double torque)
	{
		return torque - wall.relativeCCW(w.discPos)*wall.ptLineDist(w.discPos)*w.w;
	}
	
/**
 * Computes one of the torques with the selected weight moved to a particular location.
 * Used for display in adding phase.
 * @param x
 * @param y
 * @param wall
 * @param torque
 * @return
 */
	private double computeTorque(int x,int y,Line2D.Double wall, double torque)
	{
		
		Weight w = (Weight)weights.get(weight_selected);
		Point2D.Double  temp = new Point2D.Double(x,y);
		return torque + wall.relativeCCW(temp)*wall.ptLineDist(temp)*w.w;
		
	}
	
	/**
	 * Used to compute whose turn is next.
	 * 
	 */
    private void changeTurns()
    {
		if (whose_turn == numPlayers-1)
			whose_turn = 0;
		else {
			whose_turn++;
		}
    	
    }
 
    /**
     * Listener for the drop downs in the tool bar.
     * For now, either sets the number of players or the number of weights.
     */
    public void itemStateChanged(ItemEvent e) {
    	Choice c = (Choice) e.getItemSelectable();
    	if (c.getName().equals("Num Players")) {
    		numPlayers = Integer.parseInt((String)e.getItem());
    	} else {
    		numWeights = Integer.parseInt((String)e.getItem());
    	}
    }

}
