package noon;

import static noon.Config.*;

import org.json.JSONException;
import org.json.JSONObject;

public class XY {
	public final int x;	// 0 <= x < BOARD_SIZE
	public final int y;	// 0 <= y < BOARD_SIZE
	public XY(int x, int y) {
		this.x = x;
		this.y = y;
	}
	public JSONObject toJson() throws JSONException {
		JSONObject ret = new JSONObject();
		ret.put("x", x);
		ret.put("y", y);
		return ret;
	}
	
	public XY(JSONObject json) throws JSONException {
		this(json.getInt("x"), json.getInt("y"));
	}
	public boolean equals(Object other) {
		XY xy = (XY)other;
		return xy.x == x && xy.y == y;
	}
	public int hashCode() {
		return x * 13103 + y;
	}
}
