package noon;

import java.util.*;

public class Game {
	
	public interface Player {
		/**
		 * 
		 * @return Player's name.
		 */
		public String getName();
	}
	
	public interface HunterPlayer extends Player {
		/** preyStep may be null. Return null if timeout */
		public Board.HunterStep getHunterStep(Board board, Collection<Board.PreyStep> preySteps);
	}
	
	public interface PreyPlayer extends Player {
		/** Return null if timeout */
		public Board.PreyStep getPreyPlayer(Board board, Collection<Board.HunterStep> hunterSteps);
	}
	
	public static class Result {
		public final int time;
		public final boolean hunterTimeout;
		public final boolean preyTimeout;
		public final boolean hunterInvalid;
		public final boolean preyInvalid;
		public final Board board;
		public final Collection<Board.HunterStep> hunterSteps;
		public final Collection<Board.PreyStep> preySteps;
		public Result(int time, boolean hunterTimeout, boolean preyTimeout,
				boolean hunterInvalid, boolean preyInvalid,
				Board board, Collection<Board.HunterStep> hunterSteps, Collection<Board.PreyStep> preySteps) {
			this.time = time;
			this.hunterTimeout = hunterTimeout;
			this.preyTimeout = preyTimeout;
			this.hunterInvalid = hunterInvalid;
			this.preyInvalid = preyInvalid;
			this.board = board;
			this.hunterSteps = hunterSteps;
			this.preySteps = preySteps;
		}
		// H and P may violate the rule at the same time. How to calculate the score in this case?
/*		public final double getScore() {
			if (hunterTimeout || hunterInvalid) return Double.POSITIVE_INFINITY;
			return time;
		}*/
	}
	
	
	public static Result play(Board.Parameter parameter, HunterPlayer hunter, PreyPlayer prey, ObserverConnector observer) {
		Board board = new Board(parameter);
		Board.PreyStep preyStep = null;
		ArrayList<Board.HunterStep> hunterSteps = new ArrayList<Board.HunterStep>();
		ArrayList<Board.PreyStep> preySteps = new ArrayList<Board.PreyStep>();
		observer.update(new Board(board));
		for (;;) {
			// Hunter's first step
			Board.HunterStep hunterStep0 = hunter.getHunterStep(board, preySteps);
			hunterSteps.add(hunterStep0);
			if (hunterStep0 == null) {
				return new Result(board.getTime(), true, false, false, false, board, hunterSteps, preySteps);
			}
			if (!board.applyHunterStep(hunterStep0)) {
				// something wrong
				System.err.println("Invalid Hunter's step");
//				return new Result(board.getTime(), false, false, true, false, board, hunterSteps, preySteps);
			}
			if (board.isCaught()) {
				return new Result(board.getTime(), false, false, false, false, board, hunterSteps, preySteps);
			}
			board.tick();
			observer.update(new Board(board));
			// Hunter's and Prey's steps
			Board.HunterStep hunterStep1 = hunter.getHunterStep(board, preySteps);
			hunterSteps.add(hunterStep1);
			preyStep = prey.getPreyPlayer(board, hunterSteps);
			preySteps.add(preyStep);
			if (hunterStep1 == null || preyStep == null) {
				return new Result(board.getTime(), hunterStep1 == null, preyStep == null, false, false, board, hunterSteps, preySteps);
			}
			boolean okH = board.applyHunterStep(hunterStep1);
			boolean okP = board.applyPreyStep(preyStep);
			if (!okH) {
				System.err.println("Invalid Hunter's step");
			}
			if (!okP) {
				System.err.println("Invalid Prey's step");
			}
/*			if (!okH || !okP) {
				return new Result(board.getTime(), false, false, !okH, !okP, board, hunterSteps, preySteps);
			}*/
			if (board.isCaught()) {
				return new Result(board.getTime(), false, false, false, false, board, hunterSteps, preySteps);
			}
			board.tick();
			observer.update(new Board(board));
		}
	} 
}
