package simpleGamePlatform;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;


public class DigThatApplet extends GamePlatform implements ActionListener{


	Label player2_info;
	Label no_probes;
	int turn_Number ;
	int number_of_probes;
	TextField player2answer;
	Button Submit_answer;
	Button reset;
	Label inf;
	String info="";
	HashMap<String, Integer> String_integer_mapping = new HashMap< String, Integer>();
	String[] tunnelpath;
	String mode;
	ArrayList<String> probe_list = new ArrayList<String>();
	int N = 0;
	TextField tf;
	TextField numberOfBlocks;
	TextField listOfProbes;
	Button SubmitList;
	Button submitNumber;
	Button Submit_path;
	int[] xpositions = {30,55,110,135,190,215,270,295,350,375,430,455,510};
	int [] ypositions = {30,50,100,120,170,190,240,260,310,330,380,400,450};
	NotMovingPiece [][]pieces = new NotMovingPiece[13][13];
	String [][] pieceName ;
	String [] rownumber = {"A","B","C","D","E","F","G","H","I","J","K","L","M"};
	int[][] path ;
	Container containers;	
	static Map<String,List<String>> mapping =new HashMap<String,List<String>>();
	static Map<String,List<String>> pathMap =new HashMap<String,List<String>>();
	static List<String> pathway = new ArrayList<String>();
	static String failureMessage="";
	Image probe_image;
	int [][] pieceId = {
			{0,1,0,1,0,1,0,1,0,1,0,1,0},
			{2,3,2,3,2,3,2,3,2,3,2,3,2},
			{0,1,0,1,0,1,0,1,0,1,0,1,0},
			{2,3,2,3,2,3,2,3,2,3,2,3,2},
			{0,1,0,1,0,1,0,1,0,1,0,1,0},
			{2,3,2,3,2,3,2,3,2,3,2,3,2},
			{0,1,0,1,0,1,0,1,0,1,0,1,0},
			{2,3,2,3,2,3,2,3,2,3,2,3,2},
			{0,1,0,1,0,1,0,1,0,1,0,1,0},
			{2,3,2,3,2,3,2,3,2,3,2,3,2},
			{0,1,0,1,0,1,0,1,0,1,0,1,0},
			{2,3,2,3,2,3,2,3,2,3,2,3,2},
			{0,1,0,1,0,1,0,1,0,1,0,1,0}
	};


	public void initialize()
	{

		setLayout(new BorderLayout());	

		containers = new Panel();

		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		containers.setLayout(gbl);
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;

		numberOfBlocks = new TextField();
		//numberOfBlocks.setText("Enter Number of Blocks");
		numberOfBlocks.addActionListener(this);
		gbc.gridx=0;
		gbc.gridy=0;
		gbl.setConstraints(numberOfBlocks, gbc);
		containers.add(numberOfBlocks);

		submitNumber = new Button("Submit Maximum Length of Tunnel");
		submitNumber.setActionCommand("Submit Number");
		submitNumber.addActionListener(this);
		gbc.gridx=2;
		gbc.gridy=0;
		gbl.setConstraints(submitNumber, gbc);
		containers.add(submitNumber);

		tf = new TextField();
		//tf.setText("Enter tunnel path here");
		tf.setEchoChar('*');
		tf.addActionListener(this);
		gbc.gridx=0;
		gbc.gridy=1;
		gbl.setConstraints(tf, gbc);
		containers.add(tf);

		Submit_path = new Button("Submit Tunnel Path");
		Submit_path.setActionCommand("Submit Path");
		Submit_path.addActionListener(this);
		gbc.gridx=2;
		gbc.gridy=1;
		gbl.setConstraints(Submit_path, gbc);
		containers.add(Submit_path);


		setVisible(true);
		setEnabled(true);
		//
		listOfProbes = new TextField();
		listOfProbes.setText("Your List of probes will appear here");
		listOfProbes.addActionListener(this);
		gbc.gridx=0;
		gbc.gridy=3;
		gbl.setConstraints(listOfProbes, gbc);
		containers.add(listOfProbes);

		SubmitList = new Button("Submit List of Probes");
		SubmitList.setActionCommand("Submit List");
		SubmitList.addActionListener(this);
		gbc.gridx=2;
		gbc.gridy=3;
		gbl.setConstraints(SubmitList, gbc);
		containers.add(SubmitList);
		//add(player_toolbar);
		setVisible(true);
		setEnabled(true);

		player2answer = new TextField();
		player2answer.setText("Player 2:- Please answer with your path");
		gbc.gridx=0;
		gbc.gridy=4;
		gbl.setConstraints(player2answer, gbc);
		containers.add(player2answer);

		Submit_answer = new Button("Player 2:- Submit Final Answer");
		Submit_answer.setActionCommand("Submit Answer");
		Submit_answer.addActionListener(this);
		gbc.gridx=2;
		gbc.gridy=4;
		gbl.setConstraints(Submit_answer, gbc);
		containers.add(Submit_answer);

		Container information = new Panel();
		GridBagLayout inf_layout = new GridBagLayout();
		GridBagConstraints inf_gbc = new GridBagConstraints();
		information.setLayout(inf_layout);
		inf_gbc.fill = GridBagConstraints.BOTH;
		inf_gbc.weightx = 1.0;

		inf = new Label(info);
		inf.setBackground(Color.YELLOW);
		gbc.gridx=6;
		gbc.gridy=0;
		gbl.setConstraints(inf, gbc);
		containers.add(inf);

		//		Label dummy= new Label();
		//		inf_gbc.gridx=0;
		//		inf_gbc.gridy=2;
		//		inf_layout.setConstraints(dummy, inf_gbc);
		//		information.add(dummy);
		//
		//		Label nouse= new Label();
		//		inf_gbc.gridx=0;
		//		inf_gbc.gridy=1;
		//		inf_layout.setConstraints(nouse, inf_gbc);
		//		information.add(nouse);

		//		reset = new Button("RESET");
		//		reset.setActionCommand("Reset");
		//		inf_gbc.gridx=0;
		//		inf_gbc.gridy=0;
		//		reset.addActionListener(this);
		//		inf_layout.setConstraints(reset, inf_gbc);
		//		information.add(reset);

		reset = new Button("RESET");
		reset.setActionCommand("Reset");
		gbc.gridx=6;
		gbc.gridy=4;
		reset.addActionListener(this);
		gbl.setConstraints(reset, gbc);
		containers.add(reset);

		player2_info= new Label("Player 2 Turn Number:- "+turn_Number+"/2");
		gbc.gridx=6;
		gbc.gridy=1;
		gbl.setConstraints(player2_info, gbc);
		containers.add(player2_info);


		no_probes= new Label("Total Number of Probes used:- "+number_of_probes);
		gbc.gridx=6;
		gbc.gridy=3;
		gbl.setConstraints(no_probes, gbc);
		containers.add(no_probes);
		add(information,"South");
		add(containers,"North");
	}

	public void illuminateCorrectPath()
	{
		for ( String s : pathway)
		{
			if ( pieces[String_integer_mapping.get(s.substring(0,1))][Integer.valueOf(s.substring(1))].color
					!= Color.BLUE)
				pieces[String_integer_mapping.get(s.substring(0,1))][Integer.valueOf(s.substring(1))].setColor(Color.CYAN);
		}

	}

	public void init() {
		info = " Enter N first";
		initialize();
		putPieces();
		createMap();
		createPathMap();
		String_integer_mapping.put("A", 0);
		String_integer_mapping.put("B", 1);
		String_integer_mapping.put("C", 2);
		String_integer_mapping.put("D", 3);
		String_integer_mapping.put("E", 4);
		String_integer_mapping.put("F", 5);
		String_integer_mapping.put("G", 6);
		String_integer_mapping.put("H", 7);
		String_integer_mapping.put("I", 8);
		String_integer_mapping.put("J", 9);
		String_integer_mapping.put("K", 10);
		String_integer_mapping.put("L", 11);
		String_integer_mapping.put("M", 12);
		probe_image = getImage(getCodeBase(), "icon_question.png");
	}

	public void putPieces(){
		Container c=new Panel();
		pieceName= new String[13][13];
		for ( int i = 0 ; i < 13 ; i ++)
		{
			xpositions[i]+=100;
			ypositions[i]+=100;
		}
		for ( int i = 0 ; i < 13 ; i ++)
		{
			for ( int j = 0 ; j < 13 ; j ++)
			{
				String s = rownumber[i]+j;
				pieceName[i][j]= s;
			}
		}
		int width = 0 ;
		int height = 0 ;
		for ( int i = 0 ; i < 13 ; i ++)
		{
			for ( int j = 0 ; j < 13 ; j ++)
			{
				System.out.println("in for");
				NotMovingPiece p = new NotMovingPiece();
				pieces[i][j] = p ;
				if (pieceId[i][j] == 0)
				{
					width = 22 ;
					height = 18 ;
				}
				else if (pieceId[i][j]==1)
				{
					System.out.println("i ..."+i +"  j...."+j);
					width = 22 ;
					height = 48;
				}
				else if (pieceId[i][j] == 2)
				{
					width = 52;
					height = 18;
				}
				else 
				{
					width = 52;
					height = 48;
				}
				System.out.println("width ..."+width +"  height...."+height);
				p.setBounds(xpositions[i], ypositions[j], width, height);
				if ( pieceId[i][j] ==1 || pieceId[i][j]==2)
				{
					p.setColor(Color.red);
					//p.setLabel(pieceName[i][j]);
				}
				else if (pieceId[i][j] == 0 )
				{
					p.setLabel(pieceName[i][j]);
					p.setColor(Color.GREEN);
				}
				else {
					p.setColor(Color.WHITE);
				}

				addPiece(p); 

			}
		}

	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub

		System.out.println("actionPerformed(" + e.getActionCommand() + ")");

		if ( e.getActionCommand().equals("Submit Answer"))
		{
			String player2path = player2answer.getText();
			String [] player2answer = player2path.split(",");
			boolean check_valid_flag = checkValid(player2answer);
			if ( !check_valid_flag)
			{
				JOptionPane.showMessageDialog(this, failureMessage);
			}
			else {
				System.out.println("pathway final"+pathway);
				
				Submit_answer.setEnabled(false);

				if ( mode.equalsIgnoreCase("player2"))
				{
					SubmitList.setEnabled(false);
				}
				for ( int i = 0 ; i < player2answer.length ; i ++)
				{
					player2answer[i] = player2answer[i].toUpperCase();
					System.out.println("final answer "+player2answer[i]);
				}

				int flag = 0 ;
				if ( player2answer.length != tunnelpath.length)
				{
					JOptionPane.showMessageDialog(this, "Sorry ! Your answer is wrong");
					illuminateCorrectPath();
					flag = 1 ;
				}
				int flag2 = 0  ;
				if ( flag == 0 ){
					for ( int i = 0 ; i < player2answer.length ; i ++)
					{
						if ( player2answer[i].compareToIgnoreCase(tunnelpath[i]) != 0 )
						{
							flag2 = 1;
						}
					}

					if ( flag2 == 0 )
					{
						JOptionPane.showMessageDialog(this, "Congratulations !! You got it");
					}
					else
					{
						JOptionPane.showMessageDialog(this, "Sorry ! Your answer is wrong");
						illuminateCorrectPath();
					}
				}
			}
		}

		if (e.getActionCommand().equals("Reset")){

			pathway.clear();
			Submit_answer.setEnabled(true);
			Submit_path.setEnabled(true);
			submitNumber.setEnabled(true);
			SubmitList.setEnabled(true);
			tf.setEnabled(true);
			numberOfBlocks.setEnabled(true);
			player2answer.setText("Player 2:- Please answer with your path");
			N = 0 ;
			probe_list.clear();
			turn_Number = 0 ;
			player2_info.setText(("Player 2 Turn Number:- "+turn_Number+"/2"));
			number_of_probes = 0 ;
			no_probes.setText("Total Number of Probes used:- "+number_of_probes);

			info = "Enter N first";
			inf.setText(info);
			for ( int i = 0 ; i < tunnelpath.length ; i++)
			{
				tunnelpath[i] = "";
			}

			mode = "Player1";
			tf.setText("Enter tunnel path here");
			numberOfBlocks.setText("Enter Number of Blocks");

			listOfProbes.setText("Your List of probes will appear here");
			failureMessage="";

			for ( int i = 0 ; i < 13 ; i ++)
			{
				for ( int j = 0 ; j < 13 ; j ++)
				{
					pieces[i][j].setImage(null);
					if (pieceId[i][j] == 0 )
					{
						pieces[i][j].setColor(Color.GREEN);
					}
					else if(pieceId[i][j] == 1 || pieceId[i][j] == 2)
					{
						pieces[i][j].setColor(Color.RED);
					}
				}
			}

		}

		if (e.getActionCommand().equals("Submit Path")){
			if ( N == 0)
			{
				JOptionPane.showMessageDialog(this, "Please set a valid N");
			}
			String path = tf.getText();
			tunnelpath = path.split(",");

			for ( int i = 0 ; i < tunnelpath.length ; i++)
			{
				tunnelpath[i] = tunnelpath[i].toUpperCase();
			}
			boolean check_valid_flag = checkValid(tunnelpath);
			if ( !check_valid_flag)
			{
				JOptionPane.showMessageDialog(this, failureMessage);
			}

			if ( check_valid_flag)
			{
				inf.setText(" Player 2:- Please start putting the probes now.\n Just click on the intersections");
				mode = "player2";
				player2_info.setText("Player 2 Turn Number:- "+(++turn_Number)+"/2");
				tf.setEnabled(false);
				Submit_path.setEnabled(false);
			}
		}

		if (e.getActionCommand().equals("Submit List")){

			if ( turn_Number == 3 || mode.equalsIgnoreCase("over"))
			{
				mode="over";
				JOptionPane.showMessageDialog(this, "You have submitted twice already");
				SubmitList.setEnabled(false);
			}
			if ( mode.equalsIgnoreCase("player2")){
				turn_Number++;				
				ArrayList<String> path_of_tunnel = new ArrayList<String>();
				Collections.addAll(path_of_tunnel, tunnelpath);
				for ( String s : probe_list)
				{
					System.out.println(" String s of probe list "+ s);
					if (path_of_tunnel.contains(s)){
						pieces[String_integer_mapping.get(s.substring(0,1))][Integer.valueOf(s.substring(1))].setColor(Color.BLUE);
						pieces[String_integer_mapping.get(s.substring(0,1))][Integer.valueOf(s.substring(1))].setImage(null);
						for ( int i = 0 ; i < pathway.size(); i ++)
						{
							System.out.println(" I inside probe list loop"+ i );
							if ( i == 0 )
							{
								if (s.equalsIgnoreCase(pathway.get(i)))
								{
									pieces[String_integer_mapping.get(pathway.get(i+1).substring(0,1))][Integer.valueOf(pathway.get(i+1).substring(1))].setColor(Color.BLUE);
								}
							}
							else if ( i == pathway.size()-1)
							{
								if ( s.equalsIgnoreCase(pathway.get(i)))
								{
									pieces[String_integer_mapping.get(pathway.get(i-1).substring(0,1))][Integer.valueOf(pathway.get(i-1).substring(1))].setColor(Color.BLUE);
								}
							}
							else
							{
								if ( s.equalsIgnoreCase(pathway.get(i)))
								{
									pieces[String_integer_mapping.get(pathway.get(i+1).substring(0,1))][Integer.valueOf(pathway.get(i+1).substring(1))].setColor(Color.BLUE);
									pieces[String_integer_mapping.get(pathway.get(i-1).substring(0,1))][Integer.valueOf(pathway.get(i-1).substring(1))].setColor(Color.BLUE);
								}
							}
						}
					}
					else {
						pieces[String_integer_mapping.get(s.substring(0,1))][Integer.valueOf(s.substring(1))].setColor(Color.BLACK);
						pieces[String_integer_mapping.get(s.substring(0,1))][Integer.valueOf(s.substring(1))].setImage(null);
					}
				}

				if ( turn_Number == 3)
				{
					player2_info.setText("Player 2 Turn Number:-  2");
					inf.setText("Player 2 :- You have finished your play. Submit your answer \n For eg:- a12,a10,c10,c8,c6,c4,c2,e2,g2,g0");
					mode = "over";
					SubmitList.setEnabled(false);
				}
				else {
					player2_info.setText("Player 2 Turn Number:- "+turn_Number+"/2");
					inf.setText("Player 2 :- You have One more turn. \n Just click on the intersections");
				}
				probe_list.clear();
				listOfProbes.setText(probe_list.toString());
			}
		}
		if ( e.getActionCommand().equals("Submit Number")){
			try {
				if ( numberOfBlocks.getText().length() > 4)
				{
					JOptionPane.showMessageDialog(this, "Too big a number");
				}
				N = Integer.valueOf(numberOfBlocks.getText());
				Font font = new Font("Times New Roman",Font.PLAIN,11);
				inf.setFont(font);
				inf.setText(" Thief should start making the tunnel now. \n For eg:- a12,a10,c10,c8,c6,c4,c2,e2,g2,g0");
				font = new Font("Times New Roman",Font.PLAIN,12);
				inf.setFont(font);
				numberOfBlocks.setEnabled(false);
				submitNumber.setEnabled(false);
			}
			catch (Exception ex )
			{
				JOptionPane.showMessageDialog(this, "Please enter a valid number");
			}
			System.out.println("Number "+N);


		}
	}

	public boolean mouseDown(Event e, int x, int y) { 

		if ( mode.equalsIgnoreCase("Player2")){

			for ( int i = 0 ; i < 13 ; i++)
			{
				for ( int j = 0 ; j < 13  ; j ++)
				{
					if ( pieces[i][j].contains(x, y))
					{
						if ( pieceId[i][j]== 0 )
						{
							pieces[i][j].setImage(probe_image);
							probe_list.add(pieceName[i][j]);
							number_of_probes ++;
							listOfProbes.setText(probe_list.toString());
							no_probes.setText("Total Number of Probes used:- "+number_of_probes);
						}
						else
						{
							JOptionPane.showMessageDialog(this, "Probes can only be put on intersections");
						}
					}
				}
			}
		}
		return true;
	}

	public void overlay( Graphics g)
	{
		//g.drawString( probe_list.toString(),40 ,50);
		//g.drawString("Path " +pathway.toString(), 80,80);
	}

	public static void createMap()
	{
		List<String> list;
		char[] forthis={'A','C','E','G','I','K','M'};
		for(char c:forthis )
		{
			switch(c)
			{
			case 'A':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="A"+String.valueOf(i);
						String top="A"+String.valueOf(i-2);
						String right="C"+String.valueOf(i);
						String bottom="A"+String.valueOf(i+2);;
						list.add(top);list.add(right);list.add(bottom);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("C0");list.add("A2");
						mapping.put("A0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("C12");list.add("A10");
						mapping.put("A12",list);      		
					}
				}
				break;
			case 'C':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="C"+String.valueOf(i);
						String top="C"+String.valueOf(i-2);
						String right="E"+String.valueOf(i);
						String left="A"+String.valueOf(i);
						String bottom="C"+String.valueOf(i+2);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("A0");list.add("E0");list.add("C2");
						mapping.put("C0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("A12");list.add("E12");list.add("C10");
						mapping.put("C12",list);      		
					}
				}
				break;
			case 'E':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="E"+String.valueOf(i);
						String top="E"+String.valueOf(i-2);
						String right="G"+String.valueOf(i);
						String left="C"+String.valueOf(i);
						String bottom="E"+String.valueOf(i+2);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("C0");list.add("G0");list.add("E2");
						mapping.put("E0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("C12");list.add("G12");list.add("E10");
						mapping.put("E12",list);      		
					}
				}
				break;
			case 'G':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="G"+String.valueOf(i);
						String top="G"+String.valueOf(i-2);
						String right="I"+String.valueOf(i);
						String left="E"+String.valueOf(i);
						String bottom="G"+String.valueOf(i+2);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("I0");list.add("E0");list.add("G2");
						mapping.put("G0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("I12");list.add("E12");list.add("G10");
						mapping.put("G12",list);      		
					}
				}
				break;
			case 'I':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="I"+String.valueOf(i);
						String top="I"+String.valueOf(i-2);
						String right="K"+String.valueOf(i);
						String left="G"+String.valueOf(i);
						String bottom="I"+String.valueOf(i+2);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("G0");list.add("K0");list.add("I2");
						mapping.put("I0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("G12");list.add("K12");list.add("I10");
						mapping.put("I12",list);      		
					}
				}
				break;
			case 'K':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="K"+String.valueOf(i);
						String top="K"+String.valueOf(i-2);
						String right="I"+String.valueOf(i);
						String left="M"+String.valueOf(i);
						String bottom="K"+String.valueOf(i+2);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("M0");list.add("I0");list.add("K2");
						mapping.put("K0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("M12");list.add("I12");list.add("K10");
						mapping.put("K12",list);      		
					}
				}
				break;
			case 'M':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="M"+String.valueOf(i);
						String top="M"+String.valueOf(i-2);
						String left="K"+String.valueOf(i);
						String bottom="M"+String.valueOf(i+2);;
						list.add(top);list.add(bottom);list.add(left);
						mapping.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("K0");list.add("M2");
						mapping.put("M0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("K12");list.add("M10");
						mapping.put("M12",list);      		
					}
				}
				break;
			default:break;
			}

		}
		System.out.println("mapping "+mapping);
	}

	public static boolean checkValid(String input[]){
		HashSet<String> st=new HashSet<String>();
		for(String dal:input){
			if(!st.contains(dal))
				st.add(dal);
			else{
				failureMessage="Cannot loop to same element";
				return false;
			}
		}
		String[] start={"A12","C12","E12","G12","I12","K12","M12"};
		List<String> naya;
		boolean flag=false;
		for(String s:start){
			if(s.equals(input[0])){
				flag=true;
				break;
			}
		}
		if(!flag){
			failureMessage="Start should be from bottom (eg A12).\n Make sure there is a comma (,) between 2 intersections. \n A valid example of a tunnel would be a12,a10,c10,c8,c6,c4,c2,e2,g2,g0.";
			return false;
		}
		flag=false;
		for(int i=0;i<input.length-1;i++){
			System.out.println("inpoooooooot i "+input[i]);
			System.out.println("mapping size"+mapping.size());
			if(mapping.containsKey(input[i])){
				System.out.println("aya kya ");
				naya=mapping.get(input[i]);
				for(String s1:naya){
					if(s1.equals(input[i+1])){
						flag=true;
						break;
					}
				}
				if(!flag){
					failureMessage="Incorrect route.\n Make sure there is a comma (,) between 2 intersections.\n A valid example of a tunnel would be a12,a10,c10,c8,c6,c4,c2,e2,g2,g0.";
					return false;
				}
				flag=false;
			}
			else{
				System.out.println("naya wala"+input[i]);
				failureMessage="Element not present.\n Make sure there is a comma (,) between 2 intersections.\n A valid example of a tunnel would be a12,a10,c10,c8,c6,c4,c2,e2,g2,g0.";
				return false;
			}
			flag=false;
		}
		String[] end={"A0","C0","E0","G0","I0","K0","M0"};
		for(String endwala:end){
			if(endwala.equals(input[input.length-1])){
				flag=true;
				break;
			}
		}
		if(!flag){
			failureMessage="Route should end at top (eg A0).\n Make sure there is a comma (,) between 2 intersections.\n A valid example of a tunnel would be a12,a10,c10,c8,c6,c4,c2,e2,g2,g0.";
			return false;
		}
		flag=false;
		createPath(input);
		return true;
	}

	public static void createPathMap()
	{
		List<String> list;


		char[] forthis={'A','C','E','G','I','K','M'};
		for(char c:forthis )
		{
			switch(c)
			{
			case 'A':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="A"+String.valueOf(i);
						String top="A"+String.valueOf(i-1);
						String right="B"+String.valueOf(i);
						String bottom="A"+String.valueOf(i+1);;
						list.add(top);list.add(right);list.add(bottom);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("B0");list.add("A1");
						pathMap.put("A0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("B12");list.add("A11");
						pathMap.put("A12",list);      		
					}
				}
				break;
			case 'C':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="C"+String.valueOf(i);
						String top="C"+String.valueOf(i-1);
						String right="D"+String.valueOf(i);
						String left="B"+String.valueOf(i);
						String bottom="C"+String.valueOf(i+1);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("B0");list.add("D0");list.add("C1");
						pathMap.put("C0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("B12");list.add("D12");list.add("C11");
						pathMap.put("C12",list);      		
					}
				}
				break;
			case 'E':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="E"+String.valueOf(i);
						String top="E"+String.valueOf(i-1);
						String right="F"+String.valueOf(i);
						String left="D"+String.valueOf(i);
						String bottom="E"+String.valueOf(i+1);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("D0");list.add("F0");list.add("E1");
						pathMap.put("E0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("D12");list.add("F12");list.add("E11");
						pathMap.put("E12",list);      		
					}
				}
				break;
			case 'G':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="G"+String.valueOf(i);
						String top="G"+String.valueOf(i-1);
						String right="H"+String.valueOf(i);
						String left="F"+String.valueOf(i);
						String bottom="G"+String.valueOf(i+1);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("H0");list.add("F0");list.add("G1");
						pathMap.put("G0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("H12");list.add("F12");list.add("G11");
						pathMap.put("G12",list);      		
					}
				}
				break;
			case 'I':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="I"+String.valueOf(i);
						String top="I"+String.valueOf(i-1);
						String right="J"+String.valueOf(i);
						String left="H"+String.valueOf(i);
						String bottom="I"+String.valueOf(i+1);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("J0");list.add("H0");list.add("I1");
						pathMap.put("I0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("J12");list.add("H12");list.add("I11");
						pathMap.put("I12",list);      		
					}
				}
				break;
			case 'K':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="K"+String.valueOf(i);
						String top="K"+String.valueOf(i-1);
						String right="L"+String.valueOf(i);
						String left="J"+String.valueOf(i);
						String bottom="K"+String.valueOf(i+1);;
						list.add(top);list.add(right);list.add(bottom);list.add(left);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("L0");list.add("J0");list.add("K1");
						pathMap.put("K0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("L12");list.add("J12");list.add("K11");
						pathMap.put("K12",list);      		
					}
				}
				break;
			case 'M':
				for(int i=0;i<=12;i=i+2){
					if(i!=0 && i!=12){
						list=new ArrayList<String>();
						String me="M"+String.valueOf(i);
						String top="M"+String.valueOf(i-1);
						String left="L"+String.valueOf(i);
						String bottom="M"+String.valueOf(i+1);;
						list.add(top);list.add(bottom);list.add(left);
						pathMap.put(me,list);	
					}
					else if(i==0){
						list=new ArrayList<String>();
						list.add("L0");list.add("M1");
						pathMap.put("M0",list);	
					}
					else if(i==12){
						list=new ArrayList<String>();
						list.add("L12");list.add("M11");
						pathMap.put("M12",list);      
					}
				}
				break;
			default:break;
			}

		}
	}

	public static void createPath(String input[]){
		HashSet<String> hs=new HashSet<String>();
		for(int i=0;i<input.length-1;i++){
			pathway.add(input[i]);
			List<String> tempList=pathMap.get(input[i]);
			for(String tempStr:tempList){
				hs.add(tempStr);
			}
			tempList=pathMap.get(input[i+1]);
			for(String tempStr:tempList){
				if(hs.contains(tempStr)){
					pathway.add(tempStr);
					break;
				}
			}
			System.out.println(" you dont know"+pathway.size());
		}
		pathway.add(input[input.length-1]);
		System.out.println("input.size"+input.length);
		System.out.println(" you dont know input - pathway"+pathway.size());

	}

}