/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Random;

public class Voronoi
extends Applet
implements Runnable {
    public static final double LOW = 1.0E-7;
    public static final int MAX_PLAYERS = 8;
    public String THUNKER;
    public String BIGPOLY;
    public String GETWINNER;
    public String GOODGUESS;
    public String HUMAN;
    public String NONE;
    public String COMP1;
    public String COMP2;
    public String COMP3;
    public String COMP4;
    Panel rightPan;
    CardLayout rightPanCard;
    VInfo myInfo;
    Button infoBut;
    int players = 8;
    int turns = 15;
    VPoint[] iPt = new VPoint[(this.turns * this.players + 4) * (this.turns * this.players + 3) / 2];
    int[][] track = new int[(this.turns * this.players + 4) * (this.turns * this.players + 3) / 2][2];
    boolean humanMove;
    boolean done;
    boolean gameOn;
    static final int RAD = 5;
    double total;
    int portWidth;
    int portHeight;
    int screenWidth;
    int screenHeight;
    VPoint[] corner = new VPoint[4];
    VLine[] border = new VLine[4];
    int xmin;
    int xmax;
    int ymin;
    int ymax;
    double[] area;
    VBTree pt = new VBTree(this.turns * this.players);
    VPoly[] polys;
    boolean[] needUpdate;
    public String[] playerName;
    Color[] colors = new Color[8];
    Color[] playerColor = new Color[8];
    String[] Player = new String[8];
    String[] PlayStr = new String[]{"", "", "", "", "", "", "", ""};
    Image playI;
    Image bigI;
    Graphics bigb;
    Graphics myG;
    Graphics playb;
    public Thread play_thread = null;
    VPoint passPt;
    private Button vdDone;
    private Choice[] vdChoice = new Choice[8];
    private Choice vdTurns = new Choice();
    private Panel vdPan = new Panel();
    public int Amount = 10;
    private Button vwDone;
    private Label vwLab;
    private Label vwLab2;
    private Panel vwPan = new Panel();
    private Panel ipPan = new Panel();
    private Label ipLab;
    private Button resetBut;
    public int pauseTime = 2000;
    Properties stringProps;
    public int theWinner = 0;
    public double theWinnerScore = 0.0;
    public String theWinnerName = "not set";
    int pcnt = 0;

    @Override
    public void init() {
        int n;
        int n2;
        Object object;
        Object object2;
        this.stringProps = new Properties();
        String string = this.getParameter("stringFile");
        try {
            object2 = new URL(this.getDocumentBase(), string);
            object = ((URL)object2).openStream();
            this.stringProps.load((InputStream)object);
            System.out.println("using string file: " + string);
        }
        catch (Exception exception) {
            System.out.println("cannot open stringFile " + string + ", using default");
        }
        this.THUNKER = this.stringProps.getProperty("strings.voronoi.thunker", "Thunker");
        this.BIGPOLY = this.stringProps.getProperty("strings.voronoi.bigpoly", "Biggest Poly");
        this.GETWINNER = this.stringProps.getProperty("strings.voronoi.getwinner", "Get Winner");
        this.GOODGUESS = this.stringProps.getProperty("strings.voronoi.goodguess", "Good Guess");
        this.HUMAN = this.stringProps.getProperty("strings.voronoi.human", "Human");
        this.NONE = this.stringProps.getProperty("strings.voronoi.none", "None");
        this.playerName = new String[8];
        this.playerName[0] = this.stringProps.getProperty("strings.voronoi.player1", "Red");
        this.playerName[1] = this.stringProps.getProperty("strings.voronoi.player2", "Blue");
        this.playerName[2] = this.stringProps.getProperty("strings.voronoi.player3", "Green");
        this.playerName[3] = this.stringProps.getProperty("strings.voronoi.player4", "Orange");
        this.playerName[4] = this.stringProps.getProperty("strings.voronoi.player5", "Pink");
        this.playerName[5] = this.stringProps.getProperty("strings.voronoi.player6", "Gray");
        this.playerName[6] = this.stringProps.getProperty("strings.voronoi.player7", "Purple");
        this.playerName[7] = this.stringProps.getProperty("strings.voronoi.player8", "Brown");
        this.vdDone = new Button(this.stringProps.getProperty("strings.voronoi.play", "Play"));
        this.vwDone = new Button(this.stringProps.getProperty("strings.voronoi.playagain", "Play Again"));
        this.ipLab = new Label(this.stringProps.getProperty("strings.voronoi.inprogress", "Game play in progress..."));
        this.resetBut = new Button(this.stringProps.getProperty("strings.voronoi.reset", "Reset"));
        this.COMP1 = this.THUNKER;
        this.COMP2 = this.BIGPOLY;
        this.COMP3 = this.GETWINNER;
        this.COMP4 = this.GOODGUESS;
        this.setLayout(null);
        object2 = this.stringProps.getProperty("strings.voronoi.info", "Info");
        this.infoBut = new Button((String)object2);
        object = this.getFontMetrics(this.getFont());
        int n3 = ((FontMetrics)object).stringWidth((String)object2);
        this.infoBut.reshape(0, 0, n3 + 16, 20);
        this.add(this.infoBut);
        this.infoBut.move(10, 10);
        this.rightPanCard = new CardLayout();
        this.rightPan = new Panel();
        this.rightPan.reshape(485, 0, this.getWidth() - 490, 440);
        this.rightPan.setLayout(this.rightPanCard);
        this.add(this.rightPan);
        this.vdPan.setLayout(new GridLayout(12, 1));
        for (n2 = 2; n2 < 16; ++n2) {
            this.vdTurns.addItem(Integer.toString(n2));
        }
        this.vdTurns.select("10");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new Label(this.stringProps.getProperty("strings.voronoi.turns", "Turns:")));
        panel.add(this.vdTurns);
        this.vdPan.add(panel);
        for (n2 = 0; n2 < 8; ++n2) {
            this.vdChoice[n2] = new Choice();
            this.vdChoice[n2].addItem(this.NONE);
            this.vdChoice[n2].addItem(this.HUMAN);
            this.vdChoice[n2].addItem(this.COMP1);
            this.vdChoice[n2].addItem(this.COMP2);
            this.vdChoice[n2].addItem(this.COMP3);
            this.vdChoice[n2].addItem(this.COMP4);
            panel = new Panel();
            panel.setLayout(new GridLayout(1, 2));
            panel.add(new Label(this.playerName[n2]));
            panel.add(this.vdChoice[n2]);
            this.vdPan.add(panel);
        }
        this.vdChoice[0].select(this.COMP1);
        this.vdChoice[1].select(this.HUMAN);
        this.vdPan.add(this.vdDone);
        this.rightPan.add("VDialog", this.vdPan);
        this.rightPanCard.addLayoutComponent("VDialog", this.vdPan);
        String string2 = "";
        this.vwLab = new Label(string2, 1);
        this.vwLab2 = new Label("", 1);
        this.vwPan.setLayout(new GridLayout(3, 1));
        this.vwPan.add(this.vwLab);
        this.vwPan.add(this.vwLab2);
        this.vwPan.add(this.vwDone);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.vwPan, "North");
        this.rightPan.add("VWin", panel2);
        this.rightPanCard.addLayoutComponent("VWin", panel2);
        this.ipPan.setLayout(new FlowLayout(1, 15, 15));
        this.ipPan.add(this.ipLab);
        this.ipPan.add(this.resetBut);
        this.rightPan.add("IP", this.ipPan);
        this.rightPanCard.addLayoutComponent("IP", this.ipPan);
        this.rightPanCard.show(this.rightPan, "VDialog");
        this.area = new double[this.players];
        this.polys = new VPoly[this.players * this.turns];
        this.needUpdate = new boolean[this.players * this.turns];
        this.colors[0] = new Color(240, 50, 50);
        this.colors[1] = new Color(50, 50, 240);
        this.colors[2] = new Color(50, 200, 50);
        this.colors[3] = Color.orange;
        this.colors[4] = Color.magenta;
        this.colors[5] = new Color(175, 175, 175);
        this.colors[6] = new Color(100, 0, 100);
        this.colors[7] = new Color(200, 100, 50);
        for (n = 0; n < this.iPt.length; ++n) {
            this.iPt[n] = new VPoint();
        }
        for (n = 0; n < 8; ++n) {
            this.Player[n] = this.playerName[n];
            this.playerColor[n] = this.colors[n];
        }
        this.xmin = 0;
        this.xmax = 400;
        this.ymin = 40;
        this.ymax = 440;
        this.corner[0] = new VPoint(this.xmin, this.ymin);
        this.corner[1] = new VPoint(this.xmin, this.ymax);
        this.corner[2] = new VPoint(this.xmax, this.ymax);
        this.corner[3] = new VPoint(this.xmax, this.ymin);
        this.border[0] = new VLine(this.corner[0], this.corner[1]);
        this.border[1] = new VLine(this.corner[1], this.corner[2]);
        this.border[2] = new VLine(this.corner[2], this.corner[3]);
        this.border[3] = new VLine(this.corner[3], this.corner[0]);
        this.portWidth = this.xmax;
        this.portHeight = this.ymax;
        this.screenWidth = this.bounds().width;
        this.screenHeight = this.bounds().height;
        this.setBackground(Color.white);
        this.bigI = this.createImage(this.screenWidth, this.screenHeight);
        this.bigb = this.bigI.getGraphics();
        this.playI = this.createImage(this.portWidth, this.portHeight);
        this.playb = this.playI.getGraphics();
        this.myG = this.getGraphics();
    }

    private void StartOver() {
        int n;
        this.clearthis();
        this.pt.Reset();
        this.PlayStr[0] = this.COMP1;
        this.PlayStr[1] = this.HUMAN;
        this.turns = 10;
        for (n = 2; n < 8; ++n) {
            this.PlayStr[n] = this.NONE;
        }
        this.SetVars();
        for (n = 0; n < this.players; ++n) {
            this.area[n] = 0.0;
        }
        this.gameOn = true;
    }

    private void SetVars() {
        this.players = 8;
        this.play_thread.suspend();
        this.turns = Integer.parseInt(this.vdTurns.getSelectedItem());
        this.players = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.vdChoice[i].getSelectedItem().equals(this.NONE)) continue;
            this.Player[this.players] = this.playerName[i];
            this.PlayStr[this.players] = this.vdChoice[i].getSelectedItem();
            this.playerColor[this.players] = this.colors[i];
            ++this.players;
        }
    }

    public void DrawScreen() {
        int n = this.pt.numPts() % this.players;
        int n2 = 380 / this.players;
        int n3 = (int)Math.floor(this.pt.numPts() / this.players) + 1;
        this.bigb.setColor(Color.darkGray);
        this.bigb.fillRect(0, 0, 400, 40);
        this.bigb.fillRect(400, 40, 80, 20);
        this.bigb.setColor(Color.white);
        this.bigb.drawString(this.stringProps.getProperty("strings.voronoi.title", "The Voronoi Game"), 145, 20);
        this.bigb.drawString(this.stringProps.getProperty("strings.voronoi.score", "Score"), 425, 55);
        this.bigb.setColor(this.playerColor[n]);
        this.bigb.fillRect(400, 0, 80, 40);
        this.bigb.setColor(Color.white);
        this.bigb.drawString(this.Player[n], 402, 15);
        if (n3 > this.turns) {
            this.bigb.drawString(this.stringProps.getProperty("strings.voronoi.gameover", "Game Over"), 402, 35);
        } else {
            this.bigb.drawString(this.stringProps.getProperty("strings.voronoi.turn", "Turn") + ": " + n3 + "/" + this.turns, 402, 35);
        }
        for (int i = 0; i < this.players; ++i) {
            this.bigb.setColor(this.playerColor[i]);
            this.bigb.fillRect(400, 60 + i * n2, 80, n2);
            this.bigb.setColor(Color.white);
            this.bigb.drawString(this.PlayStr[i], 402, 60 + n2 / 2 + i * n2);
            this.bigb.drawString(" " + (int)this.area[i], 402, 75 + n2 / 2 + i * n2);
            this.bigb.setColor(Color.black);
            this.bigb.drawRect(400, 60 + i * n2, 79, n2);
            if (i != n || !this.gameOn || n3 > this.turns) continue;
            this.bigb.drawRect(401, 60 + i * n2 + 1, 77, n2 - 2);
            this.bigb.drawRect(402, 60 + i * n2 + 2, 75, n2 - 4);
        }
        this.bigb.setColor(Color.black);
        this.bigb.drawRect(0, 0, 479, 439);
        this.bigb.drawRect(400, 0, 79, 40);
        this.bigb.drawRect(0, 0, 400, 39);
        this.bigb.drawRect(400, 40, 79, 20);
    }

    @Override
    public void paint(Graphics graphics) {
        this.DrawScreen();
        graphics.drawImage(this.bigI, 0, 0, this);
        if (this.pcnt == 0) {
            this.repaint();
        } else if (this.pcnt == 1) {
            this.showStatus(this.stringProps.getProperty("strings.voronoi.choose", "Choose number of turns and players"));
        }
        ++this.pcnt;
    }

    public void Update(Graphics graphics) {
        graphics.drawImage(this.playI, 0, 0, this);
    }

    public void clear() {
        this.playb.setColor(Color.white);
        this.playb.fillRect(0, 40, 400, 400);
        this.playb.setColor(Color.black);
    }

    public void clearthis() {
        this.myG.setColor(Color.white);
        this.myG.fillRect(0, 40, 400, 400);
        this.myG.setColor(Color.black);
    }

    @Override
    public boolean mouseUp(Event event, int n, int n2) {
        if (!this.humanMove) {
            return true;
        }
        VPoint vPoint = new VPoint(n, n2);
        this.passPt = null;
        if (!this.validPt(vPoint)) {
            return true;
        }
        if ((event.modifiers & 2) != 0) {
            String string = "New poly area:" + this.PolyArea(n, n2);
            this.showStatus(string);
            return true;
        }
        if ((event.modifiers & 1) != 0) {
            String string = "(" + n + "," + n2 + ")";
            this.showStatus(string);
            return true;
        }
        if (this.isDup(vPoint)) {
            return true;
        }
        this.passPt = new VPoint(n, n2);
        this.done = true;
        return true;
    }

    public void FindBisectors(VPoint vPoint, int n) {
        this.pt.FindBisectors(this.border, vPoint, n);
    }

    public int FindIntPoints(VPoint[] vPointArray, int[][] nArray, VPoint vPoint, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n + 3; ++i) {
            VLine vLine = this.pt.bisect(i);
            for (int j = i + 1; j < n + 3; ++j) {
                ++n3;
                VPoint vPoint2 = vLine.Intersect(this.pt.bisect(j));
                if (!this.validIntPt(vPoint2)) continue;
                vPointArray[n2].Set(vPoint2);
                nArray[n2][0] = i;
                nArray[n2][1] = j;
                ++n2;
            }
        }
        return n2;
    }

    public VPoly GetNewPoly(boolean bl, VPoint vPoint, VPoint[] vPointArray, int[][] nArray, VPoint[][] vPointArray2, int n, int n2) {
        VSegment vSegment = new VSegment();
        VPoly vPoly = new VPoly(vPoint);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (vPointArray[i] == null) continue;
            vSegment.Set(vPoint, vPointArray[i]);
            boolean bl2 = this.pt.SetPrevNext(vPointArray[i]) == null;
            boolean bl3 = true;
            int n5 = 0;
            while (!bl2) {
                VPoint vPoint2;
                ++n4;
                bl2 = this.pt.IterDone();
                int n6 = n5 % 2 == 0 ? this.pt.GetNext().num() : this.pt.GetPrev().num();
                if (!(nArray[i][0] == n6 + 4 || nArray[i][1] == n6 + 4 || (vPoint2 = vSegment.Intersect(this.pt.bisect(n6 + 4))) == null || Math.abs(vPointArray[i].dX() - vPoint2.dX()) == 0.0 && Math.abs(vPointArray[i].dY() - vPoint2.dY()) == 0.0 && bl)) {
                    bl3 = false;
                    break;
                }
                ++n5;
            }
            if (!bl3) continue;
            ++n3;
            vPoly.Add(vPointArray[i]);
            if (nArray[i][0] > 3 && bl) {
                this.needUpdate[nArray[i][0] - 4] = true;
            }
            if (nArray[i][1] <= 3 || !bl) continue;
            this.needUpdate[nArray[i][1] - 4] = true;
        }
        return vPoly;
    }

    public void UpdatePolys(VPoint[][] vPointArray, VPoly vPoly) {
        for (int i = 0; i < this.pt.numPts() - 1; ++i) {
            if (!this.needUpdate[i]) continue;
            this.DeleteOldPoints(this.polys[i], this.pt.bisect(i + 4));
            this.AddNewPoints(this.polys[i], vPoly, this.pt.bisect(i + 4));
        }
    }

    public void DrawPolys(Graphics graphics) {
        int n;
        for (n = 0; n < this.players; ++n) {
            this.area[n] = 0.0;
        }
        this.clear();
        this.total = 0.0;
        for (n = 0; n < this.pt.numPts(); ++n) {
            double d = this.polys[n].Area();
            int n2 = n % this.players;
            this.area[n2] = this.area[n2] + d;
            this.total += d;
            this.polys[n].Draw(graphics, this.playerColor[n % this.players]);
            graphics.setColor(Color.black);
            graphics.fillOval(this.pt.point(n).iX() - 5, this.pt.point(n).iY() - 5, 10, 10);
        }
    }

    public void DeleteOldPoints(VPoly vPoly, VLine vLine) {
        double d = vLine.Eval(vPoly.GetCenter());
        VPoint vPoint = new VPoint();
        d /= Math.abs(d);
        int n = vPoly.NumPoints();
        for (int i = 0; i < n; ++i) {
            vPoint = vPoly.Get(i);
            if (vPoint == null) continue;
            double d2 = vLine.Eval(vPoint);
            double d3 = vLine.Eval(vPoint);
            if (!(Math.abs(d2) >= 0.01)) continue;
            if (!(Math.abs(d2) < 0.5) || d2 / Math.abs(d2) != d) {
                // empty if block
            }
            if ((d3 /= Math.abs(d3)) == d) continue;
            vPoly.Delete(vPoint);
            --i;
            --n;
        }
    }

    public void AddNewPoints(VPoly vPoly, VPoly vPoly2, VLine vLine) {
        VPoint[] vPointArray = new VPoint[]{null, null};
        double[] dArray = new double[]{0.0, 0.0};
        for (int i = 0; i < vPoly2.NumPoints(); ++i) {
            int n;
            vPointArray[0] = null;
            vPointArray[1] = null;
            dArray[0] = 5000000.0;
            dArray[1] = 5000000.0;
            VPoint vPoint = vPoly2.Get(i);
            if (Math.abs(vLine.Dist2(vPoint)) < 1.0E-7) {
                double d = vPoint.dX() - vPoly2.GetCenter().dX();
                double d2 = vPoint.dY() - vPoly2.GetCenter().dY();
                double d3 = d * d + d2 * d2;
                for (n = 0; n < 2; ++n) {
                    if (!(d3 < dArray[n])) continue;
                    dArray[n] = d3;
                    vPointArray[n] = vPoint;
                    break;
                }
            }
            for (n = 0; n < 2; ++n) {
                if (vPointArray[n] == null) continue;
                vPoly.Add(vPointArray[n]);
            }
        }
    }

    @Override
    public boolean action(Event event, Object object) {
        if (((String)event.arg).equals("File")) {
            return true;
        }
        if (((String)event.arg).equals(this.stringProps.getProperty("strings.voronoi.info", "Info"))) {
            this.myInfo = new VInfo(this.stringProps);
            return true;
        }
        if (((String)event.arg).equals("Quit")) {
            return true;
        }
        if (((String)event.arg).equals(this.stringProps.getProperty("strings.voronoi.reset", "Reset"))) {
            this.gameOn = false;
            this.rightPanCard.show(this.rightPan, "VDialog");
            this.showStatus(this.stringProps.getProperty("strings.voronoi.choose", "Choose number of turns and players"));
            return true;
        }
        if (event.target == this.vdDone) {
            this.rightPanCard.show(this.rightPan, "IP");
            this.play_thread.resume();
            return true;
        }
        if (event.target == this.vwDone) {
            this.showStatus(this.stringProps.getProperty("strings.voronoi.choose", "Choose number of turns and players"));
            this.rightPanCard.show(this.rightPan, "VDialog");
            this.play_thread.resume();
            this.theWinnerName = "not set";
            this.theWinnerScore = 0.0;
            return true;
        }
        return false;
    }

    public void pause() {
        try {
            Thread.sleep(this.pauseTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        if (this.play_thread == null) {
            this.play_thread = new Thread(this);
            this.play_thread.start();
        }
    }

    @Override
    public void stop() {
        if (this.play_thread != null && this.play_thread.isAlive()) {
            this.play_thread.stop();
        }
        this.play_thread = null;
    }

    @Override
    public void run() {
        while (true) {
            this.StartOver();
            this.Update(this.bigb);
            this.clear();
            this.paint(this.myG);
            while (this.pt.numPts() < this.players * this.turns && this.gameOn) {
                VPoint vPoint = null;
                this.showStatus(this.stringProps.getProperty("strings.voronoi.waitingfor", "Waiting for") + " " + this.Player[this.pt.numPts() % this.players] + " (" + this.PlayStr[this.pt.numPts() % this.players] + ")");
                this.humanMove = false;
                if (this.PlayStr[this.pt.numPts() % this.players].equals(this.THUNKER)) {
                    this.pause();
                    vPoint = this.Thunker();
                } else if (this.PlayStr[this.pt.numPts() % this.players].equals(this.BIGPOLY)) {
                    this.pause();
                    vPoint = this.BigPoly();
                } else if (this.PlayStr[this.pt.numPts() % this.players].equals(this.GETWINNER)) {
                    this.pause();
                    vPoint = this.GetWinner();
                } else if (this.PlayStr[this.pt.numPts() % this.players].equals(this.GOODGUESS)) {
                    this.pause();
                    vPoint = this.GoodGuess();
                } else if (this.PlayStr[this.pt.numPts() % this.players].equals(this.HUMAN)) {
                    this.humanMove = true;
                    vPoint = null;
                    this.done = false;
                    while (!this.done && this.gameOn) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.humanMove = false;
                    vPoint = this.passPt;
                }
                if (vPoint == null) continue;
                this.AddPt(vPoint);
                this.DrawPolys(this.playb);
                if ((int)this.total != 160000) {
                    // empty if block
                }
                this.Update(this.bigb);
                this.clear();
                this.paint(this.myG);
            }
            if (!this.gameOn) continue;
            this.showStatus(this.stringProps.getProperty("strings.voronoi.gameover", "Game Over"));
            this.GameOverBox();
        }
    }

    public void GameOverBox() {
        double d = this.area[0];
        int n = 0;
        for (int i = 1; i < this.players; ++i) {
            if (!(d < this.area[i])) continue;
            d = this.area[i];
            this.theWinner = n = i;
            this.theWinnerScore = this.area[i];
        }
        this.vwLab.setText(this.stringProps.getProperty("strings.voronoi.winner", "And the winner is") + "...");
        String string = "";
        for (int i = 0; i < 8; ++i) {
            if (this.playerColor[n] != this.colors[i]) continue;
            string = string + " " + this.playerName[i];
            this.theWinnerName = this.playerName[i];
            break;
        }
        this.theWinnerName = this.theWinnerName + " (" + this.PlayStr[n] + ") ";
        string = string + " " + this.PlayStr[n];
        this.vwLab2.setText(string);
        this.rightPanCard.show(this.rightPan, "VWin");
        this.play_thread.suspend();
    }

    public int PolyArea(double d, double d2) {
        int n = (int)this.NewPoly(new VPoint(d, d2), false, null).Area();
        return n;
    }

    public void AddPt(VPoint vPoint) {
        VPoint[][] vPointArray = new VPoint[this.pt.numPts()][10];
        for (int i = 0; i < this.players * this.turns; ++i) {
            this.needUpdate[i] = false;
        }
        this.pt.Add(new VPoint(vPoint));
        this.polys[this.pt.numPts() - 1] = new VPoly(this.NewPoly(vPoint, true, vPointArray));
    }

    public VPoly NewPoly(VPoint vPoint, boolean bl, VPoint[][] vPointArray) {
        int n = bl ? this.pt.numPts() : this.pt.numPts() + 1;
        this.FindBisectors(vPoint, n);
        int n2 = this.FindIntPoints(this.iPt, this.track, vPoint, n);
        this.pt.Sort(vPoint, n - 1);
        VPoly vPoly = this.GetNewPoly(bl, vPoint, this.iPt, this.track, vPointArray, n2, n);
        if (bl) {
            this.UpdatePolys(vPointArray, vPoly);
        }
        return vPoly;
    }

    private VPoint Thunker() {
        Random random = new Random();
        boolean bl = true;
        VPoint vPoint = new VPoint();
        while (bl) {
            int n = Math.abs(random.nextInt() % (this.xmax - this.xmin - 1)) + this.xmin + 1;
            int n2 = Math.abs(random.nextInt() % (this.ymax - this.ymin - 1)) + this.ymin + 1;
            vPoint.Set(n, n2);
            bl = this.isDup(vPoint);
        }
        return vPoint;
    }

    private VPoint BigPoly() {
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        int n = 0;
        VPoint vPoint = new VPoint();
        if (this.pt.numPts() == 0) {
            vPoint.Set(200, 200);
            return vPoint;
        }
        for (int i = 0; i < this.pt.numPts(); ++i) {
            if (!((double)lArray[0] < this.polys[i].PArea) || this.pt.numPts() % this.players == i % this.players) continue;
            n = i;
            lArray[0] = (long)this.polys[i].PArea;
        }
        return this.EvalPoly(n);
    }

    private VPoint GetWinner() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = (int)Math.floor(this.pt.numPts() / this.players);
        VPoint vPoint = new VPoint();
        if (this.pt.numPts() == 0) {
            vPoint.Set(200, 200);
            return vPoint;
        }
        for (n = 0; n < this.players; ++n) {
            if (!(this.area[n2] < this.area[n]) || this.pt.numPts() % this.players == n) continue;
            n2 = n;
        }
        for (n = 0; n < n4; ++n) {
            n3 = n * this.players + n2;
        }
        return this.EvalPoly(n3);
    }

    private VPoint EvalPoly(int n) {
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        int n2 = -1;
        VPoint vPoint = new VPoint();
        VPoint[] vPointArray = new VPoint[4];
        vPoint = this.polys[n].GetCenter();
        vPointArray[0] = new VPoint(vPoint.dX() + 10.0, vPoint.dY() + 9.0);
        vPointArray[1] = new VPoint(vPoint.dX() - 9.0, vPoint.dY() + 10.0);
        vPointArray[2] = new VPoint(vPoint.dX() + 10.0, vPoint.dY() - 9.0);
        vPointArray[3] = new VPoint(vPoint.dX() - 9.0, vPoint.dY() - 10.0);
        for (int i = 0; i < 4; ++i) {
            if (this.isDup(vPointArray[i]) || !this.validPt(vPointArray[i])) {
                lArray[i] = 0L;
                continue;
            }
            n2 = i;
            lArray[i] = this.PolyArea(vPointArray[i].dX(), vPointArray[i].dY());
        }
        if (n2 == -1) {
            return this.Thunker();
        }
        if (lArray[0] > lArray[1]) {
            vPoint = vPointArray[0];
            n2 = 0;
        } else {
            vPoint = vPointArray[1];
            n2 = 1;
        }
        if (lArray[2] > lArray[n2]) {
            vPoint = vPointArray[2];
            n2 = 2;
        } else if (lArray[3] > lArray[n2]) {
            vPoint = vPointArray[3];
            n2 = 3;
        }
        return vPoint;
    }

    private VPoint GoodGuess() {
        int n;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Random random = new Random();
        VPoint[] vPointArray = new VPoint[10];
        long l = 0L;
        long l2 = 0L;
        for (n = 0; n < 10; ++n) {
            bl = true;
            while (bl) {
                n2 = Math.abs(random.nextInt() % (this.xmax - this.xmin - 1)) + this.xmin + 1;
                n3 = Math.abs(random.nextInt() % (this.ymax - this.ymin - 1)) + this.ymin + 1;
                vPointArray[n] = new VPoint(n2, n3);
                bl = this.isDup(vPointArray[n]);
            }
        }
        for (n = 0; n < 10; ++n) {
            l2 = this.PolyArea(vPointArray[n].dX(), vPointArray[n].dY());
            if (l >= l2) continue;
            l = l2;
            n4 = n;
        }
        return vPointArray[n4];
    }

    public boolean isDup(VPoint vPoint) {
        for (int i = 0; i < this.pt.numPts(); ++i) {
            if (!this.pt.point(i).equals(vPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean validIntPt(VPoint vPoint) {
        if (vPoint == null) {
            return false;
        }
        return vPoint.dX() >= (double)(this.xmin - 1) && vPoint.dX() <= (double)(this.xmax + 1) && vPoint.dY() >= (double)(this.ymin - 1) && vPoint.dY() <= (double)(this.ymax + 1);
    }

    public boolean validPt(VPoint vPoint) {
        if (vPoint == null) {
            return false;
        }
        return vPoint.dX() > (double)this.xmin && vPoint.dX() < (double)this.xmax && vPoint.dY() > (double)this.ymin && vPoint.dY() < (double)this.ymax;
    }

    public int getTheWinner() {
        return this.theWinner;
    }

    public double getTheWinnerScore() {
        return this.theWinnerScore;
    }

    public String getTheWinnerName() {
        return this.theWinnerName;
    }

    public String getNamePl() {
        return this.PlayStr[1];
    }
}

