/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class ViewPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    JumpSnatchApplet parent;
    public boolean debug;
    private boolean firstTime = true;
    private boolean gameStart = false;
    private boolean gameOver = false;
    private int numOfSnatch = 0;
    private int numOfSlide = 0;
    private int numOfJump = 0;
    Button doneButton = null;
    Button buttonGameHelp = null;
    private HelpFrame helpFrame;
    private int boardSize = 3;
    public static final int BOARD_SIZE_3 = 3;
    public static final int BOARD_SIZE_4 = 4;
    public static final int BOARD_SIZE_5 = 5;
    private int snatcherId = 0;
    private int jumperId = 0;
    private MoveList moveListHuman = null;
    private Player lastPlayer = null;
    private MoveList lastMoveList = null;
    private String lastMsg = null;
    private int gridspace = 4;
    private int gridlines = 3;
    private int min_x;
    private int max_x;
    private int min_y;
    private int max_y;
    private int centerX;
    private int centerY;
    private int mousePresX;
    private int mousePresY;
    private int mouseDragX;
    private int mouseDragY;
    private int mouseRlseX;
    private int mouseRlseY;
    private boolean mousePres = false;
    private boolean mouseDrag = false;
    private boolean mouseRlse = true;
    private boolean invalidJump = false;
    private boolean invalidSlide = false;
    private int stoneSelIdxX;
    private int stoneSelIdxY;
    private int sel_min_x;
    private int sel_max_x;
    private int sel_min_y;
    private int sel_max_y;
    private boolean stoneSel = false;
    ActionListener actionDone = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewPanel.this.actionDone();
        }
    };
    ActionListener actionGameHelp = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewPanel.this.helpFrame.setVisible(true);
        }
    };

    ViewPanel(JumpSnatchApplet jumpSnatchApplet) {
        this.parent = jumpSnatchApplet;
        this.debug = jumpSnatchApplet.debug;
        this.setLayout(null);
        this.doneButton = new Button("End My Turn");
        int n = (int)Math.round((double)this.parent.size().width * 0.81);
        int n2 = 15;
        int n3 = (int)Math.round((double)this.parent.size().width * 0.18);
        int n4 = 35;
        this.doneButton.setBounds(n, n2, n3, n4);
        this.add(this.doneButton);
        this.doneButton.addActionListener(this.actionDone);
        this.doneButton.setEnabled(false);
        this.doneButton.setVisible(false);
        this.helpFrame = new HelpFrame();
        this.helpFrame.setVisible(false);
        this.buttonGameHelp = new Button(" H e l p ");
        n = (int)Math.round((double)this.parent.size().width * 0.01);
        n2 = 15;
        n3 = (int)Math.round((double)this.parent.size().width * 0.14);
        n4 = 35;
        this.buttonGameHelp.setBounds(n, n2, n3, n4);
        this.add(this.buttonGameHelp);
        this.buttonGameHelp.addActionListener(this.actionGameHelp);
        this.init();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void init() {
        this.moveListHuman = new MoveList();
        this.parent.game.start(this.snatcherId, this.jumperId);
        if (this.debug) {
            System.out.println("viewpanel init()...");
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void setBoardSize(int n) {
        this.boardSize = n;
        this.parent.game.newGame(n);
        this.initSize();
        this.repaint();
    }

    public void setSnatcherId(int n) {
        this.snatcherId = n;
    }

    public void setJumperId(int n) {
        this.jumperId = n;
    }

    public void actionNewGame() {
        this.parent.game.newGame(this.boardSize);
        this.parent.resetWinner();
        this.resetNumOfMoves();
        this.gameStart = false;
        this.gameOver = false;
        this.disableDoneButton();
        this.repaint();
    }

    public void actionGameStart() {
        this.parent.game.start(this.snatcherId, this.jumperId);
        if (this.snatcherId == 0 || this.jumperId == 0) {
            this.moveListHuman = new MoveList();
        }
        this.resetNumOfMoves();
        this.gameStart = true;
        this.gameOver = false;
        this.disableDoneButton();
        this.repaint();
    }

    public void actionGameOver() {
        this.gameStart = false;
        this.gameOver = true;
        this.lastPlayer = this.parent.game.getNextPlayer();
        if (this.lastMsg == null || this.lastMsg.length() == 0) {
            this.parent.winner = this.lastPlayer.getName();
            this.lastMsg = "Game over and the winner is " + this.parent.winner;
        } else {
            Player player = this.parent.game.snatcher;
            if (this.lastPlayer.getType() == 0) {
                player = this.parent.game.jumper;
            }
            this.parent.winner = player.getName();
            this.lastMsg = "Game over and the winner is " + this.parent.winner;
        }
        if (this.debug) {
            System.out.println(this.lastMsg);
        }
        this.disableDoneButton();
    }

    public void actionDone() {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.noValidOfMove()) {
            bl = this.parent.game.play(this.lastPlayer, this.lastMoveList);
            this.lastMsg = this.parent.game.getLastMsg();
            bl2 = this.parent.game.isGameOver();
            if (bl2) {
                this.actionGameOver();
            }
            this.moveListHuman = new MoveList();
            this.resetNumOfMoves();
            this.disableDoneButton();
            this.repaint();
        }
    }

    public void enableDoneButton() {
        this.doneButton.setEnabled(true);
        this.doneButton.setVisible(true);
    }

    public void disableDoneButton() {
        this.doneButton.setEnabled(false);
        this.doneButton.setVisible(false);
    }

    public void initSize() {
        this.gridlines = this.boardSize;
        this.gridspace = Math.round((this.size().height - 40) / (this.gridlines * 2 + 1));
        this.centerX = this.size().width / 2;
        this.centerY = (this.size().height - 40) / 2 + 30;
        if (this.debug) {
            System.out.println("viewpanel initSize() - w " + this.parent.size().width + " h " + this.parent.size().height + " s " + this.gridspace + " centerX " + this.centerX + " centerY " + this.centerY + " wp " + this.size().width + " wh " + this.size().height);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.parent.size().height == this.size().height) {
            return;
        }
        if (this.firstTime) {
            this.initSize();
        }
        this.min_x = this.centerX - this.gridspace * this.gridlines;
        this.max_x = this.centerX + this.gridspace * this.gridlines;
        this.min_y = this.centerY - this.gridspace * this.gridlines;
        this.max_y = this.centerY + this.gridspace * this.gridlines;
        if (this.debug) {
            System.out.println("paint() - w " + this.parent.size().width + " h " + this.parent.size().height + " s " + this.gridspace + " centerX " + this.centerX + " centerY " + this.centerY + " wp " + this.size().width + " wh " + this.size().height);
        }
        this.parent.hiddengraphics.setColor(new Color(245, 245, 245));
        this.parent.hiddengraphics.fillRect(0, 0, this.size().width, this.size().height);
        this.parent.hiddengraphics.setColor(Color.black);
        this.parent.hiddengraphics.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        int n4 = 0;
        this.parent.hiddengraphics.setColor(Color.lightGray);
        n4 = 0;
        for (n3 = -this.gridlines; n3 <= this.gridlines; ++n3) {
            n2 = this.centerX + n3 * this.gridspace;
            if (++n4 % 2 != 1) continue;
            this.parent.hiddengraphics.drawLine(n2, this.min_y, n2, this.max_y);
        }
        n4 = 0;
        for (n3 = -this.gridlines; n3 <= this.gridlines; ++n3) {
            n = this.centerY + n3 * this.gridspace;
            if (++n4 % 2 != 1) continue;
            this.parent.hiddengraphics.drawLine(this.min_x, n, this.max_x, n);
        }
        int n5 = (int)Math.round((double)this.gridspace * 0.75);
        n4 = 2 * n5;
        n3 = 0;
        Color color = new Color(0, 220, 0);
        boolean[][] blArray = this.parent.game.board.getRawBoard();
        for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                if (blArray[i][j]) continue;
                n3 = 0;
                this.parent.hiddengraphics.setColor(color);
                if (this.stoneSel && this.stoneSelIdxX == i && this.stoneSelIdxY == j) {
                    n3 = 1;
                }
                if (n3 != 0) continue;
                int n6 = i * 2 + 1 - this.gridlines;
                int n7 = this.gridlines - j * 2 - 1;
                n2 = this.centerX + n6 * this.gridspace;
                n = this.centerY + n7 * this.gridspace;
                this.parent.hiddengraphics.fillOval(n2 - n5, n - n5, n4, n4);
            }
        }
        if (this.stoneSel) {
            this.parent.hiddengraphics.setColor(Color.red);
            this.parent.hiddengraphics.fillOval(this.mouseDragX - n5, this.mouseDragY - n5, n4, n4);
        }
        if (!this.gameOver) {
            if (this.gameStart) {
                if (this.parent.game.board.isBoardFull()) {
                    this.displayRedString("Snatcher's Turn: snatch one piece off the board", 200, 35);
                } else {
                    Player player = this.parent.game.getNextPlayer();
                    if (player.getType() == 1) {
                        this.displayBlueString("Jumper's Turn", 300, 35);
                    } else {
                        this.displayRedString("Snatcher's Turn", 300, 35);
                    }
                    if (this.doneButton.isVisible()) {
                        this.displayMsgString("At least one more jump is possible.  Please either take it or hit 'End My Turn'", 145, 55);
                    } else if (this.invalidJump) {
                        this.displayMsgString("Undid the move because Player has to jump in this situation.", 200, 55);
                    } else if (this.invalidSlide) {
                        if (this.parent.game.board.isCenterPiece(new Move(this.stoneSelIdxX, this.stoneSelIdxY))) {
                            this.displayMsgString("Undid the move because the center piece could not be moved in this situation.", 145, 55);
                        } else {
                            this.displayMsgString("Undid the move because Player has to move one piece towards the center in this situation.", 120, 55);
                        }
                    }
                }
            } else {
                this.displayString("Press Start button to play the game", 230, 35);
            }
        } else if (this.lastPlayer.getType() == 0) {
            this.displayRedString(this.lastMsg, 200, 35);
        } else {
            this.displayBlueString(this.lastMsg, 200, 35);
        }
        graphics.drawImage(this.parent.hiddenimagebuffer, 0, 0, this);
        this.firstTime = false;
    }

    public void displayMsgString(String string, int n, int n2) {
        Font font = new Font("Arial", 0, 12);
        this.parent.hiddengraphics.setFont(font);
        this.parent.hiddengraphics.setColor(Color.black);
        this.parent.hiddengraphics.drawString(string, n, n2);
    }

    public void displayString(String string, int n, int n2) {
        Font font = new Font("Arial", 1, 13);
        this.parent.hiddengraphics.setFont(font);
        this.parent.hiddengraphics.setColor(Color.black);
        this.parent.hiddengraphics.drawString(string, n, n2);
    }

    public void displayBlueString(String string, int n, int n2) {
        Font font = new Font("Arial", 1, 13);
        this.parent.hiddengraphics.setFont(font);
        this.parent.hiddengraphics.setColor(Color.blue);
        this.parent.hiddengraphics.drawString(string, n, n2);
    }

    public void displayRedString(String string, int n, int n2) {
        Font font = new Font("Arial", 1, 13);
        this.parent.hiddengraphics.setFont(font);
        this.parent.hiddengraphics.setColor(Color.red);
        this.parent.hiddengraphics.drawString(string, n, n2);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean insideBoard(int n, int n2) {
        boolean bl = false;
        if (this.inside(n, n2) && n > this.min_x && n < this.max_x && n2 > this.min_y && n2 < this.max_y) {
            bl = true;
        }
        return bl;
    }

    public void resetNumOfMoves() {
        this.numOfSnatch = 0;
        this.numOfSlide = 0;
        this.numOfJump = 0;
        this.invalidJump = false;
        this.invalidSlide = false;
    }

    public boolean noValidOfMove() {
        boolean bl = false;
        if (this.numOfSnatch + this.numOfSlide + this.numOfJump == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean validNumOfMoves() {
        boolean bl = false;
        if (this.numOfSnatch + this.numOfSlide + this.numOfJump == 1) {
            bl = true;
        } else if (this.numOfSnatch == 1 && this.numOfSlide + this.numOfJump == 0) {
            bl = true;
        } else if (this.numOfSlide == 1 && this.numOfSnatch + this.numOfJump == 0) {
            bl = true;
        } else if (this.numOfJump >= 1 && this.numOfSnatch + this.numOfSlide == 0) {
            bl = true;
        }
        if (this.debug) {
            System.out.println("validNumOfMoves() -  numOfSnatch " + this.numOfSnatch + " numOfSlide " + this.numOfSlide + " numOfJump " + this.numOfJump + " lbValid " + bl);
        }
        return bl;
    }

    public boolean mouseHitStone(int n, int n2) {
        boolean bl = false;
        boolean[][] blArray = this.parent.game.board.getRawBoard();
        int n3 = (int)Math.round((double)this.gridspace * 0.5);
        int n4 = 2 * n3;
        block0: for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                if (blArray[i][j]) continue;
                int n5 = i * 2 + 1 - this.gridlines;
                int n6 = this.gridlines - j * 2 - 1;
                int n7 = this.centerX + n5 * this.gridspace;
                int n8 = this.centerY + n6 * this.gridspace;
                int n9 = n7 - n3;
                int n10 = n7 + n3;
                int n11 = n8 - n3;
                int n12 = n8 + n3;
                if (n <= n9 || n >= n10 || n2 <= n11 || n2 >= n12) continue;
                bl = true;
                this.stoneSel = true;
                this.stoneSelIdxX = i;
                this.stoneSelIdxY = j;
                this.sel_min_x = n7 - this.gridspace;
                this.sel_max_x = n7 + this.gridspace;
                this.sel_min_y = n8 - this.gridspace;
                this.sel_max_y = n8 + this.gridspace;
                continue block0;
            }
        }
        return bl;
    }

    public Move getSelReleasedMove(int n, int n2) {
        Move move = null;
        boolean bl = false;
        boolean[][] blArray = this.parent.game.board.getRawBoard();
        int n3 = (int)Math.round((double)this.gridspace * 0.75);
        block0: for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                int n4 = i * 2 + 1 - this.gridlines;
                int n5 = this.gridlines - j * 2 - 1;
                int n6 = this.centerX + n4 * this.gridspace;
                int n7 = this.centerY + n5 * this.gridspace;
                int n8 = n6 - n3;
                int n9 = n6 + n3;
                int n10 = n7 - n3;
                int n11 = n7 + n3;
                if (n <= n8 || n >= n9 || n2 <= n10 || n2 >= n11) continue;
                bl = true;
                move = new Move(i, j);
                continue block0;
            }
        }
        return move;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.gameStart) {
            return;
        }
        this.mousePresX = mouseEvent.getX();
        this.mousePresY = mouseEvent.getY();
        this.mousePres = true;
        this.mouseDrag = false;
        this.mouseRlse = false;
        this.stoneSel = false;
        if (this.insideBoard(this.mousePresX, this.mousePresY) && this.mouseHitStone(this.mousePresX, this.mousePresY)) {
            this.stoneSel = true;
            if (this.debug) {
                System.out.println("mousePressed() - hit stone mousePresX " + this.mousePresX + " mousePresY " + this.mousePresY + " i " + this.stoneSelIdxX + " j " + this.stoneSelIdxY + " wp " + this.size().width + " wh " + this.size().height);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.invalidJump = false;
        this.invalidSlide = false;
        if (!this.gameStart) {
            return;
        }
        this.mouseDragX = mouseEvent.getX();
        this.mouseDragY = mouseEvent.getY();
        this.mouseDrag = true;
        this.mouseRlse = false;
        if (this.insideBoard(this.mouseDragX, this.mouseDragY)) {
            if (this.stoneSel) {
                if (this.debug) {
                    System.out.println("mouseDragged() -  mouseDragX " + this.mouseDragX + " mouseDragY " + this.mouseDragY + " s " + this.gridspace + " wp " + this.size().width + " wh " + this.size().height);
                }
                this.repaint();
            }
        } else if (this.stoneSel) {
            if (this.debug) {
                System.out.println("mouseDragged() -  mouseDragX " + this.mouseDragX + " mouseDragY " + this.mouseDragY + " s " + this.gridspace + " wp " + this.size().width + " wh " + this.size().height);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.invalidJump = false;
        this.invalidSlide = false;
        if (!this.gameStart) {
            return;
        }
        this.mouseRlseX = mouseEvent.getX();
        this.mouseRlseY = mouseEvent.getY();
        this.mouseRlse = true;
        boolean[][] blArray = this.parent.game.board.getRawBoard();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.moveListHuman = new MoveList();
        if (this.insideBoard(this.mouseRlseX, this.mouseRlseY)) {
            if (this.stoneSel) {
                Move move;
                if (this.debug) {
                    System.out.println("mouseReleased() -  mouseRlseX " + this.mouseRlseX + " mouseRlseY " + this.mouseRlseY + " s " + this.gridspace + " wp " + this.size().width + " wh " + this.size().height);
                }
                if ((move = this.getSelReleasedMove(this.mouseRlseX, this.mouseRlseY)) != null && blArray[move.x][move.y]) {
                    this.moveListHuman.add(new Move(this.stoneSelIdxX, this.stoneSelIdxY));
                    this.moveListHuman.add(move);
                    if (this.debug) {
                        System.out.println("mouseReleased() - move from : " + this.moveListHuman.first().toString());
                        System.out.println("mouseReleased() - move to   : " + move.toString());
                    }
                    this.lastMsg = this.parent.game.board.editMoves(this.moveListHuman);
                    if (this.lastMsg == null) {
                        if (this.moveListHuman.first().type == 2) {
                            ++this.numOfJump;
                        } else if (this.moveListHuman.first().type == 1) {
                            ++this.numOfSlide;
                        }
                        if (this.validNumOfMoves()) {
                            bl3 = true;
                            this.parent.game.board.executeMoves(this.moveListHuman);
                            bl = this.parent.game.isGameOver();
                            if (this.moveListHuman.first().type == 1) {
                                bl2 = true;
                            } else if (this.parent.game.board.hasValidJumps()) {
                                this.enableDoneButton();
                            } else {
                                bl2 = true;
                            }
                        }
                    }
                }
                this.repaint();
            }
        } else if (this.stoneSel) {
            if (this.debug) {
                System.out.println("mouseReleased() -  mouseRlseX " + this.mouseRlseX + " mouseRlseY " + this.mouseRlseY + " s " + this.gridspace + " wp " + this.size().width + " wh " + this.size().height);
            }
            this.moveListHuman.add(new Move(this.stoneSelIdxX, this.stoneSelIdxY));
            this.lastMsg = this.parent.game.board.editMoves(this.moveListHuman);
            if (this.lastMsg == null) {
                if (this.moveListHuman.first().type == 0) {
                    ++this.numOfSnatch;
                }
                if (this.validNumOfMoves()) {
                    bl3 = true;
                    this.parent.game.board.executeMoves(this.moveListHuman);
                    bl2 = true;
                }
            }
            this.repaint();
        }
        if (bl) {
            this.actionGameOver();
        } else if (bl2) {
            this.actionDone();
        } else if (!bl3) {
            if (this.parent.game.board.hasValidJumps()) {
                this.invalidJump = true;
            } else {
                this.invalidSlide = true;
            }
        }
        this.mousePres = false;
        this.mouseDrag = false;
        this.stoneSel = false;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

