/*
 * Decompiled with CFR 0.152.
 */
package wordwrestlegame;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class FancyCaret
extends DefaultCaret {
    @Override
    protected synchronized void damage(Rectangle r) {
        if (r == null) {
            return;
        }
        this.x = r.x;
        this.y = r.y;
        this.height = r.height;
        if (this.width <= 0) {
            this.width = this.getComponent().getWidth();
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        char dotChar;
        JTextComponent comp = this.getComponent();
        if (comp == null) {
            return;
        }
        int dot = this.getDot();
        Rectangle r = null;
        try {
            r = comp.modelToView(dot);
            if (r == null) {
                return;
            }
            dotChar = comp.getText(dot, 1).charAt(0);
        }
        catch (BadLocationException e) {
            return;
        }
        if (this.x != r.x || this.y != r.y) {
            this.repaint();
            this.x = r.x;
            this.y = r.y;
            this.height = r.height;
        }
        g.setColor(comp.getCaretColor());
        g.setXORMode(comp.getBackground());
        if (dotChar == '\n') {
            if (this.isVisible()) {
                g.fillRoundRect(r.x, r.y, 5, r.height, 0, 0);
            }
            return;
        }
        if (dotChar == '\t') {
            try {
                Rectangle nextr = comp.modelToView(dot + 1);
                if (r.y == nextr.y && r.x < nextr.x) {
                    this.width = nextr.x - r.x;
                    if (this.isVisible()) {
                        g.fillRoundRect(r.x, r.y, this.width, r.height, 12, 12);
                    }
                    return;
                }
                dotChar = ' ';
            }
            catch (BadLocationException e) {
                dotChar = ' ';
            }
        }
        this.width = g.getFontMetrics().charWidth(dotChar);
        if (this.isVisible()) {
            g.fillRect(r.x, r.y, this.width, r.height);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("FancyCaret demo");
        frame.setDefaultCloseOperation(3);
        JTextArea area = new JTextArea(8, 32);
        FancyCaret mycaret = new FancyCaret();
        mycaret.setBlinkRate(500);
        area.setCaret(mycaret);
        area.setText("VI\tVirgin Islands \nVA      Virginia\nVT\tVermont");
        frame.getContentPane().add((Component)new JScrollPane(area), "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

