/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class Controller
extends JApplet {
    static final int BAR_MIN = 0;
    static final int BAR_MAX = 10;
    static final int BAR_INIT = 0;
    static final int GABMLE_NUM = 10;
    private JPanel leftPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel operPanel = new JPanel(new GridLayout(4, 2));
    private JPanel barPanel = new JPanel(new GridBagLayout());
    private JScrollPane infoPanel = new JScrollPane();
    private JScrollPane gamblePanel = new JScrollPane();
    private MyPanel showPanel = new MyPanel();
    private JTable infoTable = new JTable();
    private JEditorPane editorPane = new JEditorPane();
    private JButton playButton = new JButton("Play");
    private JButton startButton = new JButton("Start");
    private JLabel roundLabel = new JLabel("Rounds: ", 0);
    private JTextField roundField = new JTextField();
    private JLabel roundReminder = new JLabel("Current Round : ", 0);
    private JLabel roundDigit = new JLabel("0", 0);
    private JRadioButton mode1Button = new JRadioButton("Mode 1");
    private JRadioButton mode2Button = new JRadioButton("Mode 2");
    private ButtonGroup group = new ButtonGroup();
    public static int playerCount = 2;
    public static int ROUND = 10;
    public static HashMap<Integer, Integer> classProp = new HashMap();
    public static int GAMBLENUM = 10;
    public static int CLASSNUM = 5;
    public static int MODE = 1;
    private List<Player> playerList = new ArrayList<Player>();
    private List<Gamble> gambleList = new ArrayList<Gamble>();
    private int[][] linkedMatrix;
    private List<Integer> gambleOrder = new ArrayList<Integer>();
    private int currentRound = 0;
    private Map<Integer, List<JSlider>> allocMap = new HashMap<Integer, List<JSlider>>();
    private Player winnerPlayer;
    public String winner = "not set";
    private List<Double> oneRoundResult = new ArrayList<Double>();
    private List<Integer> roundToChangeType = new ArrayList<Integer>();
    private DefaultTableModel dtm;

    public String getWinner() {
        return this.winner;
    }

    @Override
    public void init() {
        try {
            this.setSize(895, 600);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Controller.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI didn't successfully complete");
        }
    }

    public void initGame() throws Exception {
        MODE = this.mode1Button.isSelected() ? 1 : 2;
        this.gambleList = PortfolioGenerator.generateGambles(GAMBLENUM, CLASSNUM);
        this.linkedMatrix = PortfolioGenerator.genLinks(GAMBLENUM);
        this.playerList.clear();
        int i = 0;
        while (i < playerCount) {
            Player gambler = new Player(i);
            this.playerList.add(gambler);
            ++i;
        }
        this.initTable();
        String output = PortfolioGenerator.outputAsString(this.gambleList, this.linkedMatrix);
        this.assignClassType();
        this.editorPane.setText(output);
        ROUND = Integer.parseInt(this.roundField.getText());
        this.currentRound = 0;
        this.roundDigit.setText(String.valueOf(this.currentRound));
        this.playButton.setEnabled(true);
        int i2 = 0;
        while (i2 < playerCount) {
            List<JSlider> list = this.allocMap.get(i2);
            for (JSlider slider : list) {
                slider.setValue(0);
            }
            ++i2;
        }
        if (MODE == 2) {
            int changeTimes = ROUND / 10;
            int i3 = 0;
            while (i3 < changeTimes) {
                int round = 0;
                while (this.roundToChangeType.contains(round = (int)(Math.random() * (double)ROUND))) {
                }
                this.roundToChangeType.add(round);
                ++i3;
            }
        }
        if (this.startButton.getText().equals("Start")) {
            this.startButton.setText("Restart");
        }
        this.showPanel.init();
        this.loadHistogram(this.gambleList);
        this.updateInfoTable();
    }

    public void classTypeChange() {
        int classId = (int)(Math.random() * (double)CLASSNUM) % CLASSNUM;
        int classType = classProp.get(classId);
        if (classType == -1) {
            int newType = Math.random() > 0.5 ? 0 : 1;
            classProp.put(classId, newType);
        } else if (classType == 1) {
            int newType = Math.random() > 0.5 ? 0 : -1;
            classProp.put(classId, newType);
        } else {
            int newType = Math.random() > 0.5 ? 1 : -1;
            classProp.put(classId, newType);
        }
    }

    public void genreateGambleOrder() {
        ArrayList<Integer> inOrder = new ArrayList<Integer>();
        this.gambleOrder.clear();
        int i = 0;
        while (i < this.gambleList.size()) {
            inOrder.add(i);
            ++i;
        }
        i = 0;
        while (i < this.gambleList.size()) {
            int pos = (int)(Math.random() * (double)inOrder.size());
            this.gambleOrder.add((Integer)inOrder.get(pos));
            inOrder.remove(pos);
            ++i;
        }
    }

    public void playARound() {
        ++this.currentRound;
        if (MODE == 2 && this.roundToChangeType.contains(this.currentRound)) {
            this.classTypeChange();
        }
        this.genreateGambleOrder();
        int i = 0;
        while (i < this.gambleOrder.size()) {
            Gamble current = this.gambleList.get(this.gambleOrder.get(i));
            double highProb = current.highProb;
            double medProb = current.medProb;
            double lowProb = current.lowProb;
            if (classProp.get(current.classId) == 1) {
                highProb = current.highProb + current.lowProb / 2.0;
                medProb = current.medProb;
                lowProb = current.lowProb / 2.0;
            } else if (classProp.get(current.classId) == -1) {
                highProb = current.highProb / 2.0;
                medProb = current.medProb;
                lowProb = current.highProb / 2.0 + current.lowProb;
            }
            int Hi = 0;
            int Mi = 0;
            int Li = 0;
            int j = 0;
            while (j < i) {
                Gamble previous = this.gambleList.get(this.gambleOrder.get(j));
                if (this.linkedMatrix[current.id][previous.id] == 1) {
                    if (previous.getLastResult() == previous.high_return) {
                        ++Hi;
                    } else if (previous.getLastResult() == previous.medium_return) {
                        ++Mi;
                    } else {
                        ++Li;
                    }
                }
                ++j;
            }
            if (Hi > Mi + Li) {
                highProb += lowProb / 2.0;
                lowProb /= 2.0;
            } else if (Li > Hi + Mi) {
                lowProb += highProb / 2.0;
                highProb /= 2.0;
            }
            current.playWithNewProb(highProb, medProb, lowProb);
            ++i;
        }
        this.computeReturnForOneRound();
        this.updateHistogram(this.gambleList);
        this.updateInfoTable();
        this.roundDigit.setText(String.valueOf(this.currentRound));
        if (this.currentRound == ROUND) {
            String result;
            this.playButton.setEnabled(false);
            this.winnerPlayer = this.getWinnerPlayer();
            String title = "Game End";
            if (this.winnerPlayer == null) {
                result = "Tie !";
                this.winner = "Tie ";
            } else {
                result = "Winner is Player " + String.valueOf(this.winnerPlayer.getId() + 1);
                this.winner = "Player " + String.valueOf(this.winnerPlayer.getId() + 1);
            }
            String[] multiLineMsg = new String[]{title, result};
            JOptionPane.showMessageDialog(this, multiLineMsg);
        }
    }

    public void updateInfoTable() {
        DecimalFormat formatter = new DecimalFormat("####.##");
        if (MODE == 1) {
            int i = 0;
            while (i < this.playerList.size()) {
                Player player = this.playerList.get(i);
                String score = formatter.format(player.getScore());
                String PNL = formatter.format(player.getPNL());
                this.dtm.setValueAt(score, i, 1);
                this.dtm.setValueAt(PNL, i, 2);
                this.infoTable.updateUI();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.playerList.size()) {
                Player player = this.playerList.get(i);
                String current = formatter.format(player.getWealth());
                String previous = formatter.format(player.getPrevious());
                String sharpe = formatter.format(player.getSharpeRatio());
                this.dtm.setValueAt(current, i, 1);
                this.dtm.setValueAt(previous, i, 2);
                this.dtm.setValueAt(sharpe, i, 3);
                this.infoTable.updateUI();
                ++i;
            }
        }
    }

    public Player getWinnerPlayer() {
        Player winner = null;
        double max = -1.0;
        if (MODE == 1) {
            if (this.playerList.get(0).getScore() == this.playerList.get(1).getScore()) {
                return null;
            }
            winner = this.playerList.get(0).getScore() > this.playerList.get(1).getScore() ? this.playerList.get(0) : this.playerList.get(1);
        } else {
            if (this.playerList.get(0).getWealth() == this.playerList.get(1).getWealth()) {
                return null;
            }
            winner = this.playerList.get(0).getWealth() > this.playerList.get(1).getWealth() ? this.playerList.get(0) : this.playerList.get(1);
        }
        return winner;
    }

    public List<Integer> getAllocation(int id) {
        List<JSlider> sliderList = this.allocMap.get(id);
        ArrayList<Integer> allocList = new ArrayList<Integer>();
        for (JSlider slider : sliderList) {
            allocList.add(slider.getValue());
        }
        return allocList;
    }

    public List<Double> normalizeAllocation(Player player, List<Integer> allocation) {
        double wealth = MODE == 1 ? 1.0 : player.getWealth();
        ArrayList<Double> normalizeList = new ArrayList<Double>();
        double sum = 0.0;
        for (Integer amount : allocation) {
            sum += (double)amount.intValue();
        }
        for (Integer amount : allocation) {
            double value = sum == 0.0 ? 0.0 : (double)amount.intValue() / sum * wealth;
            normalizeList.add(value);
        }
        return normalizeList;
    }

    public double sum(List<Double> outcome) {
        double total = 0.0;
        for (Double value : outcome) {
            total += value.doubleValue();
        }
        return total;
    }

    public double computeOutcome(List<Double> alloc) {
        ArrayList<Double> outcome = new ArrayList<Double>();
        int i = 0;
        while (i < this.gambleList.size()) {
            Double amount = alloc.get(i);
            Double returnValue = this.gambleList.get(i).getLastResult();
            Double newValue = amount * returnValue;
            outcome.add(newValue);
            ++i;
        }
        return this.sum(outcome);
    }

    public void computeReturnForOneRound() {
        int i = 0;
        while (i < playerCount) {
            Player player = this.playerList.get(i);
            List<Integer> allocList = this.getAllocation(player.getId());
            List<Double> normalizeList = this.normalizeAllocation(player, allocList);
            if (MODE == 1) {
                player.setWealth(1.0);
            }
            double cost = this.sum(normalizeList);
            double yesterday = player.getWealth();
            player.setPrevious(yesterday);
            player.setWealth(player.getWealth() - cost);
            double outcome = 0.0;
            outcome = this.computeOutcome(normalizeList);
            player.setWealth(player.getWealth() + outcome);
            double today = player.getWealth();
            double gamblesReturn = MODE == 1 ? today - yesterday : (today - yesterday) / (today + yesterday) * 2.0;
            player.getReturns().add(gamblesReturn);
            if (MODE == 1 && gamblesReturn >= 1.0) {
                player.increaseScoreByOne();
            }
            if (MODE == 2) {
                player.caculateSharpeRatio();
            }
            ++i;
        }
    }

    public void loadHistogram(List<Gamble> gambleList) {
        this.showPanel.setHistogramTitle("Return", "Gamble");
        for (Gamble g : gambleList) {
            this.showPanel.insert(String.valueOf(g.id), 0.0);
        }
        this.showPanel.updateUI();
    }

    public void updateHistogram(List<Gamble> gambleList) {
        for (Gamble p : gambleList) {
            this.showPanel.update(String.valueOf(p.id), p.getLastResult());
        }
        this.showPanel.updateUI();
    }

    public void assignClassType() {
        int i = 0;
        while (i < CLASSNUM) {
            double rand = Math.random();
            if (rand < 0.3333333333333333) {
                classProp.put(i, 1);
            } else if (rand < 0.6666666666666666) {
                classProp.put(i, 0);
            } else {
                classProp.put(i, -1);
            }
            ++i;
        }
    }

    public void initTable() {
        DecimalFormat formatter = new DecimalFormat("####.##");
        if (MODE == 2) {
            Object[] coloumTitle = new String[]{"Player", "Current", "Previous", "Sharpe Ratio"};
            this.dtm = new DefaultTableModel(coloumTitle, 0);
            this.infoTable.setModel(this.dtm);
            int i = 0;
            while (i < this.playerList.size()) {
                Player player = this.playerList.get(i);
                String name = "Player " + String.valueOf(player.getId() + 1);
                String current = formatter.format(player.getWealth());
                String previous = formatter.format(player.getPrevious());
                String sharpe = formatter.format(player.getSharpeRatio());
                Object[] cols = new String[]{name, current, previous, sharpe};
                this.dtm.addRow(cols);
                this.infoTable.updateUI();
                ++i;
            }
        } else {
            Object[] coloumTitle = new String[]{"Player", "Score", "Profit/Loss"};
            this.dtm = new DefaultTableModel(coloumTitle, 0);
            this.infoTable.setModel(this.dtm);
            int i = 0;
            while (i < this.playerList.size()) {
                Player player = this.playerList.get(i);
                String name = "Player " + String.valueOf(player.getId() + 1);
                String score = formatter.format(player.getScore());
                String pnl = formatter.format(player.getPNL());
                Object[] cols = new String[]{name, score, pnl};
                this.dtm.addRow(cols);
                this.infoTable.updateUI();
                ++i;
            }
        }
    }

    private void createGUI() {
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setSize(895, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.setPreferredSize(new Dimension(300, 600));
        this.leftPanel.setBackground(Color.BLUE);
        this.getContentPane().add((Component)this.leftPanel, "West");
        this.operPanel.setPreferredSize(new Dimension(300, 120));
        this.leftPanel.add((Component)this.operPanel, "North");
        this.roundLabel.setAlignmentX(0.5f);
        this.mode1Button.setSelected(true);
        this.group.add(this.mode1Button);
        this.group.add(this.mode2Button);
        this.operPanel.add(this.mode1Button);
        this.operPanel.add(this.mode2Button);
        this.operPanel.add(this.roundLabel);
        this.operPanel.add(this.roundField);
        this.operPanel.add(this.roundReminder);
        this.operPanel.add(this.roundDigit);
        this.operPanel.add(this.startButton);
        this.operPanel.add(this.playButton);
        this.roundField.setText("10");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Controller.this.initGame();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.playButton.setEnabled(false);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controller.this.playARound();
            }
        });
        this.infoPanel.setPreferredSize(new Dimension(300, 100));
        this.leftPanel.add((Component)this.infoPanel, "Center");
        int i = 0;
        while (i < playerCount) {
            Player gambler = new Player(i);
            this.playerList.add(gambler);
            ++i;
        }
        this.initTable();
        this.infoPanel.getViewport().add(this.infoTable);
        this.gamblePanel.setPreferredSize(new Dimension(300, 380));
        this.editorPane.setEditable(false);
        this.editorPane.setText("Gamble\n\nLink\n");
        this.gamblePanel.getViewport().add(this.editorPane);
        this.leftPanel.add((Component)this.gamblePanel, "South");
        this.centerPanel.setPreferredSize(new Dimension(695, 600));
        this.centerPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.showPanel.setPreferredSize(new Dimension(695, 150));
        this.barPanel.setPreferredSize(new Dimension(695, 450));
        this.centerPanel.add((Component)this.showPanel, "North");
        this.centerPanel.add((Component)this.barPanel, "Center");
        ArrayList<JSlider> sliderPlayer1 = new ArrayList<JSlider>();
        ArrayList<JSlider> sliderPlayer2 = new ArrayList<JSlider>();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        JLabel player1Label = new JLabel("P1", 0);
        this.barPanel.add((Component)player1Label, c);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        JLabel player2Label = new JLabel("P2", 0);
        this.barPanel.add((Component)player2Label, c);
        int i2 = 0;
        while (i2 < 10) {
            JLabel sliderLabel = new JLabel(String.valueOf(i2), 0);
            sliderLabel.setAlignmentX(0.5f);
            JSlider barPlayer1 = new JSlider(1, 0, 10, 0);
            barPlayer1.setMajorTickSpacing(10);
            barPlayer1.setMinorTickSpacing(1);
            barPlayer1.setPaintTicks(true);
            barPlayer1.setPaintLabels(true);
            sliderPlayer1.add(barPlayer1);
            JSlider barPlayer2 = new JSlider(1, 0, 10, 0);
            barPlayer2.setMajorTickSpacing(10);
            barPlayer2.setMinorTickSpacing(1);
            barPlayer2.setPaintTicks(true);
            barPlayer2.setPaintLabels(true);
            sliderPlayer2.add(barPlayer2);
            c.fill = 1;
            c.gridx = i2 + 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.barPanel.add((Component)barPlayer1, c);
            c.gridx = i2 + 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.barPanel.add((Component)barPlayer2, c);
            ++i2;
        }
        this.allocMap.put(0, sliderPlayer1);
        this.allocMap.put(1, sliderPlayer2);
    }
}

