/*
 * Decompiled with CFR 0.152.
 */
package optimalMove;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import optimalMove.AddPhaseState;
import optimalMove.Constants;
import optimalMove.LeveledGameGraph;
import optimalMove.Ply;
import optimalMove.WeightSet;
import optimalMove.rPhaseState;
import optimalMove.weightPlacement;

public class NotippingAutoPlayer {
    public static int MAXSECONDS;
    private static AddPhaseState root_state;
    private Ply.Ownership first_turn = null;
    public String addition_phase_behavior = "Random";
    public boolean socketplay = false;
    public String tag = "";

    public static void main(String[] args) throws Exception {
        String tag = args[0];
        String ply_order = args[1];
        String max_seconds = args[2];
        String addition_phase_behavior = args[3];
        NotippingAutoPlayer player = new NotippingAutoPlayer(tag, ply_order, Integer.parseInt(max_seconds), addition_phase_behavior, true);
        player.start();
    }

    public NotippingAutoPlayer(int first_or_second, int max_seconds) {
        this("", "" + first_or_second, max_seconds, "NotRandom", false);
    }

    public String getHint(String state) {
        boolean thephase = false;
        thephase = !state.startsWith("ADD");
        ArrayList<Object> all_possible_weights = new ArrayList();
        if (!thephase) {
            all_possible_weights = root_state.non_tipping_addition_moves();
        } else {
            String delims = "\\|";
            String[] tokens = state.split(delims);
            String phase = tokens[0];
            String weights_string = tokens[1];
            delims = "[ ]+";
            String[] weights_array = weights_string.split(delims);
            TreeMap<Integer, Integer> wp = new TreeMap<Integer, Integer>();
            int i = 0;
            while (i < weights_array.length) {
                delims = ",";
                String[] wt_string = weights_array[i].split(delims);
                wp.put(Integer.parseInt(wt_string[1]), Integer.parseInt(wt_string[0]));
                ++i;
            }
            rPhaseState initial_state = new rPhaseState(wp);
            initial_state.weight_bounds = initial_state.torques.wb_lookup();
            all_possible_weights = initial_state.non_tipping_moves();
        }
        int size = all_possible_weights.size();
        if (size == 0) {
            return "Abandon Hope All Ye Who Enter Here!";
        }
        Random r = new Random(System.currentTimeMillis());
        int index = r.nextInt(size);
        if (!thephase) {
            return "Place " + ((weightPlacement)all_possible_weights.get((int)index)).weight + " at location " + ((weightPlacement)all_possible_weights.get((int)index)).location;
        }
        return "Pick " + ((weightPlacement)all_possible_weights.get((int)index)).weight + " from location " + ((weightPlacement)all_possible_weights.get((int)index)).location;
    }

    public NotippingAutoPlayer(String tag, String ply_order, int max_seconds, String additional_phase_behavior, boolean socketplay) {
        MAXSECONDS = max_seconds;
        this.addition_phase_behavior = additional_phase_behavior;
        if (ply_order.startsWith("1")) {
            this.first_turn = Ply.Ownership.Mine;
        } else if (ply_order.startsWith("2")) {
            this.first_turn = Ply.Ownership.Opponents;
        }
        this.socketplay = socketplay;
        this.tag = tag;
    }

    public void setMaxWeights(int max) {
        WeightSet.MAXWEIGHT = max;
    }

    public void start() {
        root_state = new AddPhaseState(this.first_turn);
        if (this.socketplay) {
            try {
                this.playThruSocket(this.tag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playThruSocket(String tag) throws Exception {
        String fromServer;
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            socket = new Socket("localhost", 4445);
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: localhost.");
            System.exit(1);
        }
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        out.println(tag);
        while ((fromServer = in.readLine()) != null) {
            System.out.println("Server: " + fromServer);
            if (fromServer.equals("Bye")) break;
            if (!fromServer.startsWith("ADD") && !fromServer.startsWith("REMOVE")) continue;
            String move = this.getMove(fromServer);
            out.println(move);
        }
        out.close();
        in.close();
        stdIn.close();
        socket.close();
    }

    public String getMove(String fromServer) {
        System.out.println("******Received state: " + fromServer);
        String delims = "\\|";
        String[] tokens = fromServer.split(delims);
        String phase = tokens[0];
        String weights_string = tokens[1];
        delims = "[ ]+";
        String[] weights_array = weights_string.split(delims);
        TreeMap<Integer, Integer> wp = new TreeMap<Integer, Integer>();
        int i = 0;
        while (i < weights_array.length) {
            delims = ",";
            String[] wt_string = weights_array[i].split(delims);
            wp.put(Integer.parseInt(wt_string[1]), Integer.parseInt(wt_string[0]));
            ++i;
        }
        weightPlacement next_move = new weightPlacement(0, 0);
        if (phase.equals("ADD")) {
            for (Map.Entry entry : wp.entrySet()) {
                if ((Integer)entry.getKey() == -4 || !NotippingAutoPlayer.root_state.empty_positions.contains(entry.getKey())) continue;
                weightPlacement one_weight = new weightPlacement((Integer)entry.getValue(), (Integer)entry.getKey());
                root_state.add_weight_verbose(one_weight);
                System.out.println();
                root_state.display();
                System.out.println();
                NotippingAutoPlayer.root_state.torques.display();
            }
            int num_children = root_state.num_nontipping_addition_children();
            if (num_children > 0) {
                ArrayList<weightPlacement> moves;
                if (this.addition_phase_behavior.startsWith("Random")) {
                    moves = root_state.non_tipping_addition_moves();
                    Random generator = new Random();
                    int randomIndex = generator.nextInt(num_children);
                    next_move = moves.get(randomIndex);
                }
                if (this.addition_phase_behavior.startsWith("Minimize")) {
                    moves = root_state.non_tipping_addition_moves();
                    next_move = moves.get(0);
                    int curr_min_children = Constants.MAXINT;
                    int move_idx = 0;
                    while (move_idx < moves.size()) {
                        weightPlacement curr_move = moves.get(move_idx);
                        AddPhaseState curr_child = new AddPhaseState(root_state);
                        curr_child.add_weight(curr_move);
                        int curr_children = curr_child.num_nontipping_addition_children();
                        if (curr_children < curr_min_children) {
                            curr_min_children = curr_children;
                            next_move = curr_move;
                        }
                        ++move_idx;
                    }
                } else {
                    LeveledGameGraph test_graph = new LeveledGameGraph(root_state);
                    AddPhaseState next_child = (AddPhaseState)test_graph.timed_Expand_Eval_Verbose(root_state, 0);
                    next_move = root_state.addition_needed(next_child);
                }
            } else if (num_children == 0) {
                next_move = root_state.a_legal_move();
            }
            root_state.add_weight_verbose(next_move);
            System.out.println();
            root_state.display();
            System.out.println();
            NotippingAutoPlayer.root_state.torques.display();
        } else if (phase.equals("REMOVE")) {
            rPhaseState initial_state = new rPhaseState(wp);
            initial_state.next_ply.Whose = Ply.Ownership.Mine;
            initial_state.weight_bounds = initial_state.torques.wb_lookup();
            int num_children = initial_state.num_nontipping_children();
            if (num_children > 0) {
                LeveledGameGraph test_graph = new LeveledGameGraph(initial_state);
                rPhaseState next_child = test_graph.timed_Expand_Eval_Verbose(initial_state, 0);
                int next_move_location = initial_state.removal_needed(next_child);
                int next_move_weight = (Integer)initial_state.weight_positions.get(next_move_location);
                next_move = new weightPlacement(next_move_weight, next_move_location);
            } else if (num_children == 0) {
                next_move = initial_state.a_legal_move();
            }
        }
        String fromUser = next_move.server_string();
        if (fromUser != null) {
            return fromUser;
        }
        return "";
    }
}

