#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"
#include "cfortran.h"
#include "hbook.h"
#include <time.h>


int grb_finder_init(MAP *maps, double *duration, PROB *prob) {
		    

    int change1,change2,i,j;
    double phi,theta,zangle,ha,theta_LANL,dec,x,y,sig,back;
    char hilab[100],str[300];

    system("mail xiaojian@cs.nyu.edu -s 'Restarting grb search'</var/log/dmesg");



    /* zero out arrays */
    for (i=0;i<NRA_BINS;i++) {
      for (j=0;j<NDEC_BINS;j++) {
        maps->backmap[i][j]=0.;
        maps->backmap_ha_dec[i][j]=0;
        maps->backmap_index[i][j]=0;
		//maps->sigmap[i][j]=0;
      }
    }

    /* calculate duration spectrum */
    x   = log(MAX_DURATION)-log(MIN_DURATION);
    y   = x/((double)NDUR-1);
    for (i=0;i<NDUR;i++) {
      duration[i]=exp(log(MIN_DURATION)+y*((double)i));
      sprintf(hilab,"signal  %10.5f",duration[i]);
      HBOOK1(i*10+1,hilab,    1000,0.,1000.,0.);
      sprintf(hilab,"background  %10.5f",duration[i]);
      HBOOK1(i*10+2,hilab,500,-6.,4.,0.);
      sprintf(hilab,"Prob %10.5f",duration[i]);
      HBOOK1(i*10+3,hilab,400,-20.,0.0001,0.);
    }

    /* calculate probabilities for the look up table */
    sprintf(str,"Calculating Probabilities:\n");
    grb_finder_logger(str);
    prob->minback = log(MIN_BACK);
    prob->span    = log(MAX_BACK)-log(MIN_BACK);
    for (i=0;i<MAX_SIG;i++) {
      for (j=0;j<PROB_BINS;j++) {
        sig = (double) i;
        back = exp(((float)j)*prob->span/PROB_BINSF+prob->minback);
        prob->value[i][j] = intpois(back,sig);
      }
    }
    sprintf(str,"done\n");
    grb_finder_logger(str);
    
    /* set threshold to call publish */
    sprintf(str,"Duration, Probability Threshold\n");
    grb_finder_logger(str);
    for (i=0;i<NDUR;i++) {
      x = log10(duration[i]);
      y = (-10.969 +0.7773*x);       /* y=-10.969+0.7773*x from fit to trials time spectrum */
      prob->publish_threshold[i] = pow(10.,y);
      sprintf(str,"%f %g \n",duration[i],prob->publish_threshold[i]);
      grb_finder_logger(str);
    }

    /* calculate search binsize in HA dimension */
    theta_LANL = (90.-35.)*DEG_TO_RAD;
    for (i=0;i<NDEC_BINS;i++) {
      dec = -60.+BINSIZE*i+BINSIZE/2.;
      prob->habins[i] = (int) (((float)SEARCHBIN)/cos(dec*DEG_TO_RAD) +.5 );
      if (prob->habins[i]>NHA_BINS/4) prob->habins[i] = NHA_BINS/4;
    }

    /* search HA and dec grid to find the search interval for a given */
    /* zenith angle cut. In other words, find the dec range such that 
       the dec is within the zenith angles we want to search, as a 
       function of HA
    */
    
    change2=0;
    for(i=0;i<NHA_BINS;i++) {
      change1=0;
      for(j=0;j<NDEC_BINS;j++) {
        ha  = index2ha(i);
        dec = index2dec(j);
        theta = (90.-dec)*DEG_TO_RAD;
        phi   = ha*DEG_TO_RAD;
        zangle = acos( sin(theta)*cos(phi)*sin(theta_LANL)
                      +cos(theta)*cos(theta_LANL) )*RAD_TO_DEG;

        if (zangle>ZENITH_ANGLE_CUT && change1==1) {
          if (index2dec(j)>MAX_DEC) {
            prob->decmax[i] = dec2index(MAX_DEC);
          } else {
            prob->decmax[i]=j;
          }
          change1 = 2;
        }

        if (zangle<ZENITH_ANGLE_CUT && change1==0) {
          prob->decmin[i]=j;
          change1 = 1;
        }

      }

      if (change1==1) prob->decmax[i] = dec2index(MAX_DEC);
      if (change1!=0 && change2==0) { /* found beginning of HA search region */
        prob->hamin = i;
        change2=1;
      }
      if (change1==0 && change2==1) { /* found end of HA search region */
        prob->hamax = i-1;
        change2=2;
      }
      if (change2==0 || change2==2) {
        prob->decmin[i] =0;
        prob->decmax[i] =0;
      }
      
    }

}


   

