import React from 'react';
import ReactDOM from 'react-dom';
import { WithContext as ReactTags } from 'react-tag-input';
import { connect } from 'react-redux';
import { Card } from 'react-bootstrap';
import {HTML5Backend } from 'react-dnd-html5-backend';


const KeyCodes = {
    comma: 188,
    enter: 13,
};

const delimiters = [KeyCodes.comma, KeyCodes.enter];



class Restrictions extends React.Component {
    componentDidUpdate(prevProps, prevState) {
        if (prevState !== this.state) {
            this.props.onChange(this.state)
        }
    }
    constructor(props) {
        super(props);
        this.state = {
            allergenTags: this.props.data.allergens?.map((item) => {
                return { id: item, text: item };
            }) || [],

            likedTags: this.props.data.tastes?.map((item) => {
                return { id: item, text: item };
            }) || [],

            suggestions: [
                {
                    "id": "$Wheat products",
                    "text": "Wheat products (all)"
                },
                {
                    "id": "$Dairy products",
                    "text": "Dairy products (all)"
                },
                {
                    "id": "$Legumes",
                    "text": "Legumes (all)"
                },
                {
                    "id": "$Shellfish",
                    "text": "Shellfish (all)"
                },
                {
                    "id": "$Pork products",
                    "text": "Pork products (all)"
                },
                {
                    "id": "$Nut products",
                    "text": "Nut products (all)"
                },
                {
                    "id": "$Game meats",
                    "text": "Game meats (all)"
                },
                {
                    "id": "$Chicken products",
                    "text": "Chicken products (all)"
                },
                {
                    "id": "$Beef products",
                    "text": "Beef products (all)"
                },
                {
                    "id": "$Fish products",
                    "text": "Fish products (all)"
                },
                {
                    "id": "$Meat products",
                    "text": "Meat products (all)"
                },
                {
                    "id": "Abiyuch",
                    "text": "Abiyuch"
                },
                {
                    "id": "Acerola",
                    "text": "Acerola"
                },
                {
                    "id": "Acerola_juice",
                    "text": "Acerola juice"
                },
                {
                    "id": "Acorn_stew_(Apache)",
                    "text": "Acorn stew (Apache)"
                },
                {
                    "id": "Agave",
                    "text": "Agave"
                },
                {
                    "id": "Agutuk",
                    "text": "Agutuk"
                },
                {
                    "id": "Alcoholic_Beverage",
                    "text": "Alcoholic Beverage"
                },
                {
                    "id": "Alcoholic_beverage",
                    "text": "Alcoholic beverage"
                },
                {
                    "id": "Alcoholic_beverages",
                    "text": "Alcoholic beverages"
                },
                {
                    "id": "Alfalfa_seeds",
                    "text": "Alfalfa seeds"
                },
                {
                    "id": "Amaranth_grain",
                    "text": "Amaranth grain"
                },
                {
                    "id": "Amaranth_leaves",
                    "text": "Amaranth leaves"
                },
                {
                    "id": "Animal_fat",
                    "text": "Animal fat"
                },
                {
                    "id": "Apple_juice",
                    "text": "Apple juice"
                },
                {
                    "id": "Apples",
                    "text": "Apples"
                },
                {
                    "id": "Applesauce",
                    "text": "Applesauce"
                },
                {
                    "id": "Apricot_nectar",
                    "text": "Apricot nectar"
                },
                {
                    "id": "Apricots",
                    "text": "Apricots"
                },
                {
                    "id": "Arrowhead",
                    "text": "Arrowhead"
                },
                {
                    "id": "Arrowroot",
                    "text": "Arrowroot"
                },
                {
                    "id": "Arrowroot_flour",
                    "text": "Arrowroot flour"
                },
                {
                    "id": "Artichokes",
                    "text": "Artichokes"
                },
                {
                    "id": "Artificial_Blueberry_Muffin_Mix",
                    "text": "Artificial Blueberry Muffin Mix"
                },
                {
                    "id": "Arugula",
                    "text": "Arugula"
                },
                {
                    "id": "Ascidians_(tunughnak)_(Alaska_Native)",
                    "text": "Ascidians (tunughnak) (Alaska Native)"
                },
                {
                    "id": "Asparagus",
                    "text": "Asparagus"
                },
                {
                    "id": "Avocados",
                    "text": "Avocados"
                },
                {
                    "id": "Baby_food",
                    "text": "Baby food"
                },
                {
                    "id": "Babyfood",
                    "text": "Babyfood"
                },
                {
                    "id": "Babyfoods",
                    "text": "Babyfoods"
                },
                {
                    "id": "Bacon",
                    "text": "Bacon"
                },
                {
                    "id": "Bacon_and_beef_sticks",
                    "text": "Bacon and beef sticks"
                },
                {
                    "id": "Bacon_bits",
                    "text": "Bacon bits"
                },
                {
                    "id": "Bagels",
                    "text": "Bagels"
                },
                {
                    "id": "Baking_chocolate",
                    "text": "Baking chocolate"
                },
                {
                    "id": "Balsam-pear_(bitter_gourd)",
                    "text": "Balsam-pear (bitter gourd)"
                },
                {
                    "id": "Bamboo_shoots",
                    "text": "Bamboo shoots"
                },
                {
                    "id": "Bananas",
                    "text": "Bananas"
                },
                {
                    "id": "Barbecue_loaf",
                    "text": "Barbecue loaf"
                },
                {
                    "id": "Barley",
                    "text": "Barley"
                },
                {
                    "id": "Barley_flour_or_meal",
                    "text": "Barley flour or meal"
                },
                {
                    "id": "Barley_malt_flour",
                    "text": "Barley malt flour"
                },
                {
                    "id": "Basil",
                    "text": "Basil"
                },
                {
                    "id": "Beans",
                    "text": "Beans"
                },
                {
                    "id": "Beef",
                    "text": "Beef"
                },
                {
                    "id": "Beef_composite",
                    "text": "Beef composite"
                },
                {
                    "id": "Beef_macaroni_with_tomato_sauce",
                    "text": "Beef macaroni with tomato sauce"
                },
                {
                    "id": "Beef_Pot_Pie",
                    "text": "Beef Pot Pie"
                },
                {
                    "id": "Beef_sausage",
                    "text": "Beef sausage"
                },
                {
                    "id": "Beef_stew",
                    "text": "Beef stew"
                },
                {
                    "id": "Beerwurst",
                    "text": "Beerwurst"
                },
                {
                    "id": "Beet_greens",
                    "text": "Beet greens"
                },
                {
                    "id": "Beets",
                    "text": "Beets"
                },
                {
                    "id": "Beverage",
                    "text": "Beverage"
                },
                {
                    "id": "Beverages",
                    "text": "Beverages"
                },
                {
                    "id": "Biscuits",
                    "text": "Biscuits"
                },
                {
                    "id": "Bison",
                    "text": "Bison"
                },
                {
                    "id": "Blackberries",
                    "text": "Blackberries"
                },
                {
                    "id": "Blackberry_juice",
                    "text": "Blackberry juice"
                },
                {
                    "id": "Blood_sausage",
                    "text": "Blood sausage"
                },
                {
                    "id": "Blueberries",
                    "text": "Blueberries"
                },
                {
                    "id": "Bockwurst",
                    "text": "Bockwurst"
                },
                {
                    "id": "Bologna",
                    "text": "Bologna"
                },
                {
                    "id": "Borage",
                    "text": "Borage"
                },
                {
                    "id": "Boysenberries",
                    "text": "Boysenberries"
                },
                {
                    "id": "Bratwurst",
                    "text": "Bratwurst"
                },
                {
                    "id": "Braunschweiger_(a_liver_sausage)",
                    "text": "Braunschweiger (a liver sausage)"
                },
                {
                    "id": "Bread",
                    "text": "Bread"
                },
                {
                    "id": "Bread_crumbs",
                    "text": "Bread crumbs"
                },
                {
                    "id": "Bread_sticks",
                    "text": "Bread sticks"
                },
                {
                    "id": "Bread_stuffing",
                    "text": "Bread stuffing"
                },
                {
                    "id": "Breadfruit",
                    "text": "Breadfruit"
                },
                {
                    "id": "Breakfast_bar",
                    "text": "Breakfast bar"
                },
                {
                    "id": "Breakfast_bars",
                    "text": "Breakfast bars"
                },
                {
                    "id": "Breakfast_tart",
                    "text": "Breakfast tart"
                },
                {
                    "id": "Broadbeans",
                    "text": "Broadbeans"
                },
                {
                    "id": "Broadbeans_(fava_beans)",
                    "text": "Broadbeans (fava beans)"
                },
                {
                    "id": "Broccoli",
                    "text": "Broccoli"
                },
                {
                    "id": "Broccoli_raab",
                    "text": "Broccoli raab"
                },
                {
                    "id": "Brotwurst",
                    "text": "Brotwurst"
                },
                {
                    "id": "Brussels_sprouts",
                    "text": "Brussels sprouts"
                },
                {
                    "id": "Buckwheat",
                    "text": "Buckwheat"
                },
                {
                    "id": "Buckwheat_flour",
                    "text": "Buckwheat flour"
                },
                {
                    "id": "Buckwheat_groats",
                    "text": "Buckwheat groats"
                },
                {
                    "id": "Buffalo",
                    "text": "Buffalo"
                },
                {
                    "id": "Bulgur",
                    "text": "Bulgur"
                },
                {
                    "id": "Burdock_root",
                    "text": "Burdock root"
                },
                {
                    "id": "Burrito",
                    "text": "Burrito"
                },
                {
                    "id": "Butter",
                    "text": "Butter"
                },
                {
                    "id": "Butter_oil",
                    "text": "Butter oil"
                },
                {
                    "id": "Butter_replacement",
                    "text": "Butter replacement"
                },
                {
                    "id": "Butterbur",
                    "text": "Butterbur"
                },
                {
                    "id": "Cabbage",
                    "text": "Cabbage"
                },
                {
                    "id": "Cake",
                    "text": "Cake"
                },
                {
                    "id": "Canada_Goose",
                    "text": "Canada Goose"
                },
                {
                    "id": "Canadian_bacon",
                    "text": "Canadian bacon"
                },
                {
                    "id": "Candied_fruit",
                    "text": "Candied fruit"
                },
                {
                    "id": "Candies",
                    "text": "Candies"
                },
                {
                    "id": "Candy",
                    "text": "Candy"
                },
                {
                    "id": "Capers",
                    "text": "Capers"
                },
                {
                    "id": "Carambola",
                    "text": "Carambola"
                },
                {
                    "id": "Carbonated_beverage",
                    "text": "Carbonated beverage"
                },
                {
                    "id": "Cardoon",
                    "text": "Cardoon"
                },
                {
                    "id": "Caribou",
                    "text": "Caribou"
                },
                {
                    "id": "Carissa",
                    "text": "Carissa"
                },
                {
                    "id": "Carob_flour",
                    "text": "Carob flour"
                },
                {
                    "id": "Carrot",
                    "text": "Carrot"
                },
                {
                    "id": "Carrot_juice",
                    "text": "Carrot juice"
                },
                {
                    "id": "Carrots",
                    "text": "Carrots"
                },
                {
                    "id": "Cassava",
                    "text": "Cassava"
                },
                {
                    "id": "Catsup",
                    "text": "Catsup"
                },
                {
                    "id": "Cattail",
                    "text": "Cattail"
                },
                {
                    "id": "Cauliflower",
                    "text": "Cauliflower"
                },
                {
                    "id": "Celeriac",
                    "text": "Celeriac"
                },
                {
                    "id": "Celery",
                    "text": "Celery"
                },
                {
                    "id": "Celery_flakes",
                    "text": "Celery flakes"
                },
                {
                    "id": "Celtuce",
                    "text": "Celtuce"
                },
                {
                    "id": "Cereals",
                    "text": "Cereals"
                },
                {
                    "id": "Cereals_ready-to-eat",
                    "text": "Cereals ready-to-eat"
                },
                {
                    "id": "Chard",
                    "text": "Chard"
                },
                {
                    "id": "Chayote",
                    "text": "Chayote"
                },
                {
                    "id": "Cheese",
                    "text": "Cheese"
                },
                {
                    "id": "Cheese_food",
                    "text": "Cheese food"
                },
                {
                    "id": "Cheese_product",
                    "text": "Cheese product"
                },
                {
                    "id": "Cheese_puffs_and_twists",
                    "text": "Cheese puffs and twists"
                },
                {
                    "id": "Cheese_sauce",
                    "text": "Cheese sauce"
                },
                {
                    "id": "Cheese_spread",
                    "text": "Cheese spread"
                },
                {
                    "id": "Cheese_substitute",
                    "text": "Cheese substitute"
                },
                {
                    "id": "Cheesecake_commercially_prepared",
                    "text": "Cheesecake commercially prepared"
                },
                {
                    "id": "Cheesecake_prepared_from_mix",
                    "text": "Cheesecake prepared from mix"
                },
                {
                    "id": "Cheesefurter",
                    "text": "Cheesefurter"
                },
                {
                    "id": "Cherimoya",
                    "text": "Cherimoya"
                },
                {
                    "id": "Cherries",
                    "text": "Cherries"
                },
                {
                    "id": "Chewing_gum",
                    "text": "Chewing gum"
                },
                {
                    "id": "CHICK-FIL-A",
                    "text": "CHICK-FIL-A"
                },
                {
                    "id": "Chicken",
                    "text": "Chicken"
                },
                {
                    "id": "Chicken_breast",
                    "text": "Chicken breast"
                },
                {
                    "id": "Chicken_breast_tenders",
                    "text": "Chicken breast tenders"
                },
                {
                    "id": "Chicken_patty",
                    "text": "Chicken patty"
                },
                {
                    "id": "Chicken_pot_pie",
                    "text": "Chicken pot pie"
                },
                {
                    "id": "Chicken_spread",
                    "text": "Chicken spread"
                },
                {
                    "id": "Chicken_tenders",
                    "text": "Chicken tenders"
                },
                {
                    "id": "Chickpea_flour_(besan)",
                    "text": "Chickpea flour (besan)"
                },
                {
                    "id": "Chickpeas_(garbanzo_beans",
                    "text": "Chickpeas (garbanzo beans"
                },
                {
                    "id": "Chicory",
                    "text": "Chicory"
                },
                {
                    "id": "Chicory_greens",
                    "text": "Chicory greens"
                },
                {
                    "id": "Chicory_roots",
                    "text": "Chicory roots"
                },
                {
                    "id": "Chilchen_(Red_Berry_Beverage)_(Navajo)",
                    "text": "Chilchen (Red Berry Beverage) (Navajo)"
                },
                {
                    "id": "Child_formula",
                    "text": "Child formula"
                },
                {
                    "id": "Chili",
                    "text": "Chili"
                },
                {
                    "id": "Chili_con_carne_with_beans",
                    "text": "Chili con carne with beans"
                },
                {
                    "id": "Chili_with_beans",
                    "text": "Chili with beans"
                },
                {
                    "id": "Chiton",
                    "text": "Chiton"
                },
                {
                    "id": "Chives",
                    "text": "Chives"
                },
                {
                    "id": "Chocolate",
                    "text": "Chocolate"
                },
                {
                    "id": "Chocolate-flavored_drink",
                    "text": "Chocolate-flavored drink"
                },
                {
                    "id": "Chocolate-flavored_hazelnut_spread",
                    "text": "Chocolate-flavored hazelnut spread"
                },
                {
                    "id": "Chokecherries",
                    "text": "Chokecherries"
                },
                {
                    "id": "Chorizo",
                    "text": "Chorizo"
                },
                {
                    "id": "Chrysanthemum",
                    "text": "Chrysanthemum"
                },
                {
                    "id": "Chrysanthemum_leaves",
                    "text": "Chrysanthemum leaves"
                },
                {
                    "id": "Cinnamon_buns",
                    "text": "Cinnamon buns"
                },
                {
                    "id": "Citrus_fruit_juice_drink",
                    "text": "Citrus fruit juice drink"
                },
                {
                    "id": "Clementines",
                    "text": "Clementines"
                },
                {
                    "id": "Cloudberries",
                    "text": "Cloudberries"
                },
                {
                    "id": "Cockles",
                    "text": "Cockles"
                },
                {
                    "id": "Cocoa",
                    "text": "Cocoa"
                },
                {
                    "id": "Cocoa_mix",
                    "text": "Cocoa mix"
                },
                {
                    "id": "Coffee",
                    "text": "Coffee"
                },
                {
                    "id": "Coffeecake",
                    "text": "Coffeecake"
                },
                {
                    "id": "Collards",
                    "text": "Collards"
                },
                {
                    "id": "Cookies",
                    "text": "Cookies"
                },
                {
                    "id": "Coriander_(cilantro)_leaves",
                    "text": "Coriander (cilantro) leaves"
                },
                {
                    "id": "Corn",
                    "text": "Corn"
                },
                {
                    "id": "Corn_bran",
                    "text": "Corn bran"
                },
                {
                    "id": "Corn_dogs",
                    "text": "Corn dogs"
                },
                {
                    "id": "Corn_flour",
                    "text": "Corn flour"
                },
                {
                    "id": "Corn_grain",
                    "text": "Corn grain"
                },
                {
                    "id": "Corn_pudding",
                    "text": "Corn pudding"
                },
                {
                    "id": "Corn_with_red_and_green_peppers",
                    "text": "Corn with red and green peppers"
                },
                {
                    "id": "Corned_beef_and_potatoes_in_tortilla_(Apache)",
                    "text": "Corned beef and potatoes in tortilla (Apache)"
                },
                {
                    "id": "Corned_beef_loaf",
                    "text": "Corned beef loaf"
                },
                {
                    "id": "Cornmeal",
                    "text": "Cornmeal"
                },
                {
                    "id": "Cornsalad",
                    "text": "Cornsalad"
                },
                {
                    "id": "Cornstarch",
                    "text": "Cornstarch"
                },
                {
                    "id": "Couscous",
                    "text": "Couscous"
                },
                {
                    "id": "Cowpeas",
                    "text": "Cowpeas"
                },
                {
                    "id": "Cowpeas_(blackeyes)",
                    "text": "Cowpeas (blackeyes)"
                },
                {
                    "id": "Crabapples",
                    "text": "Crabapples"
                },
                {
                    "id": "Cracker_meal",
                    "text": "Cracker meal"
                },
                {
                    "id": "Crackers",
                    "text": "Crackers"
                },
                {
                    "id": "Cranberries",
                    "text": "Cranberries"
                },
                {
                    "id": "Cranberry",
                    "text": "Cranberry"
                },
                {
                    "id": "Cranberry_juice",
                    "text": "Cranberry juice"
                },
                {
                    "id": "Cranberry_juice_blend",
                    "text": "Cranberry juice blend"
                },
                {
                    "id": "Cranberry_juice_cocktail",
                    "text": "Cranberry juice cocktail"
                },
                {
                    "id": "Cranberry_sauce",
                    "text": "Cranberry sauce"
                },
                {
                    "id": "Cranberry-apple_juice_drink",
                    "text": "Cranberry-apple juice drink"
                },
                {
                    "id": "Cranberry-apricot_juice_drink",
                    "text": "Cranberry-apricot juice drink"
                },
                {
                    "id": "Cranberry-grape_juice_drink",
                    "text": "Cranberry-grape juice drink"
                },
                {
                    "id": "Cranberry-orange_relish",
                    "text": "Cranberry-orange relish"
                },
                {
                    "id": "Cream",
                    "text": "Cream"
                },
                {
                    "id": "Cream_puff",
                    "text": "Cream puff"
                },
                {
                    "id": "Cream_puff_shell",
                    "text": "Cream puff shell"
                },
                {
                    "id": "Cream_substitute",
                    "text": "Cream substitute"
                },
                {
                    "id": "Creamy_dressing",
                    "text": "Creamy dressing"
                },
                {
                    "id": "Cress",
                    "text": "Cress"
                },
                {
                    "id": "Croissants",
                    "text": "Croissants"
                },
                {
                    "id": "Croutons",
                    "text": "Croutons"
                },
                {
                    "id": "Crustaceans",
                    "text": "Crustaceans"
                },
                {
                    "id": "Cucumber",
                    "text": "Cucumber"
                },
                {
                    "id": "Currants",
                    "text": "Currants"
                },
                {
                    "id": "Custard-apple",
                    "text": "Custard-apple"
                },
                {
                    "id": "Dairy_drink_mix",
                    "text": "Dairy drink mix"
                },
                {
                    "id": "Dandelion_greens",
                    "text": "Dandelion greens"
                },
                {
                    "id": "Danish_pastry",
                    "text": "Danish pastry"
                },
                {
                    "id": "Dates",
                    "text": "Dates"
                },
                {
                    "id": "Deer_(venison)",
                    "text": "Deer (venison)"
                },
                {
                    "id": "Dessert_topping",
                    "text": "Dessert topping"
                },
                {
                    "id": "Desserts",
                    "text": "Desserts"
                },
                {
                    "id": "DIGIORNO_Pizza",
                    "text": "DIGIORNO Pizza"
                },
                {
                    "id": "Dill_weed",
                    "text": "Dill weed"
                },
                {
                    "id": "Dip",
                    "text": "Dip"
                },
                {
                    "id": "Dock",
                    "text": "Dock"
                },
                {
                    "id": "Doughnuts",
                    "text": "Doughnuts"
                },
                {
                    "id": "Dove",
                    "text": "Dove"
                },
                {
                    "id": "Dressing",
                    "text": "Dressing"
                },
                {
                    "id": "Drink_mix",
                    "text": "Drink mix"
                },
                {
                    "id": "Drumstick_leaves",
                    "text": "Drumstick leaves"
                },
                {
                    "id": "Drumstick_pods",
                    "text": "Drumstick pods"
                },
                {
                    "id": "Duck",
                    "text": "Duck"
                },
                {
                    "id": "Dulce_de_Leche",
                    "text": "Dulce de Leche"
                },
                {
                    "id": "Dumpling",
                    "text": "Dumpling"
                },
                {
                    "id": "Durian",
                    "text": "Durian"
                },
                {
                    "id": "Dutch_brand_loaf",
                    "text": "Dutch brand loaf"
                },
                {
                    "id": "Edamame",
                    "text": "Edamame"
                },
                {
                    "id": "Egg",
                    "text": "Egg"
                },
                {
                    "id": "Egg_custards",
                    "text": "Egg custards"
                },
                {
                    "id": "Egg_Mix",
                    "text": "Egg Mix"
                },
                {
                    "id": "Egg_rolls",
                    "text": "Egg rolls"
                },
                {
                    "id": "Egg_substitute",
                    "text": "Egg substitute"
                },
                {
                    "id": "Eggnog",
                    "text": "Eggnog"
                },
                {
                    "id": "Eggplant",
                    "text": "Eggplant"
                },
                {
                    "id": "Eggs",
                    "text": "Eggs"
                },
                {
                    "id": "Elderberries",
                    "text": "Elderberries"
                },
                {
                    "id": "Elk",
                    "text": "Elk"
                },
                {
                    "id": "Emu",
                    "text": "Emu"
                },
                {
                    "id": "Endive",
                    "text": "Endive"
                },
                {
                    "id": "English_muffins",
                    "text": "English muffins"
                },
                {
                    "id": "Epazote",
                    "text": "Epazote"
                },
                {
                    "id": "Eppaw",
                    "text": "Eppaw"
                },
                {
                    "id": "Escarole",
                    "text": "Escarole"
                },
                {
                    "id": "Falafel",
                    "text": "Falafel"
                },
                {
                    "id": "FAMOUS_AMOS",
                    "text": "FAMOUS AMOS"
                },
                {
                    "id": "Fast_Food",
                    "text": "Fast Food"
                },
                {
                    "id": "Fast_food",
                    "text": "Fast food"
                },
                {
                    "id": "Fast_Foods",
                    "text": "Fast Foods"
                },
                {
                    "id": "Fast_foods",
                    "text": "Fast foods"
                },
                {
                    "id": "Fat",
                    "text": "Fat"
                },
                {
                    "id": "Fat_free_ice_cream",
                    "text": "Fat free ice cream"
                },
                {
                    "id": "Feijoa",
                    "text": "Feijoa"
                },
                {
                    "id": "Fennel",
                    "text": "Fennel"
                },
                {
                    "id": "Fiddlehead_ferns",
                    "text": "Fiddlehead ferns"
                },
                {
                    "id": "Figs",
                    "text": "Figs"
                },
                {
                    "id": "Fireweed",
                    "text": "Fireweed"
                },
                {
                    "id": "Fish",
                    "text": "Fish"
                },
                {
                    "id": "Fish_broth",
                    "text": "Fish broth"
                },
                {
                    "id": "Fish_oil",
                    "text": "Fish oil"
                },
                {
                    "id": "Flan",
                    "text": "Flan"
                },
                {
                    "id": "Fluid_replacement",
                    "text": "Fluid replacement"
                },
                {
                    "id": "Focaccia",
                    "text": "Focaccia"
                },
                {
                    "id": "Formulated_Bar",
                    "text": "Formulated Bar"
                },
                {
                    "id": "Formulated_bar",
                    "text": "Formulated bar"
                },
                {
                    "id": "Frankfurter",
                    "text": "Frankfurter"
                },
                {
                    "id": "French_toast",
                    "text": "French toast"
                },
                {
                    "id": "Frijoles_rojos_volteados_(Refried_beans",
                    "text": "Frijoles rojos volteados (Refried beans"
                },
                {
                    "id": "Frog_legs",
                    "text": "Frog legs"
                },
                {
                    "id": "Frostings",
                    "text": "Frostings"
                },
                {
                    "id": "Frozen_novelties",
                    "text": "Frozen novelties"
                },
                {
                    "id": "Frozen_yogurts",
                    "text": "Frozen yogurts"
                },
                {
                    "id": "Fruit_butters",
                    "text": "Fruit butters"
                },
                {
                    "id": "Fruit_cocktail",
                    "text": "Fruit cocktail"
                },
                {
                    "id": "Fruit_juice_drink",
                    "text": "Fruit juice drink"
                },
                {
                    "id": "Fruit_juice_smoothie",
                    "text": "Fruit juice smoothie"
                },
                {
                    "id": "Fruit_punch_drink",
                    "text": "Fruit punch drink"
                },
                {
                    "id": "Fruit_punch_juice_drink",
                    "text": "Fruit punch juice drink"
                },
                {
                    "id": "Fruit_punch-flavor_drink",
                    "text": "Fruit punch-flavor drink"
                },
                {
                    "id": "Fruit_salad",
                    "text": "Fruit salad"
                },
                {
                    "id": "Fruit_syrup",
                    "text": "Fruit syrup"
                },
                {
                    "id": "Fruit-flavored_drink",
                    "text": "Fruit-flavored drink"
                },
                {
                    "id": "Frybread",
                    "text": "Frybread"
                },
                {
                    "id": "Fungi",
                    "text": "Fungi"
                },
                {
                    "id": "Game_meat",
                    "text": "Game meat"
                },
                {
                    "id": "Garlic",
                    "text": "Garlic"
                },
                {
                    "id": "Garlic_bread",
                    "text": "Garlic bread"
                },
                {
                    "id": "Gelatin_desserts",
                    "text": "Gelatin desserts"
                },
                {
                    "id": "Gelatins",
                    "text": "Gelatins"
                },
                {
                    "id": "Ginger_root",
                    "text": "Ginger root"
                },
                {
                    "id": "Goat",
                    "text": "Goat"
                },
                {
                    "id": "Goji_berries",
                    "text": "Goji berries"
                },
                {
                    "id": "Goose",
                    "text": "Goose"
                },
                {
                    "id": "Gooseberries",
                    "text": "Gooseberries"
                },
                {
                    "id": "Gourd",
                    "text": "Gourd"
                },
                {
                    "id": "Granola_bar",
                    "text": "Granola bar"
                },
                {
                    "id": "Grape_drink",
                    "text": "Grape drink"
                },
                {
                    "id": "Grape_juice",
                    "text": "Grape juice"
                },
                {
                    "id": "Grape_juice_drink",
                    "text": "Grape juice drink"
                },
                {
                    "id": "Grape_leaves",
                    "text": "Grape leaves"
                },
                {
                    "id": "Grapefruit",
                    "text": "Grapefruit"
                },
                {
                    "id": "Grapefruit_juice",
                    "text": "Grapefruit juice"
                },
                {
                    "id": "Grapes",
                    "text": "Grapes"
                },
                {
                    "id": "Gravy",
                    "text": "Gravy"
                },
                {
                    "id": "Ground_turkey",
                    "text": "Ground turkey"
                },
                {
                    "id": "Groundcherries",
                    "text": "Groundcherries"
                },
                {
                    "id": "Guanabana_nectar",
                    "text": "Guanabana nectar"
                },
                {
                    "id": "Guava_nectar",
                    "text": "Guava nectar"
                },
                {
                    "id": "Guava_sauce",
                    "text": "Guava sauce"
                },
                {
                    "id": "Guavas",
                    "text": "Guavas"
                },
                {
                    "id": "Guinea_hen",
                    "text": "Guinea hen"
                },
                {
                    "id": "Gums",
                    "text": "Gums"
                },
                {
                    "id": "Ham",
                    "text": "Ham"
                },
                {
                    "id": "Ham_and_cheese_loaf_or_roll",
                    "text": "Ham and cheese loaf or roll"
                },
                {
                    "id": "Ham_and_cheese_spread",
                    "text": "Ham and cheese spread"
                },
                {
                    "id": "Ham_salad_spread",
                    "text": "Ham salad spread"
                },
                {
                    "id": "Hazelnuts",
                    "text": "Hazelnuts"
                },
                {
                    "id": "Headcheese",
                    "text": "Headcheese"
                },
                {
                    "id": "Hearts_of_palm",
                    "text": "Hearts of palm"
                },
                {
                    "id": "Hominy",
                    "text": "Hominy"
                },
                {
                    "id": "Honey",
                    "text": "Honey"
                },
                {
                    "id": "Honey_roll_sausage",
                    "text": "Honey roll sausage"
                },
                {
                    "id": "Horned_melon_(Kiwano)",
                    "text": "Horned melon (Kiwano)"
                },
                {
                    "id": "Horseradish",
                    "text": "Horseradish"
                },
                {
                    "id": "Huckleberries",
                    "text": "Huckleberries"
                },
                {
                    "id": "Hummus",
                    "text": "Hummus"
                },
                {
                    "id": "Hush_puppies",
                    "text": "Hush puppies"
                },
                {
                    "id": "Hyacinth_beans",
                    "text": "Hyacinth beans"
                },
                {
                    "id": "Hyacinth-beans",
                    "text": "Hyacinth-beans"
                },
                {
                    "id": "Ice_cream",
                    "text": "Ice cream"
                },
                {
                    "id": "Ice_cream_bar",
                    "text": "Ice cream bar"
                },
                {
                    "id": "Ice_cream_cone",
                    "text": "Ice cream cone"
                },
                {
                    "id": "Ice_cream_cones",
                    "text": "Ice cream cones"
                },
                {
                    "id": "Ice_cream_cookie_sandwich",
                    "text": "Ice cream cookie sandwich"
                },
                {
                    "id": "Ice_cream_sandwich",
                    "text": "Ice cream sandwich"
                },
                {
                    "id": "Ice_cream_sundae_cone",
                    "text": "Ice cream sundae cone"
                },
                {
                    "id": "Ice_creams",
                    "text": "Ice creams"
                },
                {
                    "id": "Imitation_cheese",
                    "text": "Imitation cheese"
                },
                {
                    "id": "Incaparina",
                    "text": "Incaparina"
                },
                {
                    "id": "Infant_Formula",
                    "text": "Infant Formula"
                },
                {
                    "id": "Infant_formula",
                    "text": "Infant formula"
                },
                {
                    "id": "Jackfruit",
                    "text": "Jackfruit"
                },
                {
                    "id": "JACKSON_S",
                    "text": "JACKSON S"
                },
                {
                    "id": "Jams",
                    "text": "Jams"
                },
                {
                    "id": "Jams_and_preserves",
                    "text": "Jams and preserves"
                },
                {
                    "id": "Java-plum",
                    "text": "Java-plum"
                },
                {
                    "id": "Jellies",
                    "text": "Jellies"
                },
                {
                    "id": "Jellyfish",
                    "text": "Jellyfish"
                },
                {
                    "id": "Jerusalem-artichokes",
                    "text": "Jerusalem-artichokes"
                },
                {
                    "id": "Jew_s_ear",
                    "text": "Jew s ear"
                },
                {
                    "id": "Juice",
                    "text": "Juice"
                },
                {
                    "id": "Jujube",
                    "text": "Jujube"
                },
                {
                    "id": "Jute",
                    "text": "Jute"
                },
                {
                    "id": "Kale",
                    "text": "Kale"
                },
                {
                    "id": "Kanpyo",
                    "text": "Kanpyo"
                },
                {
                    "id": "Kefir",
                    "text": "Kefir"
                },
                {
                    "id": "Keikitos_(muffins)",
                    "text": "Keikitos (muffins)"
                },
                {
                    "id": "Kielbasa",
                    "text": "Kielbasa"
                },
                {
                    "id": "Kiwifruit",
                    "text": "Kiwifruit"
                },
                {
                    "id": "Knackwurst",
                    "text": "Knackwurst"
                },
                {
                    "id": "Kohlrabi",
                    "text": "Kohlrabi"
                },
                {
                    "id": "Kumquats",
                    "text": "Kumquats"
                },
                {
                    "id": "Lamb",
                    "text": "Lamb"
                },
                {
                    "id": "Lambsquarters",
                    "text": "Lambsquarters"
                },
                {
                    "id": "Lard",
                    "text": "Lard"
                },
                {
                    "id": "Lasagna",
                    "text": "Lasagna"
                },
                {
                    "id": "Lasagna_with_meat_&_sauce",
                    "text": "Lasagna with meat & sauce"
                },
                {
                    "id": "Lasagna_with_meat_sauce",
                    "text": "Lasagna with meat sauce"
                },
                {
                    "id": "Leavening_agents",
                    "text": "Leavening agents"
                },
                {
                    "id": "Lebanon_bologna",
                    "text": "Lebanon bologna"
                },
                {
                    "id": "Leeks",
                    "text": "Leeks"
                },
                {
                    "id": "Lemon_grass_(citronella)",
                    "text": "Lemon grass (citronella)"
                },
                {
                    "id": "Lemon_juice",
                    "text": "Lemon juice"
                },
                {
                    "id": "Lemon_peel",
                    "text": "Lemon peel"
                },
                {
                    "id": "Lemonade",
                    "text": "Lemonade"
                },
                {
                    "id": "Lemonade-flavor_drink",
                    "text": "Lemonade-flavor drink"
                },
                {
                    "id": "Lemons",
                    "text": "Lemons"
                },
                {
                    "id": "Lentils",
                    "text": "Lentils"
                },
                {
                    "id": "Lettuce",
                    "text": "Lettuce"
                },
                {
                    "id": "Light_ice_cream",
                    "text": "Light ice cream"
                },
                {
                    "id": "Lima_beans",
                    "text": "Lima beans"
                },
                {
                    "id": "Lime_juice",
                    "text": "Lime juice"
                },
                {
                    "id": "Limeade",
                    "text": "Limeade"
                },
                {
                    "id": "Limes",
                    "text": "Limes"
                },
                {
                    "id": "Litchis",
                    "text": "Litchis"
                },
                {
                    "id": "Liver_cheese",
                    "text": "Liver cheese"
                },
                {
                    "id": "Liver_sausage",
                    "text": "Liver sausage"
                },
                {
                    "id": "Liverwurst_spread",
                    "text": "Liverwurst spread"
                },
                {
                    "id": "Loganberries",
                    "text": "Loganberries"
                },
                {
                    "id": "Longans",
                    "text": "Longans"
                },
                {
                    "id": "Loquats",
                    "text": "Loquats"
                },
                {
                    "id": "Lotus_root",
                    "text": "Lotus root"
                },
                {
                    "id": "Luncheon_meat",
                    "text": "Luncheon meat"
                },
                {
                    "id": "Luncheon_sausage",
                    "text": "Luncheon sausage"
                },
                {
                    "id": "Luncheon_slices",
                    "text": "Luncheon slices"
                },
                {
                    "id": "Lupins",
                    "text": "Lupins"
                },
                {
                    "id": "Luxury_loaf",
                    "text": "Luxury loaf"
                },
                {
                    "id": "Macaroni",
                    "text": "Macaroni"
                },
                {
                    "id": "Macaroni_and_Cheese",
                    "text": "Macaroni and Cheese"
                },
                {
                    "id": "Malabar_spinach",
                    "text": "Malabar spinach"
                },
                {
                    "id": "Malt_beverage",
                    "text": "Malt beverage"
                },
                {
                    "id": "Malted_drink_mix",
                    "text": "Malted drink mix"
                },
                {
                    "id": "Mammy-apple",
                    "text": "Mammy-apple"
                },
                {
                    "id": "Mango",
                    "text": "Mango"
                },
                {
                    "id": "Mango_nectar",
                    "text": "Mango nectar"
                },
                {
                    "id": "Mangos",
                    "text": "Mangos"
                },
                {
                    "id": "Mangosteen",
                    "text": "Mangosteen"
                },
                {
                    "id": "Maraschino_cherries",
                    "text": "Maraschino cherries"
                },
                {
                    "id": "Margarine",
                    "text": "Margarine"
                },
                {
                    "id": "Marmalade",
                    "text": "Marmalade"
                },
                {
                    "id": "MARTHA_WHITE_FOODS",
                    "text": "MARTHA WHITE FOODS"
                },
                {
                    "id": "MARY_S_GONE_CRACKERS",
                    "text": "MARY S GONE CRACKERS"
                },
                {
                    "id": "Mashu_roots",
                    "text": "Mashu roots"
                },
                {
                    "id": "Mayonnaise",
                    "text": "Mayonnaise"
                },
                {
                    "id": "Mayonnaise_dressing",
                    "text": "Mayonnaise dressing"
                },
                {
                    "id": "Meal_supplement_drink",
                    "text": "Meal supplement drink"
                },
                {
                    "id": "Meat_drippings_(lard",
                    "text": "Meat drippings (lard"
                },
                {
                    "id": "Meat_extender",
                    "text": "Meat extender"
                },
                {
                    "id": "Meatballs",
                    "text": "Meatballs"
                },
                {
                    "id": "Melon",
                    "text": "Melon"
                },
                {
                    "id": "Melon_balls",
                    "text": "Melon balls"
                },
                {
                    "id": "Melons",
                    "text": "Melons"
                },
                {
                    "id": "Milk",
                    "text": "Milk"
                },
                {
                    "id": "Milk_and_cereal_bar",
                    "text": "Milk and cereal bar"
                },
                {
                    "id": "Milk_dessert",
                    "text": "Milk dessert"
                },
                {
                    "id": "Milk_dessert_bar",
                    "text": "Milk dessert bar"
                },
                {
                    "id": "Milk_shakes",
                    "text": "Milk shakes"
                },
                {
                    "id": "Milk_substitutes",
                    "text": "Milk substitutes"
                },
                {
                    "id": "Millet",
                    "text": "Millet"
                },
                {
                    "id": "Millet_flour",
                    "text": "Millet flour"
                },
                {
                    "id": "Miso",
                    "text": "Miso"
                },
                {
                    "id": "Molasses",
                    "text": "Molasses"
                },
                {
                    "id": "Mollusks",
                    "text": "Mollusks"
                },
                {
                    "id": "Moose",
                    "text": "Moose"
                },
                {
                    "id": "Mortadella",
                    "text": "Mortadella"
                },
                {
                    "id": "Mothbeans",
                    "text": "Mothbeans"
                },
                {
                    "id": "Mountain_yam",
                    "text": "Mountain yam"
                },
                {
                    "id": "Mouse_nuts",
                    "text": "Mouse nuts"
                },
                {
                    "id": "Muffin",
                    "text": "Muffin"
                },
                {
                    "id": "Muffins",
                    "text": "Muffins"
                },
                {
                    "id": "Mulberries",
                    "text": "Mulberries"
                },
                {
                    "id": "Mung_beans",
                    "text": "Mung beans"
                },
                {
                    "id": "Mungo_beans",
                    "text": "Mungo beans"
                },
                {
                    "id": "MURRAY",
                    "text": "MURRAY"
                },
                {
                    "id": "Mush",
                    "text": "Mush"
                },
                {
                    "id": "Mushroom",
                    "text": "Mushroom"
                },
                {
                    "id": "Mushrooms",
                    "text": "Mushrooms"
                },
                {
                    "id": "Mustard",
                    "text": "Mustard"
                },
                {
                    "id": "Mustard_greens",
                    "text": "Mustard greens"
                },
                {
                    "id": "Mustard_spinach",
                    "text": "Mustard spinach"
                },
                {
                    "id": "Mutton",
                    "text": "Mutton"
                },
                {
                    "id": "NABISCO",
                    "text": "NABISCO"
                },
                {
                    "id": "Nance",
                    "text": "Nance"
                },
                {
                    "id": "Naranjilla_(lulo)_pulp",
                    "text": "Naranjilla (lulo) pulp"
                },
                {
                    "id": "Natto",
                    "text": "Natto"
                },
                {
                    "id": "Nectarines",
                    "text": "Nectarines"
                },
                {
                    "id": "New_Zealand_spinach",
                    "text": "New Zealand spinach"
                },
                {
                    "id": "Noodles",
                    "text": "Noodles"
                },
                {
                    "id": "Nopales",
                    "text": "Nopales"
                },
                {
                    "id": "Nuts",
                    "text": "Nuts"
                },
                {
                    "id": "Oat_bran",
                    "text": "Oat bran"
                },
                {
                    "id": "Oat_flour",
                    "text": "Oat flour"
                },
                {
                    "id": "Oats",
                    "text": "Oats"
                },
                {
                    "id": "Octopus_(Alaska_Native)",
                    "text": "Octopus (Alaska Native)"
                },
                {
                    "id": "Oheloberries",
                    "text": "Oheloberries"
                },
                {
                    "id": "Oil",
                    "text": "Oil"
                },
                {
                    "id": "Okara",
                    "text": "Okara"
                },
                {
                    "id": "Okra",
                    "text": "Okra"
                },
                {
                    "id": "Olive_loaf",
                    "text": "Olive loaf"
                },
                {
                    "id": "Olives",
                    "text": "Olives"
                },
                {
                    "id": "Onion_rings",
                    "text": "Onion rings"
                },
                {
                    "id": "Onions",
                    "text": "Onions"
                },
                {
                    "id": "Oopah_(tunicate)",
                    "text": "Oopah (tunicate)"
                },
                {
                    "id": "Orange_and_apricot_juice_drink",
                    "text": "Orange and apricot juice drink"
                },
                {
                    "id": "Orange_breakfast_drink",
                    "text": "Orange breakfast drink"
                },
                {
                    "id": "Orange_drink",
                    "text": "Orange drink"
                },
                {
                    "id": "Orange_juice",
                    "text": "Orange juice"
                },
                {
                    "id": "Orange_peel",
                    "text": "Orange peel"
                },
                {
                    "id": "Orange_Pineapple_Juice_Blend",
                    "text": "Orange Pineapple Juice Blend"
                },
                {
                    "id": "Orange-flavor_drink",
                    "text": "Orange-flavor drink"
                },
                {
                    "id": "Orange-grapefruit_juice",
                    "text": "Orange-grapefruit juice"
                },
                {
                    "id": "Oranges",
                    "text": "Oranges"
                },
                {
                    "id": "Ostrich",
                    "text": "Ostrich"
                },
                {
                    "id": "Oven-roasted_chicken_breast_roll",
                    "text": "Oven-roasted chicken breast roll"
                },
                {
                    "id": "Owl",
                    "text": "Owl"
                },
                {
                    "id": "Pan_Dulce",
                    "text": "Pan Dulce"
                },
                {
                    "id": "Pancakes",
                    "text": "Pancakes"
                },
                {
                    "id": "Papad",
                    "text": "Papad"
                },
                {
                    "id": "Papaya",
                    "text": "Papaya"
                },
                {
                    "id": "Papaya_nectar",
                    "text": "Papaya nectar"
                },
                {
                    "id": "Papayas",
                    "text": "Papayas"
                },
                {
                    "id": "Parmesan_cheese_topping",
                    "text": "Parmesan cheese topping"
                },
                {
                    "id": "Parsley",
                    "text": "Parsley"
                },
                {
                    "id": "Parsnips",
                    "text": "Parsnips"
                },
                {
                    "id": "Passion-fruit",
                    "text": "Passion-fruit"
                },
                {
                    "id": "Passion-fruit_juice",
                    "text": "Passion-fruit juice"
                },
                {
                    "id": "Pasta",
                    "text": "Pasta"
                },
                {
                    "id": "Pasta_mix",
                    "text": "Pasta mix"
                },
                {
                    "id": "Pasta_with_tomato_sauce",
                    "text": "Pasta with tomato sauce"
                },
                {
                    "id": "Pastrami",
                    "text": "Pastrami"
                },
                {
                    "id": "Pastry",
                    "text": "Pastry"
                },
                {
                    "id": "Pate",
                    "text": "Pate"
                },
                {
                    "id": "Pate_de_foie_gras",
                    "text": "Pate de foie gras"
                },
                {
                    "id": "Peach_nectar",
                    "text": "Peach nectar"
                },
                {
                    "id": "Peaches",
                    "text": "Peaches"
                },
                {
                    "id": "Peanut_butter",
                    "text": "Peanut butter"
                },
                {
                    "id": "Peanut_flour",
                    "text": "Peanut flour"
                },
                {
                    "id": "Peanut_spread",
                    "text": "Peanut spread"
                },
                {
                    "id": "Peanuts",
                    "text": "Peanuts"
                },
                {
                    "id": "Pear_nectar",
                    "text": "Pear nectar"
                },
                {
                    "id": "Pears",
                    "text": "Pears"
                },
                {
                    "id": "Peas",
                    "text": "Peas"
                },
                {
                    "id": "Peas_and_carrots",
                    "text": "Peas and carrots"
                },
                {
                    "id": "Peas_and_onions",
                    "text": "Peas and onions"
                },
                {
                    "id": "Pectin",
                    "text": "Pectin"
                },
                {
                    "id": "Pepeao",
                    "text": "Pepeao"
                },
                {
                    "id": "Pepper",
                    "text": "Pepper"
                },
                {
                    "id": "Peppered_loaf",
                    "text": "Peppered loaf"
                },
                {
                    "id": "Peppermint",
                    "text": "Peppermint"
                },
                {
                    "id": "Pepperoni",
                    "text": "Pepperoni"
                },
                {
                    "id": "Peppers",
                    "text": "Peppers"
                },
                {
                    "id": "Persimmons",
                    "text": "Persimmons"
                },
                {
                    "id": "Pheasant",
                    "text": "Pheasant"
                },
                {
                    "id": "Phyllo_dough",
                    "text": "Phyllo dough"
                },
                {
                    "id": "Pickle_and_pimiento_loaf",
                    "text": "Pickle and pimiento loaf"
                },
                {
                    "id": "Pickle_relish",
                    "text": "Pickle relish"
                },
                {
                    "id": "Pickles",
                    "text": "Pickles"
                },
                {
                    "id": "Picnic_loaf",
                    "text": "Picnic loaf"
                },
                {
                    "id": "Pie",
                    "text": "Pie"
                },
                {
                    "id": "Pie_crust",
                    "text": "Pie crust"
                },
                {
                    "id": "Pie_fillings",
                    "text": "Pie fillings"
                },
                {
                    "id": "Pigeon_peas_(red_gram)",
                    "text": "Pigeon peas (red gram)"
                },
                {
                    "id": "Pigeonpeas",
                    "text": "Pigeonpeas"
                },
                {
                    "id": "Piki_bread",
                    "text": "Piki bread"
                },
                {
                    "id": "Pimento",
                    "text": "Pimento"
                },
                {
                    "id": "Pineapple",
                    "text": "Pineapple"
                },
                {
                    "id": "Pineapple_and_grapefruit_juice_drink",
                    "text": "Pineapple and grapefruit juice drink"
                },
                {
                    "id": "Pineapple_and_orange_juice_drink",
                    "text": "Pineapple and orange juice drink"
                },
                {
                    "id": "Pineapple_juice",
                    "text": "Pineapple juice"
                },
                {
                    "id": "Pinon_Nuts",
                    "text": "Pinon Nuts"
                },
                {
                    "id": "Pitanga",
                    "text": "Pitanga"
                },
                {
                    "id": "Pizza",
                    "text": "Pizza"
                },
                {
                    "id": "Pizza_rolls",
                    "text": "Pizza rolls"
                },
                {
                    "id": "Plantains",
                    "text": "Plantains"
                },
                {
                    "id": "Plums",
                    "text": "Plums"
                },
                {
                    "id": "Poi",
                    "text": "Poi"
                },
                {
                    "id": "Pokeberry_shoots",
                    "text": "Pokeberry shoots"
                },
                {
                    "id": "Polish_sausage",
                    "text": "Polish sausage"
                },
                {
                    "id": "Pomegranate_juice",
                    "text": "Pomegranate juice"
                },
                {
                    "id": "Pomegranates",
                    "text": "Pomegranates"
                },
                {
                    "id": "Popcorn",
                    "text": "Popcorn"
                },
                {
                    "id": "Popovers",
                    "text": "Popovers"
                },
                {
                    "id": "Pork",
                    "text": "Pork"
                },
                {
                    "id": "Pork_and_beef_sausage",
                    "text": "Pork and beef sausage"
                },
                {
                    "id": "Pork_and_turkey_sausage",
                    "text": "Pork and turkey sausage"
                },
                {
                    "id": "Pork_loin",
                    "text": "Pork loin"
                },
                {
                    "id": "Pork_sausage",
                    "text": "Pork sausage"
                },
                {
                    "id": "Pork_sausage_rice_links",
                    "text": "Pork sausage rice links"
                },
                {
                    "id": "Potato_chips",
                    "text": "Potato chips"
                },
                {
                    "id": "Potato_flour",
                    "text": "Potato flour"
                },
                {
                    "id": "Potato_pancakes",
                    "text": "Potato pancakes"
                },
                {
                    "id": "Potato_puffs",
                    "text": "Potato puffs"
                },
                {
                    "id": "Potato_salad",
                    "text": "Potato salad"
                },
                {
                    "id": "Potato_salad_with_egg",
                    "text": "Potato salad with egg"
                },
                {
                    "id": "Potato_soup",
                    "text": "Potato soup"
                },
                {
                    "id": "Potatoes",
                    "text": "Potatoes"
                },
                {
                    "id": "Potsticker_or_wonton",
                    "text": "Potsticker or wonton"
                },
                {
                    "id": "Poultry",
                    "text": "Poultry"
                },
                {
                    "id": "Poultry_salad_sandwich_spread",
                    "text": "Poultry salad sandwich spread"
                },
                {
                    "id": "Prairie_Turnips",
                    "text": "Prairie Turnips"
                },
                {
                    "id": "Pretzels",
                    "text": "Pretzels"
                },
                {
                    "id": "Prickly_pears",
                    "text": "Prickly pears"
                },
                {
                    "id": "Protein_supplement",
                    "text": "Protein supplement"
                },
                {
                    "id": "Prune_juice",
                    "text": "Prune juice"
                },
                {
                    "id": "Prune_puree",
                    "text": "Prune puree"
                },
                {
                    "id": "Prunes",
                    "text": "Prunes"
                },
                {
                    "id": "Pudding",
                    "text": "Pudding"
                },
                {
                    "id": "Puddings",
                    "text": "Puddings"
                },
                {
                    "id": "Puff_pastry",
                    "text": "Puff pastry"
                },
                {
                    "id": "Pulled_pork_in_barbecue_sauce",
                    "text": "Pulled pork in barbecue sauce"
                },
                {
                    "id": "Pummelo",
                    "text": "Pummelo"
                },
                {
                    "id": "Pumpkin",
                    "text": "Pumpkin"
                },
                {
                    "id": "Pumpkin_flowers",
                    "text": "Pumpkin flowers"
                },
                {
                    "id": "Pumpkin_leaves",
                    "text": "Pumpkin leaves"
                },
                {
                    "id": "Pumpkin_pie_mix",
                    "text": "Pumpkin pie mix"
                },
                {
                    "id": "Purslane",
                    "text": "Purslane"
                },
                {
                    "id": "Quail",
                    "text": "Quail"
                },
                {
                    "id": "Quinces",
                    "text": "Quinces"
                },
                {
                    "id": "Quinoa",
                    "text": "Quinoa"
                },
                {
                    "id": "Radicchio",
                    "text": "Radicchio"
                },
                {
                    "id": "Radish_seeds",
                    "text": "Radish seeds"
                },
                {
                    "id": "Radishes",
                    "text": "Radishes"
                },
                {
                    "id": "Raisins",
                    "text": "Raisins"
                },
                {
                    "id": "Rambutan",
                    "text": "Rambutan"
                },
                {
                    "id": "Raspberries",
                    "text": "Raspberries"
                },
                {
                    "id": "Ravioli",
                    "text": "Ravioli"
                },
                {
                    "id": "Refried_beans",
                    "text": "Refried beans"
                },
                {
                    "id": "Rennin",
                    "text": "Rennin"
                },
                {
                    "id": "Restaurant",
                    "text": "Restaurant"
                },
                {
                    "id": "Rhubarb",
                    "text": "Rhubarb"
                },
                {
                    "id": "Rice",
                    "text": "Rice"
                },
                {
                    "id": "Rice_and_vermicelli_mix",
                    "text": "Rice and vermicelli mix"
                },
                {
                    "id": "Rice_and_Wheat_cereal_bar",
                    "text": "Rice and Wheat cereal bar"
                },
                {
                    "id": "Rice_bowl_with_chicken",
                    "text": "Rice bowl with chicken"
                },
                {
                    "id": "Rice_bran",
                    "text": "Rice bran"
                },
                {
                    "id": "Rice_cake",
                    "text": "Rice cake"
                },
                {
                    "id": "Rice_crackers",
                    "text": "Rice crackers"
                },
                {
                    "id": "Rice_flour",
                    "text": "Rice flour"
                },
                {
                    "id": "Rice_mix",
                    "text": "Rice mix"
                },
                {
                    "id": "Rice_noodles",
                    "text": "Rice noodles"
                },
                {
                    "id": "Roast_beef",
                    "text": "Roast beef"
                },
                {
                    "id": "Roast_beef_spread",
                    "text": "Roast beef spread"
                },
                {
                    "id": "Rolls",
                    "text": "Rolls"
                },
                {
                    "id": "Rose_Hips",
                    "text": "Rose Hips"
                },
                {
                    "id": "Rose-apples",
                    "text": "Rose-apples"
                },
                {
                    "id": "Roselle",
                    "text": "Roselle"
                },
                {
                    "id": "Rosemary",
                    "text": "Rosemary"
                },
                {
                    "id": "Rowal",
                    "text": "Rowal"
                },
                {
                    "id": "Ruby_Red_grapefruit_juice_blend_(grapefruit",
                    "text": "Ruby Red grapefruit juice blend (grapefruit"
                },
                {
                    "id": "Ruffed_Grouse",
                    "text": "Ruffed Grouse"
                },
                {
                    "id": "Rutabagas",
                    "text": "Rutabagas"
                },
                {
                    "id": "Rye_flour",
                    "text": "Rye flour"
                },
                {
                    "id": "Rye_grain",
                    "text": "Rye grain"
                },
                {
                    "id": "Salad_dressing",
                    "text": "Salad dressing"
                },
                {
                    "id": "Salami",
                    "text": "Salami"
                },
                {
                    "id": "Salisbury_steak_with_gravy",
                    "text": "Salisbury steak with gravy"
                },
                {
                    "id": "Salmon",
                    "text": "Salmon"
                },
                {
                    "id": "Salmonberries",
                    "text": "Salmonberries"
                },
                {
                    "id": "Salsify",
                    "text": "Salsify"
                },
                {
                    "id": "Salt",
                    "text": "Salt"
                },
                {
                    "id": "Sandwich_spread",
                    "text": "Sandwich spread"
                },
                {
                    "id": "Sapodilla",
                    "text": "Sapodilla"
                },
                {
                    "id": "Sapote",
                    "text": "Sapote"
                },
                {
                    "id": "Sauce",
                    "text": "Sauce"
                },
                {
                    "id": "Sauerkraut",
                    "text": "Sauerkraut"
                },
                {
                    "id": "Sausage",
                    "text": "Sausage"
                },
                {
                    "id": "School_Lunch",
                    "text": "School Lunch"
                },
                {
                    "id": "Scrapple",
                    "text": "Scrapple"
                },
                {
                    "id": "Sea_cucumber",
                    "text": "Sea cucumber"
                },
                {
                    "id": "Sea_lion",
                    "text": "Sea lion"
                },
                {
                    "id": "Seal",
                    "text": "Seal"
                },
                {
                    "id": "Seasoning_mix",
                    "text": "Seasoning mix"
                },
                {
                    "id": "Seaweed",
                    "text": "Seaweed"
                },
                {
                    "id": "Seeds",
                    "text": "Seeds"
                },
                {
                    "id": "Semolina",
                    "text": "Semolina"
                },
                {
                    "id": "Sesbania_flower",
                    "text": "Sesbania flower"
                },
                {
                    "id": "Shake",
                    "text": "Shake"
                },
                {
                    "id": "Shallots",
                    "text": "Shallots"
                },
                {
                    "id": "Sherbet",
                    "text": "Sherbet"
                },
                {
                    "id": "Shortening",
                    "text": "Shortening"
                },
                {
                    "id": "Smelt",
                    "text": "Smelt"
                },
                {
                    "id": "Smoked_link_sausage",
                    "text": "Smoked link sausage"
                },
                {
                    "id": "Snack",
                    "text": "Snack"
                },
                {
                    "id": "Snacks",
                    "text": "Snacks"
                },
                {
                    "id": "Sorghum_flour",
                    "text": "Sorghum flour"
                },
                {
                    "id": "Soup",
                    "text": "Soup"
                },
                {
                    "id": "Sour_cream",
                    "text": "Sour cream"
                },
                {
                    "id": "Sour_dressing",
                    "text": "Sour dressing"
                },
                {
                    "id": "Sourdock",
                    "text": "Sourdock"
                },
                {
                    "id": "Soursop",
                    "text": "Soursop"
                },
                {
                    "id": "Soy_flour",
                    "text": "Soy flour"
                },
                {
                    "id": "Soy_meal",
                    "text": "Soy meal"
                },
                {
                    "id": "Soy_protein_concentrate",
                    "text": "Soy protein concentrate"
                },
                {
                    "id": "Soy_protein_isolate",
                    "text": "Soy protein isolate"
                },
                {
                    "id": "Soy_sauce",
                    "text": "Soy sauce"
                },
                {
                    "id": "Soybean",
                    "text": "Soybean"
                },
                {
                    "id": "Soymilk",
                    "text": "Soymilk"
                },
                {
                    "id": "Spaghetti",
                    "text": "Spaghetti"
                },
                {
                    "id": "Spaghetti_with_meat_sauce",
                    "text": "Spaghetti with meat sauce"
                },
                {
                    "id": "SPAGHETTIOS",
                    "text": "SPAGHETTIOS"
                },
                {
                    "id": "Spanish_rice_mix",
                    "text": "Spanish rice mix"
                },
                {
                    "id": "Spearmint",
                    "text": "Spearmint"
                },
                {
                    "id": "Spelt",
                    "text": "Spelt"
                },
                {
                    "id": "Spices",
                    "text": "Spices"
                },
                {
                    "id": "Spinach",
                    "text": "Spinach"
                },
                {
                    "id": "Spinach_souffle",
                    "text": "Spinach souffle"
                },
                {
                    "id": "Split_pea_soup",
                    "text": "Split pea soup"
                },
                {
                    "id": "Split_pea_with_ham_soup",
                    "text": "Split pea with ham soup"
                },
                {
                    "id": "Squab",
                    "text": "Squab"
                },
                {
                    "id": "Squash",
                    "text": "Squash"
                },
                {
                    "id": "Squirrel",
                    "text": "Squirrel"
                },
                {
                    "id": "Steelhead_trout",
                    "text": "Steelhead trout"
                },
                {
                    "id": "Stew",
                    "text": "Stew"
                },
                {
                    "id": "Stew/soup",
                    "text": "Stew/soup"
                },
                {
                    "id": "Stinging_Nettles",
                    "text": "Stinging Nettles"
                },
                {
                    "id": "Strawberries",
                    "text": "Strawberries"
                },
                {
                    "id": "Strudel",
                    "text": "Strudel"
                },
                {
                    "id": "Succotash",
                    "text": "Succotash"
                },
                {
                    "id": "Sugar",
                    "text": "Sugar"
                },
                {
                    "id": "Sugar-apples",
                    "text": "Sugar-apples"
                },
                {
                    "id": "Sugars",
                    "text": "Sugars"
                },
                {
                    "id": "Swamp_cabbage",
                    "text": "Swamp cabbage"
                },
                {
                    "id": "Sweet_potato",
                    "text": "Sweet potato"
                },
                {
                    "id": "Sweet_potato_leaves",
                    "text": "Sweet potato leaves"
                },
                {
                    "id": "Sweet_Potato_puffs",
                    "text": "Sweet Potato puffs"
                },
                {
                    "id": "Sweet_Potatoes",
                    "text": "Sweet Potatoes"
                },
                {
                    "id": "Sweet_rolls",
                    "text": "Sweet rolls"
                },
                {
                    "id": "Sweetener",
                    "text": "Sweetener"
                },
                {
                    "id": "Sweeteners",
                    "text": "Sweeteners"
                },
                {
                    "id": "Swisswurst",
                    "text": "Swisswurst"
                },
                {
                    "id": "Syrup",
                    "text": "Syrup"
                },
                {
                    "id": "Syrups",
                    "text": "Syrups"
                },
                {
                    "id": "Taco_shells",
                    "text": "Taco shells"
                },
                {
                    "id": "Tamales",
                    "text": "Tamales"
                },
                {
                    "id": "Tamarind_nectar",
                    "text": "Tamarind nectar"
                },
                {
                    "id": "Tamarinds",
                    "text": "Tamarinds"
                },
                {
                    "id": "Tangerine_juice",
                    "text": "Tangerine juice"
                },
                {
                    "id": "Tangerines",
                    "text": "Tangerines"
                },
                {
                    "id": "Tapioca",
                    "text": "Tapioca"
                },
                {
                    "id": "Taquitos",
                    "text": "Taquitos"
                },
                {
                    "id": "Taro",
                    "text": "Taro"
                },
                {
                    "id": "Taro_leaves",
                    "text": "Taro leaves"
                },
                {
                    "id": "Taro_shoots",
                    "text": "Taro shoots"
                },
                {
                    "id": "Tea",
                    "text": "Tea"
                },
                {
                    "id": "Teff",
                    "text": "Teff"
                },
                {
                    "id": "Tempeh",
                    "text": "Tempeh"
                },
                {
                    "id": "Tennis_Bread",
                    "text": "Tennis Bread"
                },
                {
                    "id": "Thuringer",
                    "text": "Thuringer"
                },
                {
                    "id": "Thyme",
                    "text": "Thyme"
                },
                {
                    "id": "Toaster_Pastries",
                    "text": "Toaster Pastries"
                },
                {
                    "id": "Toaster_pastries",
                    "text": "Toaster pastries"
                },
                {
                    "id": "Toddler_formula",
                    "text": "Toddler formula"
                },
                {
                    "id": "Tofu",
                    "text": "Tofu"
                },
                {
                    "id": "Tofu_yogurt",
                    "text": "Tofu yogurt"
                },
                {
                    "id": "Tomatillos",
                    "text": "Tomatillos"
                },
                {
                    "id": "Tomato_and_vegetable_juice",
                    "text": "Tomato and vegetable juice"
                },
                {
                    "id": "Tomato_juice",
                    "text": "Tomato juice"
                },
                {
                    "id": "Tomato_powder",
                    "text": "Tomato powder"
                },
                {
                    "id": "Tomato_products",
                    "text": "Tomato products"
                },
                {
                    "id": "Tomato_sauce",
                    "text": "Tomato sauce"
                },
                {
                    "id": "Tomatoes",
                    "text": "Tomatoes"
                },
                {
                    "id": "Topping",
                    "text": "Topping"
                },
                {
                    "id": "Toppings",
                    "text": "Toppings"
                },
                {
                    "id": "Tortellini",
                    "text": "Tortellini"
                },
                {
                    "id": "Tortilla",
                    "text": "Tortilla"
                },
                {
                    "id": "Tortilla_chips",
                    "text": "Tortilla chips"
                },
                {
                    "id": "Tortillas",
                    "text": "Tortillas"
                },
                {
                    "id": "Tostada_shells",
                    "text": "Tostada shells"
                },
                {
                    "id": "Tree_fern",
                    "text": "Tree fern"
                },
                {
                    "id": "Triticale",
                    "text": "Triticale"
                },
                {
                    "id": "Triticale_flour",
                    "text": "Triticale flour"
                },
                {
                    "id": "Turkey",
                    "text": "Turkey"
                },
                {
                    "id": "Turkey_and_gravy",
                    "text": "Turkey and gravy"
                },
                {
                    "id": "Turkey_and_pork_sausage",
                    "text": "Turkey and pork sausage"
                },
                {
                    "id": "Turkey_bacon",
                    "text": "Turkey bacon"
                },
                {
                    "id": "Turkey_breast",
                    "text": "Turkey breast"
                },
                {
                    "id": "Turkey_from_whole",
                    "text": "Turkey from whole"
                },
                {
                    "id": "Turkey_ham",
                    "text": "Turkey ham"
                },
                {
                    "id": "Turkey_Pot_Pie",
                    "text": "Turkey Pot Pie"
                },
                {
                    "id": "Turkey_roast",
                    "text": "Turkey roast"
                },
                {
                    "id": "Turkey_sausage",
                    "text": "Turkey sausage"
                },
                {
                    "id": "Turkey_sticks",
                    "text": "Turkey sticks"
                },
                {
                    "id": "Turkey_thigh",
                    "text": "Turkey thigh"
                },
                {
                    "id": "Turnip_greens",
                    "text": "Turnip greens"
                },
                {
                    "id": "Turnip_greens_and_turnips",
                    "text": "Turnip greens and turnips"
                },
                {
                    "id": "Turnips",
                    "text": "Turnips"
                },
                {
                    "id": "Turnover",
                    "text": "Turnover"
                },
                {
                    "id": "Turtle",
                    "text": "Turtle"
                },
                {
                    "id": "Vanilla_extract",
                    "text": "Vanilla extract"
                },
                {
                    "id": "Veal",
                    "text": "Veal"
                },
                {
                    "id": "Vegetable_juice",
                    "text": "Vegetable juice"
                },
                {
                    "id": "Vegetable_juice_cocktail",
                    "text": "Vegetable juice cocktail"
                },
                {
                    "id": "Vegetable_oil",
                    "text": "Vegetable oil"
                },
                {
                    "id": "Vegetable_oil-butter_spread",
                    "text": "Vegetable oil-butter spread"
                },
                {
                    "id": "Vegetable_smoothie",
                    "text": "Vegetable smoothie"
                },
                {
                    "id": "Vegetables",
                    "text": "Vegetables"
                },
                {
                    "id": "Vegetarian_fillets",
                    "text": "Vegetarian fillets"
                },
                {
                    "id": "Vegetarian_meatloaf_or_patties",
                    "text": "Vegetarian meatloaf or patties"
                },
                {
                    "id": "Veggie_burgers_or_soyburgers",
                    "text": "Veggie burgers or soyburgers"
                },
                {
                    "id": "Vermicelli",
                    "text": "Vermicelli"
                },
                {
                    "id": "Vinegar",
                    "text": "Vinegar"
                },
                {
                    "id": "Vinespinach",
                    "text": "Vinespinach"
                },
                {
                    "id": "Vital_wheat_gluten",
                    "text": "Vital wheat gluten"
                },
                {
                    "id": "Waffle",
                    "text": "Waffle"
                },
                {
                    "id": "Waffles",
                    "text": "Waffles"
                },
                {
                    "id": "Walrus",
                    "text": "Walrus"
                },
                {
                    "id": "Wasabi",
                    "text": "Wasabi"
                },
                {
                    "id": "Water",
                    "text": "Water"
                },
                {
                    "id": "Waterchestnuts",
                    "text": "Waterchestnuts"
                },
                {
                    "id": "Watercress",
                    "text": "Watercress"
                },
                {
                    "id": "Watermelon",
                    "text": "Watermelon"
                },
                {
                    "id": "Waxgourd",
                    "text": "Waxgourd"
                },
                {
                    "id": "Whale",
                    "text": "Whale"
                },
                {
                    "id": "Wheat",
                    "text": "Wheat"
                },
                {
                    "id": "Wheat_bran",
                    "text": "Wheat bran"
                },
                {
                    "id": "Wheat_flour",
                    "text": "Wheat flour"
                },
                {
                    "id": "Wheat_flours",
                    "text": "Wheat flours"
                },
                {
                    "id": "Wheat_germ",
                    "text": "Wheat germ"
                },
                {
                    "id": "Whey",
                    "text": "Whey"
                },
                {
                    "id": "Whipped_cream_substitute",
                    "text": "Whipped cream substitute"
                },
                {
                    "id": "Whipped_topping",
                    "text": "Whipped topping"
                },
                {
                    "id": "Whiskey_sour_mix",
                    "text": "Whiskey sour mix"
                },
                {
                    "id": "Wild_rice",
                    "text": "Wild rice"
                },
                {
                    "id": "Willow",
                    "text": "Willow"
                },
                {
                    "id": "Winged_bean",
                    "text": "Winged bean"
                },
                {
                    "id": "Winged_bean_leaves",
                    "text": "Winged bean leaves"
                },
                {
                    "id": "Winged_bean_tuber",
                    "text": "Winged bean tuber"
                },
                {
                    "id": "Winged_beans",
                    "text": "Winged beans"
                },
                {
                    "id": "Wocas",
                    "text": "Wocas"
                },
                {
                    "id": "Wonton_wrappers_(includes_egg_roll_wrappers)",
                    "text": "Wonton wrappers (includes egg roll wrappers)"
                },
                {
                    "id": "Yachtwurst",
                    "text": "Yachtwurst"
                },
                {
                    "id": "Yam",
                    "text": "Yam"
                },
                {
                    "id": "Yambean_(jicama)",
                    "text": "Yambean (jicama)"
                },
                {
                    "id": "Yardlong_bean",
                    "text": "Yardlong bean"
                },
                {
                    "id": "Yardlong_beans",
                    "text": "Yardlong beans"
                },
                {
                    "id": "Yautia_(tannier)",
                    "text": "Yautia (tannier)"
                },
                {
                    "id": "Yeast_extract_spread",
                    "text": "Yeast extract spread"
                },
                {
                    "id": "Yellow_rice_with_seasoning",
                    "text": "Yellow rice with seasoning"
                },
                {
                    "id": "Yogurt",
                    "text": "Yogurt"
                },
                {
                    "id": "Yogurt_parfait",
                    "text": "Yogurt parfait"
                },
                {
                    "id": "Yokan",
                    "text": "Yokan"
                },
                {
                    "id": "Zwieback",
                    "text": "Zwieback"
                }
            ]
        };
        this.handleAllergenDelete = this.handleAllergenDelete.bind(this);
        this.handleAllergenAddition = this.handleAllergenAddition.bind(this);
        this.handleAllergenDrag = this.handleAllergenDrag.bind(this);

        this.handleLikedDelete = this.handleLikedDelete.bind(this);
        this.handleLikedAddition = this.handleLikedAddition.bind(this);
        this.handleLikedDrag = this.handleLikedDrag.bind(this);
    }

    handleAllergenDelete(i) {
        const { allergenTags } = this.state;
        this.setState({
            allergenTags: allergenTags.filter((tag, index) => index !== i),
        });
    }
    handleLikedDelete(i) {
        const { likedTags } = this.state;
        this.setState({
            likedTags: likedTags.filter((tag, index) => index !== i),
        });
    }

    handleAllergenAddition(tag) {
        this.setState(state => ({ allergenTags: [...state.allergenTags, tag] }));
    }

    handleLikedAddition(tag) {
        this.setState(state => ({ likedTags: [...state.likedTags, tag] }));
    }

    handleAllergenDrag(tag, currPos, newPos) {
        const allergenTags = [...this.state.allergenTags];
        const newallergenTags = allergenTags.slice();

        newallergenTags.splice(currPos, 1);
        newallergenTags.splice(newPos, 0, tag);

        // re-render
        this.setState({ allergenTags: newallergenTags });
    }

    handleLikedDrag(tag, currPos, newPos) {
        const likedTags = [...this.state.likedTags];
        const newlikedTags = likedTags.slice();

        newlikedTags.splice(currPos, 1);
        newlikedTags.splice(newPos, 0, tag);

        // re-render
        this.setState({ likedTags: newlikedTags });
    }

    render() {
        const { allergenTags, likedTags, suggestions } = this.state;
        return (
            <div>
                <h3 style={{ paddingTop: "20px" }}> Allergens</h3>
                <Card style={{ padding: 20 }}>
                    <ReactTags tags={allergenTags}
                        suggestions={suggestions}
                        handleDelete={this.handleAllergenDelete}
                        handleAddition={this.handleAllergenAddition}
                        handleDrag={this.handleAllergenDrag}
                        delimiters={delimiters} />
                </Card>
                <h3 style={{ paddingTop: "20px" }}> Preferred Ingredients</h3>
                <Card style={{ padding: 20 }}>
                    <ReactTags tags={likedTags}
                        suggestions={suggestions}
                        handleDelete={this.handleLikedDelete}
                        handleAddition={this.handleLikedAddition}
                        handleDrag={this.handleLikedDrag}
                        delimiters={delimiters} />
                </Card>

            </div>
        )
    }
}



export default (Restrictions);