import React from 'react';
import ReactDOM from 'react-dom';
//import HTML5Backend from 'react-dnd-html5-backend';
import { WithContext as ReactTags } from 'react-tag-input';
import { connect } from 'react-redux';
import { Card } from 'react-bootstrap';
import foods from "./foods.json";


const KeyCodes = {
    comma: 188,
    enter: 13,
};

const delimiters = [KeyCodes.comma, KeyCodes.enter];



class Recipes extends React.Component {
    componentDidUpdate(prevProps, prevState) {
        if (prevState !== this.state) {
            this.props.onChange(this.state)
        }
    }
    constructor(props) {
        super(props);

        this.state = {
            blockedTags: this.props.data.blocked?.map((item) => {
                return { id: item.toString(), text: foods[item]["name"] };
            }) || [],

            likedTags: this.props.data.liked?.map((item) => {
                return { id: item.toString(), text: foods[item]["name"] };
            }) || [],

        };
        this.handleBlockedDelete = this.handleBlockedDelete.bind(this);
        this.handleBlockedAddition = this.handleBlockedAddition.bind(this);
        this.handleBlockedDrag = this.handleBlockedDrag.bind(this);
        this.handleBlockedClick = this.handleBlockedClick.bind(this);

        this.handleLikedDelete = this.handleLikedDelete.bind(this);
        this.handleLikedAddition = this.handleLikedAddition.bind(this);
        this.handleLikedDrag = this.handleLikedDrag.bind(this);
        this.handleLikedClick = this.handleLikedClick.bind(this);
    }

    handleBlockedDelete(i) {
        const { blockedTags } = this.state;
        this.setState({
            blockedTags: blockedTags.filter((tag, index) => index !== i),
        });
    }
    handleLikedDelete(i) {
        const { likedTags } = this.state;
        this.setState({
            likedTags: likedTags.filter((tag, index) => index !== i),
        });
    }

    handleBlockedAddition(tag) {
        this.setState(state => ({ blockedTags: [...state.blockedTags, tag] }));
    }

    handleLikedAddition(tag) {
        this.setState(state => ({ likedTags: [...state.likedTags, tag] }));
    }

    handleBlockedDrag(tag, currPos, newPos) {
        const blockedTags = [...this.state.blockedTags];
        const newblockedTags = blockedTags.slice();

        newblockedTags.splice(currPos, 1);
        newblockedTags.splice(newPos, 0, tag);

        // re-render
        this.setState({ blockedTags: newblockedTags });
    }

    handleLikedDrag(tag, currPos, newPos) {
        const likedTags = [...this.state.likedTags];
        const newlikedTags = likedTags.slice();

        newlikedTags.splice(currPos, 1);
        newlikedTags.splice(newPos, 0, tag);

        // re-render
        this.setState({ likedTags: newlikedTags });
    }
    handleLikedClick(index) {
        const { likedTags } = this.state;
        let recipeIndex = parseInt(likedTags[index].id);
        window.open(foods[recipeIndex].src, '_blank');
    }
    handleBlockedClick(index) {
        const { blockedTags } = this.state;
        let recipeIndex = parseInt(blockedTags[index].id);
        window.open(foods[recipeIndex].src, '_blank');
    }
    render() {
        const { blockedTags, likedTags, suggestions } = this.state;
        return (
            <div>
                <h3 style={{ paddingTop: "20px" }}> Liked Recipes</h3>
                <Card style={{ padding: 20}}>
                    <ReactTags tags={likedTags}
                        classNames={{
                            tagInput: 'hiddenInput',
                            tagInputField: 'hiddenInputField',

                        }}
                        allowDragDrop={false}
                        handleDelete={this.handleLikedDelete}
                        handleAddition={this.handleLikedAddition}
                        handleDrag={this.handleLikedDrag}
                        handleTagClick={this.handleLikedClick}
                        delimiters={delimiters} />
                </Card>
                <h3 style={{ paddingTop: "20px" }}> Blocked Recipes</h3>
                <Card style={{ padding: 20, marginBottom: 40}}>
                    <ReactTags tags={blockedTags}
                        classNames={{
                            tagInput: 'hiddenInput',
                            tagInputField: 'hiddenInputField',

                        }}
                        allowDragDrop={false}
                        handleDelete={this.handleBlockedDelete}
                        handleAddition={this.handleBlockedAddition}
                        handleDrag={this.handleBlockedDrag}
                        handleTagClick={this.handleBlockedClick}
                        delimiters={delimiters} />
                </Card>


            </div>
        )
    }
}


export default (Recipes);