import firebase from "firebase/app";
import "firebase/auth";

export function getUserData(token, segment = "all") {
    return function (dispatch) {
        return new Promise((resolve, reject) => {
            const headers = {
                'Authorization': `Bearer ${token}`
            };
            return fetch(`https://us-central1-dietlp.cloudfunctions.net/app/user/${segment}`, { headers })
                .then(response => { console.log(response); return response.json() })
                .then(data => {
                    // eslint-disable-next-line eqeqeq
                    if (data.success == -1) {
                        console.log("There was no data stored (or we couldn't find it)")
                    }
                    dispatch({
                        type: `USERDATA`,
                        data: data.success,
                    })
                    dispatch({
                        type: `HISTORY`,
                        data: data.success.history,
                    })
                    resolve()
                })
                .catch(function (err) {
                    console.log(`There was an error fetching data: ${err}`)
                    reject(err)
                });
        });
    }
}

export function updateUserData(token, newUserData, snackbar) {
    return function (dispatch) {
        const headers = {
            'Authorization': `Bearer ${token}`,
            'Accept': 'application/json',
            'Content-Type': 'application/json'

        };
        return fetch('https://us-central1-dietlp.cloudfunctions.net/app/user', {
            headers,
            method: "POST",
            body: JSON.stringify(newUserData)
        })
            .then(response => response.json())
            .then(data => {
                // eslint-disable-next-line eqeqeq
                snackbar("Successfully updated your data!", "success")
                dispatch({
                    type: `USERDATA`,
                    data: newUserData
                })
            })
            .catch(function (err) {
                snackbar("Failed to update. Try again later.", "error")
                console.log(`There was an error posting data: ${err}`)
            });
    };
}

export function updateToken(token) {
    return function (dispatch) {
        if (token == null) {
            console.log("error initializing token")
        } else {
            dispatch({
                type: "TOKEN",
                data: token,
            })
        }
    }
}

export function addSolution(solution) {
    return function (dispatch) {
        if (solution == null) {
            console.log("error with solution")
        } else {
            dispatch({
                type: "SOLUTION",
                data: solution,
            })
        }
    }
}

export function signOut(status) {

    console.log(`Update auth to: ${status}`)
    return function (dispatch) {

        firebase.auth().signOut().then(() => {
            // Sign-out successful.
            dispatch({
                type: 'UNAUTHENTICATED'
            })
        }).catch((error) => {
            // An error happened.
        });

    }
}