/**
 * Created on Sep 28, 2005
 */

import java.rmi.*;
import java.rmi.server.*;

/**
 * @author Ariel Cohen
 */
public class ResponderImp extends UnicastRemoteObject implements Responder{
	private static final long serialVersionUID = 7526472295622776147L;
    private String myName; //name of the Responder
    
    /**
	 * Constructor for the ResponderImp.
	 * @param myName The Responder's name
	 * @exception RemoteException There is no RMI.
	 */    
	public ResponderImp(String myName) throws RemoteException{		
	 this.myName = myName;
	}
	
	/**
	 * Initiates a conversation with the Responder who replies to it 
	 * @param initiatorName The Initiator's name
	 * @param initiatorHost The Initiator's host
	 * @param message The first message
	 * @throws RemoteException There is no RMI connection
	 */	
	public void initiateConversationWithResponder(String initiatorName, String initiatorHost, String message) throws RemoteException{
		System.out.println(initiatorName + " said:");
		System.out.println(message);
		Initiator initiator = initiatorNameLookUp(initiatorHost, initiatorName);
		initiator.conversation(myName, "I don't wish to talk!");
	}

	/**
	 * Looks for the Initiator's address based on its host and name
	 * @param host Host name
	 * @param name Name of server
	 * @return An instabce of the Printer
	 */
	private Initiator initiatorNameLookUp(String host, String name){
		try{
			return (Initiator)Naming.lookup("rmi://" + host + "/" + name);
		}catch(Exception e){System.out.println("Could not connect to Initiator " + name);}
		return null;
	}	
	
	
	/**
	 * Excutes the Responder.
	 * @param args An array of Responder's name, Responder's host
	 */
	public static void main(String args[]){
		if(args.length < 1){	//must at least get server name (host is current dirctory if left empty)							
			System.out.println("Please supply a name for this server");
			return;
		}
		try {
			RMISecurityManager security = new RMISecurityManager();
			System.setSecurityManager(security);
			ResponderImp responder = new ResponderImp(args[0]);
			Naming.bind(args[0], responder); 	//binding the name of this responder
			System.out.println("Responder " + args[0] + " is working...");
		}catch (Exception e) {
			System.out.println("Responder " + args[0] + " is NOT working!!!");
			e.printStackTrace();
			System.exit(1); 	
		}
	}
	  	
	
}

