import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

/**
 * @author Ariel Cohen
 */
public class InitiatorImp extends UnicastRemoteObject implements Initiator{
	private static final long serialVersionUID = 7526472295622776147L;
    private String myName; //name of the initiator
    private String myHost; //host address of the initiator
    
    /**
	 * Constructor for InitiatorImp.
	 * @param myName The Initiator's name
	 * @param myHost The Initiator's host
	 * @exception RemoteException There is no RMI.
	 */    
	public InitiatorImp(String myName, String myHost) throws RemoteException{
		this.myName = myName;
		this.myHost = myHost;
	}

	/**
	 * Prints a message
	 * @param name The name of the sender
	 * @param message The message
	 * @exception RemoteException There is no RMI
	 */
	public void conversation(String name ,String message) throws RemoteException{
		System.out.println(name + " said:");
		System.out.println(message);		
	}

	/**
	 * Initiates a conversation with the Responder
	 * @param responderHost The responder's host
	 * @param responderName The responder's name
	 */
	public void initiateConversation(String responderHost, String responderName){
		Responder responder = responderNameLookUp(responderHost, responderName);
		try{
			responder.initiateConversationWithResponder(myName, myHost, "Hello");
		}catch(RemoteException e){System.out.println("Could not connect to Responder " + responderName);}
	}
	
	/**
	 * Looks for the Responder's address based on its host and name
	 * @param host Host name
	 * @param name Name of server
	 * @return An instabce of the Responder
	 */
	private Responder responderNameLookUp(String host, String name){
		try{
			return (Responder)Naming.lookup("rmi://" + host + "/" + name);
		}catch(Exception e){System.out.println("Could not connect to Responder " + name);}
		return null;
	}	
	
	/**
	 * Excutes the Initiator.
	 * @param args Array of Initiator's name, Responder's name, Initiator's host, Responder's host
	 */
	public static void main(String args[]){
		if(args.length < 2){ //must at least get the names (host is current dirctory if left empty)							
			System.out.println("Please supply a names for the Initiator and Responder");
			return;
		}
		try {
			RMISecurityManager security = new RMISecurityManager();
			System.setSecurityManager(security);
			String responderHost ="";
			if(args.length > 2)	//host of responder 
				responderHost = args[2];
			String myHost ="";			
			if(args.length == 4) //host of initiator
				myHost = args[3];
			InitiatorImp initiator = new InitiatorImp(args[0],myHost);
			Naming.bind(args[0], initiator); //binding the name of this initiator
			initiator.initiateConversation(responderHost,args[1]);
		}catch (Exception e) {
			System.out.println("Initiator " + args[0] + " is NOT working!!!");
			e.printStackTrace();
			System.exit(1); 	
		}
	}
}
	  	