import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ListIterator;
import java.util.Vector;

/*
 * Created on Sep 29, 2005
 */

/**
 * @author A C
 *
 */
public class ResponderImp extends UnicastRemoteObject implements Responder{
	Vector network;
	Vector antsAlreadyAskedAtThisRound;
	Vector antsAlreadyUpdatedAtThisRound;
	private int round;
	Vector goldenPaths;
	private int numberOfAntsKilledSoFar;
	private Vector listOfAntDetails;
	private String finderName;
	
	public ResponderImp() throws RemoteException{
		network = new Vector();
		antsAlreadyAskedAtThisRound = new Vector();
		antsAlreadyUpdatedAtThisRound = new Vector();
		int j;
		for(int i=1; i<=Utilities.NUMBER_OF_ROWS; i++){
			if(i%2 == 0)
				j = 2;
			else
				j = 1;			
			for(; j<=Utilities.NUMBER_OF_COLUMNS; j=j+2){
				//if(i == 29 & (j==9 || j==11)){
				//	continue;
				//}
				Location temp = new Location(i,j);
				network.add(temp);
			}
		}
		removeLocations1();
		goldenPaths = new Vector();
		listOfAntDetails = new Vector();
	}

	private void removeLocations1(){ //removes 37 nodes
		Location tempLocation = null;
		for(ListIterator it = network.listIterator() ; it.hasNext() ; ){  //going over the ants
			tempLocation = (Location)it.next();
			if(tempLocation.getX() == 29) 
				if(tempLocation.getY() == 9){ //beside most left node
					it.remove(); 		    //all together 1 node
					continue;
				}
			if(tempLocation.getX() == 28) 
				if(tempLocation.getY() == 8 || tempLocation.getY() == 10){ //beside most left node
					it.remove(); 		    //all together 2 nodes
					continue;
				}
			if(tempLocation.getX() == 3) //remove row 3
				if(tempLocation.getY() < 18 && tempLocation.getY() > 2){ //beside most left node
					it.remove(); 		    //all together 8 nodes
					continue;
				}
			if(tempLocation.getX() == 27) //remove row 3
				if(tempLocation.getY() < 18 && tempLocation.getY() > 10){ //beside most left node
					it.remove(); 		    //all together 8 nodes
					continue;
				}
			if(tempLocation.getX() == 18) //remove row 3
				if(tempLocation.getY() > 13){ //beside most left node
					it.remove(); 		    //all together 3 nodes
					continue;
				}
			//if(tempLocation.getX() == 21) //remove row 3
			//	if(tempLocation.getY() < 8 && tempLocation.getY() > 2){ //beside most left node
			//		it.remove(); 		    //all together 3 nodes
			//		continue;
			//	}
			if(tempLocation.getY() == 7) //remove column 7
				if(tempLocation.getX() < 28 && tempLocation.getX() > 2){ //beside most left node
					it.remove(); 		    //all together 13 nodes
					continue;
				}
			if(tempLocation.getY() == 11) //remove column 7
				if(tempLocation.getX() < 28 && tempLocation.getX() > 6){ //beside most left node
					it.remove(); 		    //all together 11 nodes
					continue;
				}
			if(tempLocation.getY() == 17) //remove column 7
				if(tempLocation.getX() < 28 && tempLocation.getX() > 20){ //beside most left node
					it.remove(); 		    //all together 4 nodes
					continue;
				}
			if(tempLocation.getY() == 14) //remove column 7
				if(tempLocation.getX() < 25 && tempLocation.getX() > 17){ //beside most left node
					it.remove(); 		    //all together 4 nodes
					continue;
				}
		}		
	}
	
	
	public void activate(String finderName) throws RemoteException{
		this.finderName = finderName;
		antsAlreadyAskedAtThisRound.clear();
		antsAlreadyUpdatedAtThisRound.clear();
		goldenPaths.clear();
		listOfAntDetails.clear();
		round = 1;
		numberOfAntsKilledSoFar = 0;
		for(int i=1; i<=Utilities.NUMBER_OF_ANTS; i++){
			Location tempLocation = new Location(Utilities.START.getX(),Utilities.START.getY());
			AntDetails antDetails = new AntDetails(i,tempLocation);
			listOfAntDetails.add(antDetails);
		}	
		System.out.println("Responder has been activated.");
		System.out.flush();
		System.out.println("Responder: my network:");
		Utilities.print(network);
	}
	
	public void increaseRoundNumber() throws RemoteException{
		synchronized(this){
			antsAlreadyAskedAtThisRound.clear();
			antsAlreadyUpdatedAtThisRound.clear();
			round++;
//			System.out.println("Responder: begining round #" + round);
			System.out.flush();
		}
	}
	
	//synchronized
	public AntResponsePair getNeighborsOfCurrentNode(int antID, Location location) throws RemoteException{
		Vector neighborsOfCurrentNode = new Vector();
		if(location.getX() == 7 && location.getY() == 9){
			synchronized(this){
				if(round > 1 & numberOfAntsKilledSoFar < Utilities.MAX_NUMBER_OF_ANTS_RESPONDER_KILL){
					numberOfAntsKilledSoFar++;
					AntResponsePair antResponsePair = new AntResponsePair(true,neighborsOfCurrentNode);
					//remove ant from list
					AntDetails antDetails = null;
					for(ListIterator it = listOfAntDetails.listIterator() ; it.hasNext() ; ){  //going over the ants
						antDetails = (AntDetails)it.next();
						if(antDetails.getID() == antID)
							it.remove();
					}
					System.out.println("Responder: I killed Ant #" + antID);
					System.out.flush();
					return antResponsePair;
				}
			}
		}
		AntDetails antDetails = null;
synchronized(this){
		for(ListIterator it = listOfAntDetails.listIterator() ; it.hasNext() ; ){  //going over the ants
			antDetails = (AntDetails)it.next();
			if(antDetails.getID() == antID)
				break;
			antDetails = null;
		}
}
		if(antDetails == null){ //ant is not on the list
			System.out.println("Responder: Ant " + antID + " which asked for information is not on my list (maybe was killed before)"); 
			System.out.flush();
			return (new AntResponsePair(false,neighborsOfCurrentNode));			
		}
		int y = location.getY();
		int x = location.getX();
		if(antDetails.getLocation().getX() != x || antDetails.getLocation().getY() != y){ //ant is not in the right place
			//System.out.println("Responder: Ant " + antID + " is currently not in the Location that was last reported by it"); 
			System.out.println("Responder: Ant " + antID + " is currently at location " + antDetails.getLocation().getX() + "," + antDetails.getLocation().getY() + " and asking about location " + x + "," +y); 
			System.out.flush();
			return (new AntResponsePair(false,neighborsOfCurrentNode));			
		}
		Integer antIDInteger = new Integer(antID);
		if(antsAlreadyAskedAtThisRound.contains(antIDInteger)){
			AntResponsePair antResponsePair = new AntResponsePair(false,neighborsOfCurrentNode);
			System.out.println("Responder: Ant " + antID + " already asked information in this round"); 
			return antResponsePair;
		}
		else
			antsAlreadyAskedAtThisRound.add(antIDInteger);
		Location temp = new Location(x+1,y+1);
		if(doesNetworkContain(temp))
			neighborsOfCurrentNode.add(temp);
		temp = new Location(x+1,y-1);
		if(doesNetworkContain(temp))
			neighborsOfCurrentNode.add(temp);
		temp = new Location(x-1,y+1);
		if(doesNetworkContain(temp))
			neighborsOfCurrentNode.add(temp);
		temp = new Location(x-1,y-1);
		if(doesNetworkContain(temp))
			neighborsOfCurrentNode.add(temp);
		AntResponsePair antResponsePair = new AntResponsePair(false,neighborsOfCurrentNode);
		return antResponsePair;
	}
	
	public int updateAntLocation(int antID, Location newLocation) throws RemoteException{
		AntDetails antDetails = null;
synchronized(this){
		for(ListIterator it = listOfAntDetails.listIterator() ; it.hasNext() ; ){  //going over the ants
			antDetails = (AntDetails)it.next();
			if(antDetails.getID() == antID)
				break;
			antDetails = null;
		}
}
		if(antDetails == null){ //ant is not on the list
			System.out.println("Responder: Ant " + antID + " which tried to update its location is not on my list (maybe was killed before)"); 
			System.out.flush();
			return 0;			
		}
		int y = newLocation.getY();
		int x = newLocation.getX();
		int currentY = antDetails.getLocation().getY();
		int currentX = antDetails.getLocation().getX();		
		if(!((currentX == x & currentY == y) | ((currentX == x-1 | currentX == x+1) & (currentY == y-1 | currentY == y+1)))){ //ant is not in the right place
			System.out.println("Responder: Ant " + antID + " is not in the Location previously reported by it"); 
			System.out.flush();
			return 0;			
		}
		Integer antIDInteger = new Integer(antID);
		if(antsAlreadyUpdatedAtThisRound.contains(antIDInteger)){
//			System.out.println("Responder: Ant " + antID + " already updated Location in this round"); 
			return 0;
		}
		synchronized(this){
			antsAlreadyUpdatedAtThisRound.add(antIDInteger);
		}
		antDetails.updateLocation(x,y);
		return 1;
		
	}

	public void addGoldenPath(Vector goldenPath) throws RemoteException{
		goldenPaths.add(goldenPath);
	}
	
	public void resolveGoldenPaths() throws RemoteException{
		int numberOfGoldenPaths = goldenPaths.size();
		if(numberOfGoldenPaths == 2){
			Vector firstGoldenPath =  (Vector)goldenPaths.get(0);
			Vector secondGoldenPath = (Vector)goldenPaths.get(1);
                        System.out.println("Your first path is of size " + firstGoldenPath.size() + ", and it should be 56");
                        System.out.println("Your second path is of size " + secondGoldenPath.size() + ", and it should be 58");
			if(firstGoldenPath.size() == 56 && secondGoldenPath.size() == 58)
				Utilities.printResults(finderName, true, true, true, round, "Good work!!");
			if(firstGoldenPath.size() == 58 && secondGoldenPath.size() == 56)
				Utilities.printResults(finderName, true, true, true, round, "Good work!!");
			if(firstGoldenPath.size() == 56 && secondGoldenPath.size() == 56)
				Utilities.printResults(finderName, true, true, false, round, "You found two paths, but only length d is correct!!");
			if(firstGoldenPath.size() == 58 && secondGoldenPath.size() == 58)
				Utilities.printResults(finderName, false, true, true, round, "You found two paths, but only length d+2 is correct!!");
			if(firstGoldenPath.size() != 58 && secondGoldenPath.size() != 58 &&
			   firstGoldenPath.size() != 56 && secondGoldenPath.size() != 56)
				Utilities.printResults(finderName, false, true, false, round, "You found two paths, but both of wrong length");
		}
		if(numberOfGoldenPaths == 1){
			Vector firstGoldenPath =  (Vector)goldenPaths.get(0);
			if(firstGoldenPath.size() == 56)
				Utilities.printResults(finderName, true, true, false, round, "You found one path - only of length d");
			if(firstGoldenPath.size() == 58)
				Utilities.printResults(finderName, false, true, true, round, "You found one path - only of length d+2");
			if(firstGoldenPath.size() != 58 && firstGoldenPath.size() != 56)
				Utilities.printResults(finderName, false, true, false, round, "You found one path, but of wrong length");
		}
		if(numberOfGoldenPaths == 0){
			Utilities.printResults(finderName, false, false, false, round, "There are 2 paths in my network and you found none");
		}
		System.out.println("Match is over!");
		System.out.flush();
}

	/**
	 * Excutes the Responder.
	 * @param args The Responder's name
	 */
	public static void main(String args[]){
		if(args.length < 1){ //must get a name 						
			System.out.println("Please supply a name for the Responder");
			return;
		}
		try {
			RMISecurityManager security = new RMISecurityManager();
			System.setSecurityManager(security);
			ResponderImp responder = new ResponderImp();
			Naming.rebind(args[0], responder); //binding the name of this responder
			System.out.println("Responder " + args[0] + " is working...");
		}catch (Exception e) {
			System.out.println("Responder " + args[0] + " is NOT working!!!");
			e.printStackTrace();
			System.exit(1); 	
		}
	}

	private boolean doesNetworkContain(Location temp){
		Location location = null;
		for(ListIterator it = network.listIterator() ; it.hasNext() ; ){  //going over the ants
			location = (Location)it.next();
			if(location.getX() == temp.getX())
				if(location.getY() == temp.getY())
					return true;
		}
		return false;
	}
	
	public class AntDetails{
		private Location location;
		private int ID;
		public AntDetails(int ID, Location location){
			this.location = location;
			this.ID = ID;
		}
		
		public void updateLocation(int x, int y){
			location.setX(x);
			location.setY(y);
		}
		
		public Location getLocation(){
			return location;
		}
		
		public int getID(){
			return ID;
		}

	}
	
}
