import java.rmi.*;
import java.util.Vector;

/**
 * The Responder replies to requests about its local 
 * routing network.
 * 
 */
public interface Responder extends Remote{ 
	/**
	 * Activate the Responder - used by the Finder. 
	 * This allows the Responder to initialize itself, 
	 * and should be the first method which is invoked 
	 * by the Finder. 
	 * @param String The name of the Finder.
	 * @throws RemoteException There is no RMI communication
	 */	
	public void activate(String finderName) throws RemoteException;
	
	/**
	 * Increases the round number (The first round is 1). 
	 * Finder should first use it when increasing the
	 * round number from 1 to 2. It should be invoked after 
	 * the Ants had finished requesting information about 
	 * the network, and updated their locations. 
	 * @throws RemoteException There is no RMI communication
	 */	
	public void increaseRoundNumber() throws RemoteException;
	
	/**
	 * Provides a vector of Locations to which the Ant can 
	 * move, or kills the ant.
	 * @param location The current location of ant.
	 * @param antID The ant's ID (a number between 1 to 30).
	 * @return AntResponsePair. when listOfLocations is empty 
	 * that means that the Ant was not allowed to ask this 
	 * question. Otherwise, there should be at least one Location
	 * and not more than four. If killAnt is set to true 
	 * that means that the Responder killed the Ant. 
	 * @throws RemoteException There is no RMI connection
	 */	
	public AntResponsePair getNeighborsOfCurrentNode(int antID, Location location) throws RemoteException;

	/**
	 * Updates the Locations of the Ant in the network.
	 * @param antID The ant's ID (a number between 1 to 30).
	 * @param newLocation The new location of the Ant. 
	 * @return int: 1 - The location of the Ant has been 
	 * updated. 0 - The location of the Ant hasn't been updated.
	 * -1 - The Ant was killed by the Responder. 
	 * 
	 * @throws RemoteException There is no RMI connection
	 */	
	public int updateAntLocation(int antID, Location newLocation) throws RemoteException;
	
	/**
	 * Once the Finder retrieves a golden path it can report it 
	 * to the Responder. Note, that the Responder doesn't 
	 * give a feedback if the path is correct. Actually the 
	 * Responder doesn't even have to check it yet. 
	 * @param goldenPath A Vector of Locations in the golden path. 
	 * 
	 */
	public void addGoldenPath(Vector goldenPath) throws RemoteException;

	/**
	 * Asks the Responder to check if all the paths that have been
	 * previously supplied to it are valid. The Responder displays
	 * the paths on the screen or states "Finder finds nothing".
	 * @throws RemoteException There is no RMI connection
	 */
	public void resolveGoldenPaths() throws RemoteException;
}
