import java.io.*;
import java.util.*;


public class Parser
{
  public static boolean verbose = true;
  public static final int NUM_VARS = 4;
  public static final int NUM_CHARS = 256;

  public static String readFile(String filename)
  {
    FileReader f;
    StringBuffer buffy = new StringBuffer("");
    int ch;
    char c;
    try
    {
      f = new FileReader(filename);

      while ( (ch = f.read()) != -1)
      {
        c = (char) ch;
        buffy.append(c);
      }
      f.close();
    }
    catch (Exception e)
    {
      System.out.print("Couldn't open " + filename + ", try a can-opener.\n");
    }

    return buffy.toString();
  }

  public static String phaseZero(String s)
  {
    int i;
    char c;
    String t = "" + s;
    String html_pat, real_pat;

    t = swap(t, "+", " ");

    for (i = 0; i < NUM_CHARS; i++)
    {
      c = (char) i;
      if (i < 16)
      {
        html_pat = "%0" + Integer.toHexString(i).toUpperCase();
      }
      else
      {
        html_pat = "%" + Integer.toHexString(i).toUpperCase();
      }
      real_pat = "" + c;
      t = swap(t, html_pat, real_pat);
    }
    return t;
  }

  public static String phaseOne(String s)
  {
    StringBuffer buffy = new StringBuffer("");
    int i;
    char c;

    for (i = 0; i < s.length(); i++)
    {
      c = s.charAt(i);
      // if ((c != ' ') && (c != '\t') && (c != '\n')) {
      if (Character.isWhitespace(c) == false)
      {
        buffy.append(c);
      }
    }

    return buffy.toString();
  }

  public static String grabVarsAndCut(String s, Situation q)
  {
    String t;
    String temp;
    char c;
    int sem_count;
    int pos = 0;
    int epo;
    int on = 10, om = 1, ov = 1;
    double of = 1.0;

    for (sem_count = 0; sem_count < NUM_VARS; sem_count++)
    {
      c = Character.toLowerCase(s.charAt(pos));
      pos += 2;
      epo = s.indexOf(';', pos);
      temp = s.substring(pos, epo);

      if (c == 'n')
      {
        on = Integer.parseInt(temp);
      }
      else if (c == 'm')
      {
        om = Integer.parseInt(temp);
      }
      else if (c == 'v')
      {
        ov = Integer.parseInt(temp);
      }
      else
      {
        of = Double.parseDouble(temp);
      }
      pos = epo + 1;
    }

    q.init(on, om, ov, of);

    t = s.substring(pos);
    return t;
  }

  public static String matchYinYang(String s)
  {
    String t = "" + s;
    int loc = 0;
    int ob, op;

    while ( (ob = t.indexOf('[', loc)) >= 0)
    {
      op = t.indexOf(')', ob);
      t = t.substring(0, op) + ']' + t.substring(op + 1);
      loc = op + 1;
    }
    return t;
  }

  public static void clauseByClause(String s, Situation q)
  {
    int loc = 0;
    int tloc;
    int elly;
    String t;
    String temp;
    int index;
    int i;

    /*
      q.p = new Person[q.n + 1];
      for (i = 0; i < q.p.length; i++) {
        q.p[i] = new Person();
      }
     */

    // System.out.print("Size found = "+q.p.length+"\n");

    while ( (tloc = s.indexOf('{', loc)) >= 0)
    {
      temp = s.substring(loc, tloc);
      index = Integer.parseInt(temp);
      elly = perfectClosure(s, loc, '{', '}');
      t = s.substring(loc, elly);
      q.setItUp(index, t);

      loc = elly;
    }
  }

  public static String cutOut(String s, String pattern)
  {
    String t = s + "";
    int a;
    int k = pattern.length();
    while (t.indexOf(pattern) >= 0)
    {
      a = t.indexOf(pattern);
      // System.out.print("a = "+a+", k = "+k+"\n");
      if (a == 0)
      {
        t = t.substring(k);
      }
      else
      {
        t = t.substring(0, a) + t.substring(a + k);
      }
    }
    return t;
  }

  public static String[] split(String s, String pat)
  {
    StringTokenizer st = new StringTokenizer(s, pat);
    String[] col = new String[st.countTokens()];
    int i;
    for (i = 0; i < col.length; i++)
    {
      col[i] = st.nextToken();
    }
    return col;
  }

  public static String swap(String s, String op, String np)
  {
    String t = " " + s + " ";
    int loc = 0;
    int k = op.length();

    while ( (loc = t.indexOf(op)) >= 0)
    {
      t = t.substring(0, loc) + np + t.substring(loc + k);
    }

    return t.trim();
  }

  public static int perfectClosure(String s, int sp, char opener, char closer)
  {
    boolean began = false;
    int level = 0;
    int n = s.length();
    int i;
    int loc = sp + 1;

    // When break out of loop when either i >= n or when we began && level <= 0
    for (i = sp; ! ( (i >= n) || ( (began) && (level <= 0))); i++)
    {
      if (s.charAt(i) == opener)
      {
        level++;
        began = true;
        loc = i + 1;
      }
      else if (s.charAt(i) == closer)
      {
        level--;
        began = true;
        loc = i + 1;
      }
    }
    return loc;
  }

  public static int countInstances(String s, char item)
  {
    int count = 0;
    int i;
    int n = s.length();
    char c;

    for (i = 0; i < n; i++)
    {
      c = s.charAt(i);
      if (c == item)
      {
        count++;
      }
    }
    return count;
  }

  public static void parse(String s, Situation q)
  {
    int a, b;

    // Eat comments!!!!
    while (s.indexOf("/*") >= 0)
    {
      a = s.indexOf("/*");
      b = s.indexOf("*/");
      if (a == 0)
      {
        s = s.substring(b + 2);
      }
      else
      {
        s = s.substring(0, a) + s.substring(b + 2);
      }
    }

    System.out.print(s + "\n\n");

    s = grabVarsAndCut(s, q);
    System.out.print(s + "\n\n");

    s = cutOut(s, ";");
    s = cutOut(s, ":");
    s = cutOut(s, "send");
    s = swap(s, "start", "s");
    s = swap(s, "on_events", "o");
    s = swap(s, "msg_from(", "(m,");
    s = swap(s, "msg_of(", "(m,");
    s = swap(s, "ack_from(", "(a,");
    s = swap(s, "ack_of(", "(a,");
    // s = swap(s, "msg", "m");
    s = swap(s, "msg_with(", "[m,");
    // s = swap(s, "ack", "a");
    s = swap(s, "ack_with(", "[a,");

    s = matchYinYang(s);
    System.out.print(s + "\n\n");

    s = swap(s, "]&&[", "&&");
    System.out.print(s + "\n\n");

    clauseByClause(s, q);

    System.out.print(q.toString() + "\n");
  }

  public static String lookForFile(String filename)
  {
    String z = readFile(filename);
    String s0 = phaseZero(z);
    return s0;
  }

  public static void main(String args[])
  {
    int i;
    int option = 0;
    long seed = 0;
    String filename = "test.txt";
    Letter letters[];

    for (i = 0; i < args.length; i++)
    {
      if (args[i].equals("-f"))
      {
        option = 0;
      }
      else if (args[i].equals("-t"))
      {
        option = 1;
      }
      else if (args[i].equals("-s"))
      {
        option = 2;
        seed = Long.parseLong(args[i + 1]);
        i++;
      }
      else
      {
        filename = args[i];
      }
    }

    Situation q = new Situation(1.0);
    String z = readFile(filename);
    String s0 = phaseZero(z);
    System.out.print(s0 + "\n");
    String s1 = phaseOne(s0);
    parse(s1, q);

    letters = Letter.makeLetterList(q.persons, q.numberPeople);
    System.out.print(Letter.showTree(letters) + "\n");

    q.sortLetters(letters);
    System.out.print(q.showLetterInfo());

    if (option == 1)
    {
      q.burglar.goToWork(q, 1);
      q.rigTheMail();
    }

    /*
      System.out.println(letters[1].isAncestorOf(letters[15]));
      System.out.println(letters[9].isAncestorOf(letters[15]));
      System.out.println(letters[15].isAncestorOf(letters[1]));
      System.out.println(letters[11].isAncestorOf(letters[15]));
     */

    //for(int k = 0; k < 5; k++)
    q.actOut(option, seed);
  }
}