/*
 * Decompiled with CFR 0.152.
 */
package optimalMove;

import optimalMove.Constants;
import optimalMove.WeightBounds;
import optimalMove.weightPlacement;

public class Torques {
    protected int LeftTorque;
    protected int RightTorque;

    public Torques(Torques other) {
        this(other.LeftTorque, other.RightTorque);
    }

    public Torques(int lt, int rt) {
        this.LeftTorque = lt;
        this.RightTorque = rt;
    }

    public boolean equals(Object other) {
        Torques t = (Torques)other;
        return t.LeftTorque == this.LeftTorque && t.RightTorque == this.RightTorque;
    }

    public int hashCode() {
        return this.LeftTorque ^ this.RightTorque;
    }

    public WeightBounds wb_lookup() {
        WeightBounds wb = this.weight_bounds();
        return wb;
    }

    public WeightBounds addition_wb_lookup() {
        WeightBounds wb = this.addition_weight_bounds();
        return wb;
    }

    public void update_torque(weightPlacement newWeight) {
        this.LeftTorque += newWeight.weight * (-3 - newWeight.location);
        this.RightTorque += newWeight.weight * (newWeight.location - -1);
    }

    public WeightBounds weight_bounds() {
        WeightBounds wb = new WeightBounds();
        Integer wpos = -15;
        while (wpos <= -3) {
            wb.for_position.put(wpos, Math.abs(this.RightTorque) / (-1 - wpos));
            wpos = wpos + 1;
        }
        wpos = -2;
        while (wpos < -1) {
            wb.for_position.put(wpos, Math.min(Math.abs(this.RightTorque) / (-1 - wpos), Math.abs(this.LeftTorque) / (wpos - -3)));
            wpos = wpos + 1;
        }
        wpos = -1;
        while (wpos < 16) {
            wb.for_position.put(wpos, Math.abs(this.LeftTorque) / (wpos - -3));
            wpos = wpos + 1;
        }
        return wb;
    }

    public WeightBounds addition_weight_bounds() {
        WeightBounds wb = new WeightBounds();
        Integer wpos = -15;
        while (wpos < -3) {
            wb.for_position.put(wpos, Math.abs(this.LeftTorque) / (-3 - wpos));
            wpos = wpos + 1;
        }
        wpos = -3;
        while (wpos <= -1) {
            wb.for_position.put(wpos, Constants.MAXINT);
            wpos = wpos + 1;
        }
        wpos = 0;
        while (wpos < 16) {
            wb.for_position.put(wpos, Math.abs(this.RightTorque) / (wpos - -1));
            wpos = wpos + 1;
        }
        return wb;
    }

    public void display() {
        System.out.print("Left Torque: ");
        System.out.print(this.LeftTorque);
        System.out.print(", Right Torque: ");
        System.out.println(this.RightTorque);
    }
}

