/*
 * Decompiled with CFR 0.152.
 */
package optimalMove;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import optimalMove.AddPhaseState;
import optimalMove.Client;
import optimalMove.Constants;
import optimalMove.GameGraphLevel;
import optimalMove.GameGraphSingleLevel;
import optimalMove.NumChildrenComparator;
import optimalMove.Ply;
import optimalMove.PlyEdge;
import optimalMove.rPhaseState;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;

public class LeveledGameGraph {
    protected DirectedGraph<rPhaseState, PlyEdge> GameGraph;
    protected GameGraphLevel Level_vectors;
    protected int depth;
    protected Map<rPhaseState, Integer> value_map = new HashMap<rPhaseState, Integer>();
    private static long startTime = System.currentTimeMillis();

    public LeveledGameGraph(rPhaseState root_state) {
        this.GameGraph = new SimpleDirectedGraph<rPhaseState, PlyEdge>(PlyEdge.class);
        this.GameGraph.addVertex(root_state);
        GameGraphSingleLevel root_level = new GameGraphSingleLevel();
        boolean success = root_level.conditional_add(root_state);
        System.out.print(success);
        this.Level_vectors = new GameGraphLevel();
        this.Level_vectors.below_root.put(0, root_level);
        this.depth = 0;
        this.value_map = new HashMap<rPhaseState, Integer>();
        this.value_map.put(root_state, 0);
    }

    protected void Expand_Eval(rPhaseState parent_state, int level) {
        if (this.value_map.get(parent_state) == Constants.MAXINT || this.value_map.get(parent_state) == Constants.MININT) {
            return;
        }
        if (parent_state.num_nontipping_children() == 0) {
            if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
                this.value_map.put(parent_state, Constants.MININT);
            } else if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
                this.value_map.put(parent_state, Constants.MAXINT);
            }
        } else {
            int parent_value;
            int child_value;
            if (level == this.depth) {
                this.Level_vectors.initialize_next_level();
                ++this.depth;
            }
            ArrayList<rPhaseState> children_list = parent_state.non_tipping_children();
            Collections.sort(children_list, new NumChildrenComparator());
            for (rPhaseState child : children_list) {
                boolean add_success = this.Level_vectors.conditional_add(level + 1, child);
                if (add_success) {
                    this.GameGraph.addVertex(child);
                    this.value_map.put(child, 0);
                    this.GameGraph.addEdge(parent_state, child, new PlyEdge(parent_state.next_ply));
                    continue;
                }
                if (add_success) continue;
                child_value = this.value_map.get(child);
                parent_value = this.value_map.get(parent_state);
                this.GameGraph.addEdge(parent_state, child, new PlyEdge(parent_state.next_ply));
                if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine) && child_value > parent_value) {
                    this.value_map.put(parent_state, child_value);
                    return;
                }
                if (!parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents) || child_value >= parent_value) continue;
                this.value_map.put(parent_state, child_value);
                return;
            }
            if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
                this.value_map.put(parent_state, Constants.MININT);
            } else if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
                this.value_map.put(parent_state, Constants.MAXINT);
            }
            for (rPhaseState child : children_list) {
                this.Expand_Eval(child, level + 1);
                child_value = this.value_map.get(child);
                parent_value = this.value_map.get(parent_state);
                if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine) && child_value > parent_value) {
                    this.value_map.put(parent_state, child_value);
                    return;
                }
                if (!parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents) || child_value >= parent_value) continue;
                this.value_map.put(parent_state, child_value);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected rPhaseState Expand_Eval_Verbose(rPhaseState parent_state, int level) {
        void var3_17;
        void var3_6;
        if (parent_state instanceof AddPhaseState && !parent_state.available_weights.isEmpty()) {
            AddPhaseState addPhaseState = new AddPhaseState((AddPhaseState)parent_state);
        } else if (parent_state instanceof AddPhaseState && parent_state.available_weights.isEmpty()) {
            parent_state.weight_bounds = parent_state.torques.wb_lookup();
            rPhaseState rPhaseState2 = new rPhaseState(parent_state);
        } else {
            rPhaseState rPhaseState3 = new rPhaseState(parent_state);
        }
        if (this.value_map.get(parent_state) == Constants.MAXINT || this.value_map.get(parent_state) == Constants.MININT || (System.currentTimeMillis() - startTime) / 1000L > (long)Client.MAXSECONDS) {
            return var3_6;
        }
        if (var3_6 instanceof AddPhaseState && ((AddPhaseState)parent_state).num_nontipping_addition_children() == 0 || !(var3_6 instanceof AddPhaseState) && parent_state.num_nontipping_children() == 0) {
            if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
                this.value_map.put(parent_state, Constants.MININT);
                return var3_6;
            }
            if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
                this.value_map.put(parent_state, Constants.MAXINT);
                return var3_6;
            }
        } else {
            if (level == this.depth) {
                this.Level_vectors.initialize_next_level();
                ++this.depth;
            }
            if (var3_6 instanceof AddPhaseState) {
                int parent_value;
                int child_value;
                ArrayList<AddPhaseState> children_list = null;
                children_list = ((AddPhaseState)parent_state).non_tipping_addition_children();
                rPhaseState rPhaseState4 = children_list.get(0);
                for (rPhaseState rPhaseState5 : children_list) {
                    boolean add_success = this.Level_vectors.conditional_add(level + 1, rPhaseState5);
                    if (add_success) {
                        this.GameGraph.addVertex(rPhaseState5);
                        this.value_map.put(rPhaseState5, 0);
                        this.GameGraph.addEdge(parent_state, rPhaseState5, new PlyEdge(parent_state.next_ply));
                        continue;
                    }
                    if (add_success) continue;
                    child_value = this.value_map.get(rPhaseState5);
                    parent_value = this.value_map.get(parent_state);
                    this.GameGraph.addEdge(parent_state, rPhaseState5, new PlyEdge(parent_state.next_ply));
                    if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine) && child_value > parent_value) {
                        this.value_map.put(parent_state, child_value);
                        return rPhaseState5;
                    }
                    if (!parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents) || child_value >= parent_value) continue;
                    this.value_map.put(parent_state, child_value);
                    return rPhaseState5;
                }
                if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
                    this.value_map.put(parent_state, Constants.MININT);
                } else if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
                    this.value_map.put(parent_state, Constants.MAXINT);
                }
                for (rPhaseState rPhaseState6 : children_list) {
                    this.Expand_Eval_Verbose(rPhaseState6, level + 1);
                    child_value = this.value_map.get(rPhaseState6);
                    parent_value = this.value_map.get(parent_state);
                    if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine) && child_value > parent_value) {
                        this.value_map.put(parent_state, child_value);
                        return rPhaseState6;
                    }
                    if (!parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents) || child_value >= parent_value) continue;
                    this.value_map.put(parent_state, child_value);
                    return rPhaseState6;
                }
            } else {
                int parent_value;
                int child_value;
                ArrayList<rPhaseState> children_list = null;
                children_list = parent_state.non_tipping_children();
                Collections.sort(children_list, new NumChildrenComparator());
                rPhaseState rPhaseState7 = children_list.get(0);
                for (rPhaseState rPhaseState8 : children_list) {
                    boolean add_success = this.Level_vectors.conditional_add(level + 1, rPhaseState8);
                    if (add_success) {
                        this.GameGraph.addVertex(rPhaseState8);
                        this.value_map.put(rPhaseState8, 0);
                        this.GameGraph.addEdge(parent_state, rPhaseState8, new PlyEdge(parent_state.next_ply));
                        continue;
                    }
                    if (add_success) continue;
                    child_value = this.value_map.get(rPhaseState8);
                    parent_value = this.value_map.get(parent_state);
                    this.GameGraph.addEdge(parent_state, rPhaseState8, new PlyEdge(parent_state.next_ply));
                    if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine) && child_value > parent_value) {
                        this.value_map.put(parent_state, child_value);
                        return rPhaseState8;
                    }
                    if (!parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents) || child_value >= parent_value) continue;
                    this.value_map.put(parent_state, child_value);
                    return rPhaseState8;
                }
                if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
                    this.value_map.put(parent_state, Constants.MININT);
                } else if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
                    this.value_map.put(parent_state, Constants.MAXINT);
                }
                for (rPhaseState rPhaseState9 : children_list) {
                    this.Expand_Eval_Verbose(rPhaseState9, level + 1);
                    child_value = this.value_map.get(rPhaseState9);
                    parent_value = this.value_map.get(parent_state);
                    if (parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Mine) && child_value > parent_value) {
                        this.value_map.put(parent_state, child_value);
                        return rPhaseState9;
                    }
                    if (!parent_state.next_ply.Whose.equals((Object)Ply.Ownership.Opponents) || child_value >= parent_value) continue;
                    this.value_map.put(parent_state, child_value);
                    return rPhaseState9;
                }
            }
        }
        return var3_17;
    }

    protected rPhaseState timed_Expand_Eval_Verbose(rPhaseState parent_state, int level) {
        startTime = System.currentTimeMillis();
        return this.Expand_Eval_Verbose(parent_state, level);
    }
}

