//graph_reader.h
#pragma once

#include "GraphGrepSXLibrary.h"

using namespace std; 
using namespace GraphGrepSXLibrary;

// concetto GraphReader
template <typename MutableGraph>
class GraphReader
{
public:
	void ReadNextGraph(){};
	const MutableGraph& GetGraph(){};
	void ReleaseGraph(){};
};


template <typename MutableGraph>
class GraphReaderMemory : public GraphReader<MutableGraph>
{
public:
	GraphReaderMemory(const vector<MutableGraph>& graphdb) : m_graphdb(graphdb),m_index(0) {}
	void Rewind() {m_index = 0;}
public:
	void ReadNextGraph(){};
	const MutableGraph& GetGraph(){};
	void ReleaseGraph(){};
private:
	const vector<MutableGraph>& m_graphdb;
	int m_index;
};

	
template <typename MutableGraph>
class GraphReaderStream : public GraphReader<MutableGraph>
{
public:
	GraphReaderStream(std::istream& in) : m_istream(in) {}
	void Rewind() {m_istream.seekg(0);}
public:
	bool ReadNextGraph() {return read_graph_gg(m_istream,m_graph);}
	const MutableGraph& GetGraph(){return m_graph;};
	void ReleaseGraph(){ m_graph.clear();};
private:
	std::istream& m_istream;
	MutableGraph m_graph;
};

class db_cache:public std::map<graph_index_t, vector<string> >
{
public:
	db_cache(){};
public:
	bool load_db(const string &db_file);
	bool select(const graph_set_t &set, const string &ts_file);
};

bool db_cache::load_db(const string &db_file)
{
	ifstream db_stream;
	db_stream.open(db_file.c_str(), ios_base::in);
	if (!db_stream.is_open())
	{
		//cout << "Impossibile salvare il file database: '" << db_file.c_str() << "'" << endl;
		return false;
	}
	
	graph_index_t index = -1;
	bool filter=false;

	vector<string> lines;

	while (!db_stream.eof())
	{
		string line;
		getline(db_stream, line);
		
		string::size_type loc = line.find("#", 0 );   
		if(loc!=string::npos)
		{
			if(filter==true)
			{
				//add to map
				insert(pair<graph_index_t, vector<string> >(index, lines));
				filter = false;
			}
			
			lines.clear();
			filter = true;
			index++;
		}
		else
		{
			lines.push_back(line);
		}
		
	}

	insert(pair<graph_index_t, vector<string> >(index, lines));

	db_stream.close();
 	return true;
}

bool db_cache::select(const graph_set_t &set, const string &ts_file)
{
	ofstream ts_stream;
	ts_stream.open(ts_file.c_str(), ios_base::out);
	if (!ts_stream.is_open())
	{
		//cout << "Impossibile salvare il file db per vento: '" << ts_file.c_str() << "'" << endl;
		return false;
	}

	db_cache::iterator db_it; 
	graph_set_t::const_iterator it = set.begin();
	while(it!=set.end())
	{
		 db_it = find(*it);

		 if(db_it!=end())
		 {
			 vector<string>& lines = db_it->second;
			 ts_stream<<'#'<<*it<<endl;
			 for(vector<string>::iterator line_it = lines.begin(); line_it!=lines.end(); line_it++)
				ts_stream<<*line_it<<endl;
		 }

		 it++;
	}

	ts_stream.close();

	return true;
}
