//graph_path_finder.h
#pragma once

#include "GraphGrepSXLibrary.h"
#include "all_path_visitor.h"

using namespace std; 
using namespace GraphGrepSXLibrary;


namespace GraphGrepSXLibrary {

// graph_path_finder
template <class V>
class graph_path_finder
{
public:
	graph_path_finder(const graph_t &g, V* visitor)
	{
		graph = g;		
		vis = visitor;
	}
public:
	void run(const vertex_t &u);
private:
	graph_t graph;
	my_stack stack;
	std::map<vertex_t,bool> visited;		
	V* vis;
};

template <class V> void 
graph_path_finder<V>::run(const vertex_t &u) 
{
		int depth = 1;
		vertex_t current = u;
		bool flag = true;
		bool found_next = false;

		stack.clear();
		stack_item_t* item;
		out_edge_it ei, ei_end;

		char label = get(vertex_color, graph, current);

		vis->start_vertex(current, graph);

		do
		{
			if(flag)
			{
				item = new stack_item_t();

				item->first = current; 
				tie(ei, ei_end) = out_edges(current, graph);
				item->second = ei;
				
				stack.push_back(item);
				flag = true;
			}
			else
				tie(ei, ei_end) = out_edges(current, graph);
				
			visited[item->first]= true;
			found_next = false;

			while(!found_next && !stack.empty())
			{
				while(item->second!=ei_end && depth < max_depth)
				{
					vertex_t neighbor = target(*item->second, graph);
					++item->second;	

					if(!visited[neighbor])
					{
						current = neighbor;
						found_next = true;
						flag = true;

						vis->discover_vertex(current, graph);
						depth++;
					
						break;
					}					
				}						
						
				if(!found_next)
				{
					vis->finish_vertex(current, graph);

					stack.pop_back();
					visited[item->first]=false;
					delete item;

					depth--;

					if(!stack.empty())
					{
						found_next = true;
						item = stack.back();
						current = item->first;						
						flag = false;
					}
				}
			}
		}
		while(!stack.empty());
}

template <typename Graph, class Visitor, class Vertex> inline void 
all_path_DFS(const Graph &graph, Visitor &vis, const Vertex &v)
{
	graph_path_finder<Visitor> gpf(graph, &vis);
	gpf.run(v);
}

template <typename Graph> void
find_all_path(const Graph &g, const graph_index_t &index, OCP_Tree* index_tree)
{
	vertex_it i, i_end;
	vertex_t v;
	for(boost::tie(i,i_end) = vertices(g); i != i_end; ++i) 
	{
		v = *i;
		path_finder(g, index, v, index_tree);
	}
}

template < typename Graph, class Vertex> void
path_finder(const Graph &g, const graph_index_t &index, const Vertex & start, OCP_Tree* index_tree)
{
	all_path_visitor my_vis(index, index_tree);
		
	all_path_DFS(g, my_vis, start);
}

template <typename Graph> void
find_one_path(const Graph &g, const graph_index_t &index, OCP_Tree* index_tree)
{
	vertex_it i, i_end;
	for(boost::tie(i,i_end) = vertices(g); i != i_end; ++i) 
	{
		vertex_t v;
		v = *i;
		path_query_finder(g, index, v, index_tree);
	}
}

template < typename Graph, class Vertex> void
path_query_finder(const Graph &g, const graph_index_t &index, const Vertex & start, OCP_Tree* index_tree)
{
	one_path_visitor my_vis(index, index_tree);
		
	all_path_DFS(g, my_vis, start);
}

}//end name_space
