#pragma once

#include <iostream>
#include <map>
#include "GraphGrepSXLibrary.h"
#include <queue>

using namespace GraphGrepSXLibrary;

/**************/
/**#-HEADER-#**/
class Graphs_Occurrences:public std::map<graph_index_t, int>
{
public:
	Graphs_Occurrences(void){};
	template<class Archive>
	void save(Archive &os);
	template<class Archive>
	void load(Archive &is);
};
class OCP_Tree_Node
{
public:
	char label;
	OCP_Tree_Node* parent;
	OCP_Tree_Node* first_child;
	OCP_Tree_Node* last_child;
	OCP_Tree_Node* next;
	int child_count;//si potrebbe eliminare per risparmiare memoria, visto che serve solo per la lettura e la scrittura su file
	bool is_special;
	bool have_special_parent;
	std::map<char, OCP_Tree_Node*> child_map;
	Graphs_Occurrences occurrences;

	OCP_Tree_Node(char _label, OCP_Tree_Node* _parent);

	OCP_Tree_Node* add_child(char _label, int _occurrence_index);
	OCP_Tree_Node* get_child_by_label(char _label);

	void save(std::ofstream &os);
	void load(std::ifstream &is);
};

class OCP_Tree
{
public:
	OCP_Tree_Node* root;
	int total_graph_count;

	OCP_Tree(void);
	~OCP_Tree(void);

	void clear_single_firstlevel_node(void);
	void match(OCP_Tree* q_index_tree,  graph_set_t &set);

	void save(std::ofstream &os);
	void load(std::ifstream &is);

	//long get_memory_size(void);
	//long get_disk_size(void);

	void print(void);

	void set_child_map(void);
	void refind_special(void);
	void special_count(void);
};

class OCP_Queue_Node
{
public:
	OCP_Tree_Node* f_node;
	OCP_Tree_Node* s_node;
	OCP_Queue_Node* next;
	OCP_Queue_Node(){};
	OCP_Queue_Node(OCP_Tree_Node* _f_node, OCP_Tree_Node* _s_node){
		this->f_node=_f_node;
		this->s_node=_s_node;
		this->next=NULL;
	};
};
/**************/
/**#-SOURCE-#**/
template<class Archive>
void Graphs_Occurrences::save(Archive &os)
{
	std::map<int, int>::iterator it;
	
	int f_size = size();
	os.write((char*)&f_size,sizeof(int));
	for(it= begin(); it!=end(); it++)
	{
		graph_index_t gi = it->first;
		os.write((char*)&gi,sizeof(graph_index_t));
		int go=it->second;
		os.write((char*)&go,sizeof(int));			
	}
};
template<class Archive>
void  Graphs_Occurrences::load(Archive &is)
{
	int fo_size;
	is.read((char*)&fo_size,sizeof(int));

	for(int j=0; j<fo_size; j++)
	{
		graph_index_t gi;
		is.read((char*)&gi,sizeof(graph_index_t));	//feature's graph_index
		int go;		//graph's features occurrences
		is.read((char*)&go,sizeof(int));
		insert(pair<graph_index_t, int>(gi, go));
	}
};

OCP_Tree_Node::OCP_Tree_Node(char _label, OCP_Tree_Node* _parent)
{
	this->label=_label;
	this->parent=_parent;
	this->next=NULL;
	this->first_child=NULL;
	this->last_child=NULL;
	this->child_count=0;
	this->is_special=false;
	this->have_special_parent=false;
};

OCP_Tree_Node* OCP_Tree_Node::add_child(char _label, int _occurrence_index){
	if(this->first_child){
		if((this->first_child)->label > _label){
			OCP_Tree_Node* n=this->first_child;
			this->first_child=new OCP_Tree_Node(_label, this);
			(this->first_child)->next=n;
			(this->child_count)++;
			return this->first_child;
		}
		else if((this->first_child)->label == _label){
			return this->first_child;
		}

		else if((this->last_child)->label < _label){
			(this->last_child)->next=new OCP_Tree_Node(_label, this);
			this->last_child=(this->last_child)->next;
			(this->child_count)++;
			return this->last_child;
		}
		else if((this->last_child)->label == _label){
			return this->last_child;
		}

		else{
			OCP_Tree_Node* c=this->first_child;
			while(c->next!=NULL && (c->next)->label<=_label)
				c=c->next;

			if(c->label == _label){
				return c;
			}
			else{
				OCP_Tree_Node* n=c->next;
				c->next=new OCP_Tree_Node(_label, this);;
				(c->next)->next=n;
				if(c->next->next==NULL)
					this->last_child=c->next;
				(this->child_count)++;
				return c->next;
			}
		}
	}
	else{
		this->first_child=new OCP_Tree_Node(_label, this);;
		this->last_child=this->first_child;
		(this->child_count)++;
		return this->first_child;
	}
};
OCP_Tree_Node* OCP_Tree_Node::get_child_by_label(char _label){
	OCP_Tree_Node* n=NULL;
	if(this->first_child!=NULL){
		if(_label==this->first_child->label)
			n=this->first_child;
		else if(_label==this->last_child->label)
			n=this->last_child;
		else if((_label>this->first_child->label)&&(_label<this->last_child->label)){
			OCP_Tree_Node* c=this->first_child->next;
			while(c!=NULL){
				if(_label==c->label){
					n=c;
					c=NULL;
				}
				else c=c->next;
			}
		}
	}
	return n;
};


void OCP_Tree_Node::save(std::ofstream &os)
{
	os.write((char*)&(this->label),sizeof(char));
	os.write((char*)&(this->child_count),sizeof(int));
	occurrences.save(os);
};
void  OCP_Tree_Node::load(std::ifstream &is)
{
	is.read((char*)&(this->label),sizeof(char));
	is.read((char*)&(this->child_count),sizeof(int));
	occurrences.load(is);
};



OCP_Tree::OCP_Tree(void)
{
	this->root=new OCP_Tree_Node(NULL, NULL);
	this->total_graph_count=0;
};

void OCP_Tree::refind_special(void){
	std::queue<OCP_Tree_Node*> que;
	que.push(this->root);
	OCP_Tree_Node* n, *c, *p;
	int co=0;
	while(!que.empty()){
		n=que.front(); que.pop();
			
		if(n->is_special && n->have_special_parent){		
			co=n->occurrences[0];
			p=n->parent;
			while(p!=NULL){
				if(p->is_special && p->occurrences[0]>=co){
					p->is_special=false;
					p->have_special_parent=false;
				}
				if(p->have_special_parent)
					p=p->parent;
				else
					p=NULL;
			}
		}
		c=n->first_child;
		while(c!=NULL){
			c->have_special_parent= n->is_special || n->have_special_parent ;
			que.push(c);
			c=c->next;
		}
	}
};
void OCP_Tree::print(void)
{
	std::queue<OCP_Tree_Node*>* que;
	std::queue<OCP_Tree_Node*> que1;
	std::queue<OCP_Tree_Node*> que2;
	
	que1.push(this->root);
	que=&que1;
	
	OCP_Tree_Node* n;
	OCP_Tree_Node* c;
	
	while(!que->empty()){
		n=que->front();
		que->pop();
		if(n->parent!=NULL)
			std::cout<< n->parent->label <<"["<<n->label<<"]["<<n->child_count<<"]"<< ":";
		else
			std::cout<< "NULL["<<n->label<<"]["<<n->child_count<<"]"<< ":";
		std::cout<< (n->occurrences)[43]<<",";
		
		c=n->first_child;
		while(c!=NULL){
			if(que==&que1)	que2.push(c);
			else	que1.push(c);
			c=c->next;
		}
		if(n->first_child!=NULL)
			if(que==&que1)	que2.push(new OCP_Tree_Node('\t',NULL));
			else	que1.push(new OCP_Tree_Node('\t',NULL));

		if(que->empty()){
			if(que==&que1)	que=&que2;
			else	que=&que1;
			std::cout << "\n";
		}
	}
};

void OCP_Tree::clear_single_firstlevel_node(void){
	OCP_Tree_Node* n=this->root->first_child;
	OCP_Tree_Node* p=NULL;
	while(n!=NULL){
		if(n->first_child==NULL){
			if(n==this->root->first_child)
					root->first_child=n->next;
			if(n==this->root->last_child)
					root->last_child=p;
			if(p!=NULL)
				p->next=n->next;
		}
		else p=n;
		n=n->next;
	}
};

void OCP_Tree::match(OCP_Tree* q_index_tree,  graph_set_t &set){
	//se due nodi stanno alla stessa posizione delle due code
	//vuol dire che sono mecciati

	OCP_Tree_Node* nt;
	OCP_Tree_Node* nq;
	OCP_Tree_Node* ct;
	OCP_Tree_Node* cq;

	int q_occ_count;
	graph_set_t::iterator set_it;
	std::map<int,int>::iterator occ_it;
	std::map<int,int>::iterator end_occ_it;
	OCP_Queue_Node* current_qn;
	OCP_Queue_Node* tail_qn;

	current_qn=new OCP_Queue_Node(this->root, q_index_tree->root);
	tail_qn=current_qn;

	bool first_path=true;

	while(current_qn!=NULL && first_path){
		nt=current_qn->f_node;
		nq=current_qn->s_node;

		if(nq->is_special){
			first_path=false;
			q_occ_count=(nq->occurrences)[0];
			for(occ_it=nt->occurrences.begin(); occ_it!=nt->occurrences.end(); occ_it++){
				if(occ_it->second>=q_occ_count){
					set.insert(occ_it->first);
				}
			}		
		}
		cq=nq->first_child;
		while(cq!=NULL){
			ct=nt->child_map[cq->label];
			if(ct!=NULL){
				tail_qn->next=new OCP_Queue_Node(ct, cq);
				tail_qn=tail_qn->next;
			}
			cq=cq->next;
		}
		current_qn=current_qn->next;	
	}
	
	while(current_qn!=NULL){
		nt=current_qn->f_node;
		nq=current_qn->s_node;
		
		if(nq->is_special){
			q_occ_count=(nq->occurrences)[0];
			end_occ_it=nt->occurrences.end();
			for(set_it=set.begin(); set_it!=set.end();){
				occ_it=nt->occurrences.find(*set_it);
				if(occ_it==end_occ_it || occ_it->second<q_occ_count){
					set.erase(set_it++);
				}
				else
					 set_it++;
			}
		}
		cq=nq->first_child;
		while(cq!=NULL){
			ct=nt->child_map[cq->label];
			if(ct!=NULL)
			{
				tail_qn->next=new OCP_Queue_Node(ct, cq);
				tail_qn=tail_qn->next;
			}
			cq=cq->next;
		}	
		current_qn=current_qn->next;
	}
};
void OCP_Tree::save(std::ofstream &os)
{
	os.write((char*)&(this->total_graph_count),sizeof(int));

	std::queue<OCP_Tree_Node*> que;
	que.push(this->root);
	
	OCP_Tree_Node* n;
	OCP_Tree_Node* c;
	
	while(!que.empty()){
		n=que.front();
		que.pop();
		n->save(os);
		
		c=n->first_child;
		while(c!=NULL){
			que.push(c);
			c=c->next;
		}
	}
};
void  OCP_Tree::load(std::ifstream &is)
{
	is.read((char*)&(this->total_graph_count),sizeof(int));

	std::queue<OCP_Tree_Node*>* que;
	std::queue<OCP_Tree_Node*> que1;
	std::queue<OCP_Tree_Node*> que2;
	
	que=&que1;
	
	OCP_Tree_Node* n;
	OCP_Tree_Node* c;
	OCP_Tree_Node* p;
	
	this->root=new OCP_Tree_Node(NULL,NULL);
	(this->root)->load(is);
	que->push(this->root);

	while(!que->empty()){
		n=que->front();
		que->pop();
		p=NULL;
		for(int i=0;i<n->child_count; i++){
			c=new OCP_Tree_Node(NULL,n);
			c->load(is);

			if(i==0)
				n->first_child=c;
			if(i==(n->child_count -1))
				n->last_child=c;
			if(p!=NULL)
				p->next=c;
			p=c;

			if(que==&que1)	que2.push(c);
			else	que1.push(c);
		}
		if(que->empty()){
			if(que==&que1)	que=&que2;
			else	que=&que1;
		}
	}
};

/*long OCP_Tree::get_memory_size(void){
	long size=sizeof(OCP_Tree);//numero totale di grafi rappresentati nell'albero

	std::queue<OCP_Tree_Node*> que;
	que.push(this->root);
	OCP_Tree_Node* n,*c;

	while(!que.empty()){
		n=que.front(); que.pop();
		
		size+=sizeof(OCP_Tree_Node);
		size+=(n->occurrences.size())*(sizeof(graph_index_t)+sizeof(int));

		c=n->first_child;
		while(c!=NULL){
			que.push(c);
			c=c->next;
		}
	}

	return size;

	return 0;
}



long OCP_Tree::get_disk_size(void){
	long size=0;

	size+=sizeof(int);


	std::queue<OCP_Tree_Node*> que;
	que.push(this->root);
	
	OCP_Tree_Node* n;
	OCP_Tree_Node* c;
	
	while(!que.empty()){
		n=que.front();que.pop();
		size+=sizeof(char);
		size+=sizeof(int);
		size+=(sizeof(graph_index_t) + sizeof(int)) * n->occurrences.size();

		
		c=n->first_child;
		while(c!=NULL){
			que.push(c);
			c=c->next;
		}
	}
	return size;
};
*/

void OCP_Tree::set_child_map(void){
	std::queue<OCP_Tree_Node*> que;
	que.push(this->root);
	OCP_Tree_Node* n, *c;
	while(!que.empty()){
		n=que.front(); que.pop();
		c=n->first_child;
		while(c!=NULL){
			n->child_map[c->label]=c;
			que.push(c);
			c=c->next;
		}
	}
};
