#include "graph.h"

////////////////////////////////////////////
//
// Class: vDFS_GraphGrep
// Usage: GraphGrep main class. Doing DFS traversal and output an opfile contained the found intersected patterns
//
/////////////////////////////////////////////
template <class GraphADT> class vDFS_GraphGrep
{
	GraphADT &G;		//The Graph reference need to be visited
	DEGREE<GraphADT> degree;//Degree information of this graph
	ofstream fout;		//output file stream
	
	//data used for DFS traversal
	int depth,cnt,cntP,LP;
	int curLP,cut;
	vector<int> pre,post;	//pre, post vector(size of V)
	vector<int> nodepos;	//position of the nodes in the output
	vector<int> outorder;
	
	//for output LP
	STACK< pathWithIndex* > paths;
	
	//current nodes stack 
	deque<int> pathstack;
	
	//flag for new tree
	bool isNewTree;

	
	//tmp counters
	int IntersectCount;	
	int SelectCount;
	int CartisianCount;
	int SQ;
	int iTableCount;
	int	iTotalNode;

	//used in the opfile
	vector<int> vTestUnique;
	deque<int> selectNode;		//store the nodes need to be selected
	
	fingerprint fp;			//fingerprint of this graph
	
	//The output function of the operations
	void outputIntersect(pathWithIndex&,pathWithIndex&, int,int);
	void outputTestUnique(pathWithIndex&,int,int);
	void outputCartesianProduct();
	void outputSelect(int,int);
	void outputSelectLoop(pathWithIndex& pw1,int,int,int);

	//utility functions that handle pathes
	pathWithIndex* join(pathWithIndex& p1,pathWithIndex& p2,int joint);	//join 2 given paths in a given joint
	void checkLoop(pathWithIndex& p);					//check if there's a loop in the path
	void createPath(int LenthPath,int joint=-1,int tmpLP=0);		//create a path from curren pathstack

	//utility functions
	//void show(char* , Edge );
	//void show(char* );
	//void show(const char* , int );
	//void show(const vector<int>& out);
	//void showNodePos(const pathADT& p);
	//void showDepth();
	string showTable(const vector<int>& tab);

	//DFS traversal function(Right side)
	void dfsR(Edge e);
	

public:
	~vDFS_GraphGrep(){}

	//Constructor
	// Params: 1. GraphADT Object 
	//         2. Lengthpath 
	vDFS_GraphGrep(GraphADT &G,int lp);

	//int operator[](int v) const{return ord[v];}
	unsigned int* getFingerPrint(){  return fp.getFP();  };	//get the fingerprint of this graph
	void writeOutputOrder(char* outfile);			//writing node position of the output into a given file
};

/////////////////////////////////////////////////////////////
//	
//	Implementation detail of vDFS_GraphGrep templete class. 
//	Put here because of templete limitation
//
/////////////////////////////////////////////////////////////
template <class GraphADT>
string vDFS_GraphGrep<GraphADT>::showTable(const vector<int>& tab){
	
	string ret;
	
	for(int j=0;j<tab.size();j++){
		ret+=G.getLabel(tab[j]);
	}
	

	if(QUERY_WITH_DEGREE){
		//degree information
		ret+="^";
		for(int i=0;i<tab.size();i++){
			char tmp[10];
			sprintf(tmp,"_%d",degree[tab[i]]);
			ret+=tmp;
		}
	}

	if(!QUIET_MODE){
		cout << "table:" << ret<<endl;
	}
	
	return ret;	
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::writeOutputOrder(char* outfile){
	FILE* fp=fopen(outfile,"a");
	assert(fp);
	
	for(int i=0;i<outorder.size()*2-2;i++)
		fprintf(fp,"*");
	
	fprintf(fp,"\n");
	for(int j=0;j<outorder.size();j++)
		fprintf(fp,"%d ",outorder[j]);
	
	fprintf(fp,"\n");
	for(int k=0;k<outorder.size()*2-2;k++)
		fprintf(fp,"*");

	
	fprintf(fp,"\n");
	fclose(fp);
}


template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::outputIntersect(pathWithIndex& pw1,pathWithIndex& pw2,int pos1,int pos2){
	const pathADT& p1=*(pw1.getPath());
	const pathADT& p2=*(pw2.getPath());
	char tabname1[100],tabname2[100];
	
	if(pw1.getIndex()==-1)
		sprintf(tabname1,"^%s",showTable(p1).c_str());
	else
		sprintf(tabname1,"qoutable%d",pw1.getIndex());
	
	if(pw2.getIndex()==-1)
		sprintf(tabname2,"^%s",showTable(p2).c_str());
	else
		sprintf(tabname2,"qoutable%d",pw2.getIndex());
	
	if(DEBUG_OPFILE){
		cout<<"INTERSECT "<<"qoutable"<< iTableCount<<" "<< tabname1<< " "<<pos1;
		cout<<" " <<tabname2<< " "<<pos2<<endl;		
	}
	
	if(pos1==-1)
		throw GraphGrepExcp("INTERSECT Position -1 at outputIntersect()");
	
	fout<<"INTERSECT "<<"qoutable"<< iTableCount<<" "<< tabname1<< " "<<pos1;
	fout<<" " <<tabname2<< " "<<pos2<<"\n";
	
	iTableCount++;
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::outputCartesianProduct(){		

	if(CartisianCount<2){		//only 1 tree exist in the last
		pathWithIndex& pw1=*paths.pop();
		pathADT& p1=*(pw1.getPath());

		//writing output node position information
		for(int i=0;i<p1.size();i++)
			outorder.push_back(p1[i]);
	}else{						//Is a forest
		char tabname1[100],tabname2[100];
		
		pathWithIndex& pw1=*paths.pop();
		pathWithIndex& pw2=*paths.pop();
		
		pathADT& p1=*(pw1.getPath());
		pathADT& p2=*(pw2.getPath());

		//writing output node position information
		for(int i=0;i<p1.size();i++)
			outorder.push_back(p1[i]);

		for(int j=0;j<p2.size();j++)
			outorder.push_back(p2[j]);
		
		if(pw1.getIndex()==-1)
			sprintf(tabname1,"^%s",showTable(p1).c_str());
		else
			sprintf(tabname1,"qoutable%d",pw1.getIndex());
		
		if(pw2.getIndex()==-1)
			sprintf(tabname2,"^%s",showTable(p2).c_str());
		else
			sprintf(tabname2,"qoutable%d",pw2.getIndex());
		
		if(DEBUG_OPFILE){
			cout<<"CARTESIANPRODUCT "<<"qoutable"<< iTableCount<<" "<< tabname1<<" "<< tabname2<<endl  ;
			cout.flush();
		}
		fout<<"CARTESIANPRODUCT "<<"qoutable"<< iTableCount<<" "<< tabname1<<" "<< tabname2<<"\n" ;
		
		iTableCount++;
		
		CartisianCount--;
		
		while(CartisianCount>1){
			pathWithIndex& pwNxt=*paths.pop();
			pathADT& pNxt=*(pwNxt.getPath());
			
			if(pwNxt.getIndex()==-1)
				sprintf(tabname1,"^%s",showTable(pNxt).c_str());
			else
				sprintf(tabname1,"qoutable%d",pwNxt.getIndex());
			
			if(DEBUG_OPFILE){
				cout<<"CARTESIANPRODUCT "<<"qoutable"<< iTableCount<<" "<<"qoutable"<< iTableCount-1<<" "<< tabname1<<endl  ;
				cout.flush();
			}
			fout<<"CARTESIANPRODUCT "<<"qoutable"<< iTableCount<<" "<<"qoutable"<< iTableCount-1<<" "<< tabname1<<"\n";

			//insert position to output order
			for(int i=0;i<pNxt.size();i++)
				outorder.push_back(pNxt[i]);

			iTableCount++;CartisianCount--;
		}

	}
	
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::outputSelect(int pos1,int pos2){	
	if(DEBUG_OPFILE){
		cout<<"SELECT "<<"qoutable"<< iTableCount<<" "<<"qoutable"<< iTableCount-1<<" "  ;
		cout<< pos1<<" "<<pos2<<endl;
	}
	
	fout<<"SELECT "<<"qoutable"<< iTableCount<<" "<<"qoutable"<< iTableCount-1<<" "  ;
	fout<< pos1<<" "<<pos2<<"\n";
	
	
	iTableCount++;
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::outputSelectLoop(pathWithIndex& pw1,int pos1,int pos2,int len){	
	const pathADT& p1=*(pw1.getPath());
	char tabname1[100];
	
	if(pw1.getIndex()==-1)
		sprintf(tabname1,"^%s",showTable(p1).c_str());
	else
		sprintf(tabname1,"qoutable%d",pw1.getIndex());
	
	if(DEBUG_OPFILE){
		cout<<"SELECT "<<"qoutable"<< iTableCount<<" "<< tabname1<<" "  ;
		cout<< pos1<<" "<<pos2<<endl;
	}
	
	fout<<"SELECT "<<"qoutable"<< iTableCount<<" "<< tabname1<<" "  ;
	fout<< pos1<<" "<<pos2<<"\n";
	
	pw1.setIndex(iTableCount);
	iTableCount++;
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::createPath(int LenthPath,int joint,int tmpLP){		//output a path of LengthPath
	pathADT	*path=new pathADT(LenthPath+1);	//LP equals nodes+1
	
	for(int i=0;i<=LenthPath;i++){		//pop node to parent(curLP+1)
		//int tmp=pathstack[0];
		//(*path)[i]=tmp;
		
		(*path)[i]=pathstack[0];
		pathstack.pop_front();		
	}			
	
	SQ +=LenthPath;
	pathWithIndex *pIndex= new pathWithIndex(path);
	
	int isize=selectNode.size();
	for(int j=0;j<isize;j++){
		(*pIndex).addSelectNode(selectNode[0]);
		selectNode.pop_front();
	}
	
	//show(*path);
	if(!isNewTree && paths.size()>0 ){
		paths.push(join(*paths.pop(),*pIndex,joint));		
	}else{
		//cout<< "New tree, Paths:"<<pIndex->getIndex()<< " itableCount:"<<iTableCount<<endl;
		
		paths.push(pIndex);
		isNewTree=false;
	}
	
	//cout<<showTable(*path).c_str();	
	unsigned int FP=fp.addPattern(showTable(*path));
	
	if(!QUIET_MODE){
		cout<<showTable(*path).c_str()<< " FP:"<<FP<<endl;
	}
	
	//show(*path);
	//cout<<"FP:"<<FP<<"\t";
	
	curLP=tmpLP;
	
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::outputTestUnique(pathWithIndex& pw,int oldLen,int tmpselectCount){
	const pathADT& p=*(pw.getPath());
	int len=p.size();
	
	if(iTableCount>0){
		if(DEBUG_OPFILE)
			cout<<"TESTUNIQUE "<<"qoutable"<< iTableCount<<" "<<"qoutable"<< iTableCount-1<<" "  ;
		
		fout<<"TESTUNIQUE "<<"qoutable"<< iTableCount<<" "<<"qoutable"<< iTableCount-1<<" "  ;
	}else{	//for the case that there's no other paths involved in the graph
		char tabname[100];
		if(pw.getIndex()==-1)
			sprintf(tabname,"^%s",showTable(p).c_str());
		else
			sprintf(tabname,"qoutable%d",pw.getIndex());
		
		if(DEBUG_OPFILE)
			cout<<"TESTUNIQUE "<<"qoutable"<< iTableCount<<" "<<tabname<<" "  ;
		
		fout<<"TESTUNIQUE "<<"qoutable"<< iTableCount<<" "<<tabname<<" "  ;	
		pw.setIndex(iTableCount);
	}
	
	int count=0;
	
	//Generate Testunique position from last Testunique position(iTotalNode-1) to current length
	//!! Because the each position will be unique after Testunique, we don't need to check the old position
	for(int i=((iTotalNode-1)<0?0:(iTotalNode-1));i<((len-tmpselectCount)>oldLen?(len):(len-tmpselectCount+1));i++) {
		if(DEBUG_OPFILE)
			cout << i<<" ";
		fout << i<<" ";
		count++;
	}
	//cout.flush();	
	
	if(count==0){
		if(DEBUG_OPFILE)
			cout<<-1;
		fout<<-1;
	}
	
	if(DEBUG_OPFILE)
		cout<<endl;
	
	fout<<"\n";
	
	iTableCount++;
	iTotalNode=len;
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::checkLoop(pathWithIndex& pw1){	//check if there's a loop in the path
	pathADT& p1=*(pw1.getPath());
	int lenP1=p1.size();
	
	vector<int>& selectNodes=pw1.getSelectNodes();	//get the need-select node of this path
	int ssize=selectNodes.size();
	vector<int> selectNodePair((ssize)*2,-1);	//allocate vector for the possible loops
	
	vector<int> VisitedNode;
	
	int count=0;
	
	int i=0;
	int size=lenP1;
	typedef vector<int> vInt;
	vInt::iterator it=p1.begin(),
		it_end=p1.end();
	
	while(i<size){
		int n=p1[i];
		
		for(int x1=0;x1<ssize;x1++){
			if(n==selectNodes[x1]){
				bool stopflag=false;
				int k=selectNodes[x1];
				
				for(int j=0;j<VisitedNode.size();j++){	//already visited select node
					if(k==VisitedNode[j]){
						stopflag=true;
						break;
					}
				}
				
				if(stopflag)	break;
				
				if(selectNodePair[x1]>-1){		//loop
					selectNodePair[x1+ssize]=-1;	//reset it
					
					VisitedNode.push_back(k);
					count++;	//found loop
					
					selectNodes[x1]=-1;	//mark self-loop node
					
					outputSelectLoop(pw1,selectNodePair[x1],i,lenP1);
					
					if(it+1!=it_end)		//!!maybe some bug here
						p1.erase(it,it+1);
					else
						p1.pop_back();
					
					i--;
					size--;
					
				}else		//first met
					selectNodePair[x1]=i;		
				
				vTestUnique[n]=0;
			}
		}
		i++;
		it++;
	}
}

template <class GraphADT>
pathWithIndex* vDFS_GraphGrep<GraphADT>::join(pathWithIndex& pw1,pathWithIndex& pw2,int joint){
	const pathADT& p1=*(pw1.getPath());
	const pathADT& p2=*(pw2.getPath());
	const vector<int>& selectNodes1=pw1.getSelectNodes();
	const vector<int>& selectNodes2=pw2.getSelectNodes();
	
	//	show(selectNodes1);
	//	show(selectNodes2);
	
	//	show(p1);
	//	show(p2);
	
	//Check loop before doing join
	//if(pw1.getPath()->size()>=LP)		
	checkLoop(pw1);
	
	checkLoop(pw2);
	
	//	show(p1);
	//	show(p2);
	
	
	int lenP1=p1.size(),lenP2=p2.size();
	int pos1=-1,pos2=-1;
	
	//if(joint==0)
	joint=p2[0];
	
	int iSelect=pw2.getSelectCount();
	vector<int> selectNodePair((iSelect)*2,-1);
	vector<int> selectPairResult((iSelect)*2,-1);
	
	pathADT* retP=new pathADT(lenP1);			//need to be free in some place
	
	for(int i=0;i<lenP1;i++) {
		int n=p1[i];		
		(*retP)[i]=n;		//add nodes into return path
		
		if(nodepos[n]==-1 ){		//modify the current position corresonding to P1
			nodepos[n]=i;
		}
		
		if(vTestUnique[n]>0)	//testunique checking control
			vTestUnique[n]++;
		
		if(n==joint)
			pos1=i;
		
		if(iSelect>0){				//check back/cross path
			for(int x1=0;x1<iSelect;x1++){		//for each select1 node
				int k=selectNodes2[x1];
				if(n==selectNodes2[x1]){
					selectNodePair[x1]=i;
					vTestUnique[n]=0;
				}
			}
		}
		
	}
	
	//if merge path, simply join at p1:size-1 & p2:0
	//if join children, join at parent node
	if(joint>-1){
		vTestUnique[joint]=0;
	}else{
		vTestUnique[p1[lenP1-1]]=0;
	}
	
	
	int tmpselectcount=0;
	//below is the same as path1
	for(int j=0;j<lenP2;j++) {
		int n=p2[j];
		//(*retP)[j+lenP1]=n;		//new solution
		
		if(vTestUnique[n]>0)
			vTestUnique[n]++;
		
		nodepos[n]=j+lenP1;	//modify the current position correspoing to (P1+P2)
		
		if(iSelect>0){				//check select node
			if(n==joint)	//not push_back the joint node
				pos2=j;
			else
				(*retP).push_back(n);
			
			for(int x1=0;x1<iSelect;x1++){		//for each select1 node
				if(n==selectNodes2[x1]){
					int k=selectNodes2[x1];
					int inode=selectNodePair[x1];
					if(inode>-1){		//back/cross path						
						
						selectNodePair[x1+iSelect]=j+lenP1-1-tmpselectcount;	//normal case
						
						selectPairResult[tmpselectcount]=selectNodePair[x1];
						selectPairResult[tmpselectcount+iSelect]=j+lenP1-1-tmpselectcount;
						
						tmpselectcount++;
						//selectNodePair[x1+iSelect]=j;
						(*retP).pop_back();
					}
					vTestUnique[n]=0;
				}
			}
			
		}else{
			if(n==joint)
				pos2=j;
			else
				(*retP).push_back(n);
		}
		
		
	}
	
	if(joint>-1){
		vTestUnique[joint]=0;
		outputIntersect(pw1,pw2,pos1,pos2);
	}else{
		vTestUnique[p2[0]]=0;
		outputIntersect(pw1,pw2,lenP1-1,0);
	}
		
	pathWithIndex* pIndex= new pathWithIndex(retP,iTableCount-1);
	
	for(int r=0;r<iSelect;r++){		//output selection
		if(selectPairResult[r]!=-1 && selectPairResult[r+iSelect]!=-1){	//involved in the join paths... output it
			outputSelect(selectPairResult[r],selectPairResult[r+iSelect]);
		}
	}
	
	//if(iTableCount%2==0)
	outputTestUnique(*pIndex,lenP1,tmpselectcount);
	
	pIndex->setIndex(iTableCount-1);
	
	return pIndex;
}

template <class GraphADT>
void vDFS_GraphGrep<GraphADT>::dfsR(Edge e){
	int w=e.w; 
	//if(e.v!=e.w)
		//show(" tree",e);
	
	pathstack.push_back(w);
	
	pre[w] =cnt++; depth++;
	
	typename GraphADT::adjIterator A(G,w);
	
	int ichild=0;	
	
	for(int t=A.beg();!A.end();t=A.nxt())
	{
		if(t!=-1){	//there's a path
			Edge x(w,t);
			
			G.remove(x);	//marked visted paths
			ichild++;
			curLP++;
			
			if(curLP>=(LP+1)){
				pathstack.push_back(w);
				createPath(curLP-1,0,1);
				cut++;
			}
			
			if(ichild>1){		//has more than 1 child in this node, push parent node into stack
				//show("=========================");
				pathstack.push_back(w);
			}
			
			if(pre[t]==-1){					//normal node in the path 			
				//show(" tree",x);
				
			}else if(post[t]== -1){		
				//show(" back path(select)",x);	//select point
				SelectCount++;
				selectNode.push_back(t);
				
			}else if(pre[t] >pre[w]){	//shouldn't happen, already remove all visited paths
				//show(" down",x);
			}else{					//cross path...select point
				int pret=pre[t];
				int postt=post[t];
				int prew=pre[w];
				int postw=post[w];
				
				//show(" cross",x);
				
				selectNode.push_back(t);
			}
			
			dfsR(x);		//no matter what ... keep going down
			
		}
	}
	
	if(ichild==0 && curLP>=1){	//leaf
		if(cut>0){
			createPath(curLP,-1,0);
		}else{
			createPath(curLP,0,0);
		}
		curLP=0;
		cut=0;
	}
	
	
	post[w]=cntP++; depth--;
	
}

//Constructor
// Params: 1. GraphADT Object 
//         2. Lengthpath 
template <class GraphADT>
vDFS_GraphGrep<GraphADT>::vDFS_GraphGrep(GraphADT &G,int lp):G(G),degree(G),cnt(0),cntP(0),depth(0),pre(G.V(),-1), post(G.V(),-1),curLP(0),paths(0),LP(lp),cut(0),nodepos(G.V(),-1),vTestUnique(G.V(),-1)
,iTableCount(0),iTotalNode(0),isNewTree(false),CartisianCount(0),fp(NUM_INTS),SQ(0)
{
		  fout.open("opfile");
		  IntersectCount=0;
		  SelectCount=0;
		  
		  for(int v=0;v<G.V();v++){
			  if(pre[v]==-1){
				  isNewTree=true;
				  dfsR(Edge(v,v));
				  
				  if(paths.size()==1 && iTableCount==0){ //Special case, only has 1 path
					  checkLoop(*paths[0]);
					  outputTestUnique(*paths[0],0,0);
				  }
				  
				  if(pathstack.size()>0)	//for single node that didn't create inside dfsR()
					  createPath(curLP,0,0);
				  
				  CartisianCount++;
				  curLP=0;
			  }
		  }
		  
		  int itmpCartisianCount=CartisianCount;
		  //output CartesianProduct
		  outputCartesianProduct();
		  
		  if(!QUIET_MODE){
		  	  cout<<"CartisianCount:"<<itmpCartisianCount<<endl;
			  cout<<"SPIT qoutable"<<iTableCount-1<<endl;
			  cout<<"#Intersect count:"<<IntersectCount<<endl;
			  cout<<"#Select count:"<<SelectCount<<endl;
		  }
		  
		  //cout<<"CartisianCount:"<<itmpCartisianCount<<endl;
		  cout<<"nV:"<<G.V()<<"\n";
		  cout<<"SQ:"<<SQ <<"\n";
		  		  
		  //outputing the output node position information
		  for(int i=0;i<outorder.size();i++){
		  	//cout<< outorder[i] << " ";
		  }
		  
		  fout<<"SPIT qoutable"<<iTableCount-1<<"\n";
		  
		  fout.close();
}

