#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "constants.h"



/*
  main screen
*/

void main_screen() {
  fprintf(stderr,"\n\n\n________ GRAPHCLUST SOFTWARE - Version 2.0 - (C) 2005 ________\n\n");
  fprintf(stderr,"Authors: Diego Reforgiato   diegoref@dmi.unict.it\n");
  fprintf(stderr,"         Dennis Shasha      shasha@cs.nyu.edu\n\n");
  fprintf(stderr,"http://www.cs.nyu.edu/cs/faculty/shasha/papers/GraphClust.html\n\n");
  fprintf(stderr,"______________________________________________________________\n\n");
}



/*
  Called if passing a wrong number of parameters
*/

void error() {
  fprintf(stderr,"\nusage: graphclust_main dataset [-kmeans k,-tightness measure] [ -s [S,P] -g [D,U] -m [I,E] -min x -SVD k] \n\n");
  exit(-1);
}



int main(int argc,char *argv[]) {
  int i,flag0=FALSE,flag1=FALSE,flag2=FALSE,flag3=FALSE,flag4=FALSE,flag5=FALSE,flag6=FALSE,kmeans=FALSE;
  int p1=-1,min=1,SVD=-1;
  char c1,c2,c3;
  char str[MAX_STR];
  char data[MAX_STR];
  char app[MAX_STR];

  main_screen();
  c1 = 'S';
  c2 = 'U';
  c3 = 'I';
  for(i=1;i<argc;i++) {
    if(argv[i][0] != '-') {
      if(flag0 == TRUE)
	error();
      strcpy(data,argv[i]);
      flag0 = TRUE;
    }
    else
      if(!strcmp(argv[i],"-kmeans")) {
	if(flag1 == TRUE || i == argc-1) {
	  error();
	}
	p1 = (int)atoi(argv[i+1]);
	i++;
	flag1 = TRUE;
	kmeans = TRUE;
      }
      else
	if(!strcmp(argv[i],"-tightness")) {
	  if(flag1 == TRUE || i == argc-1)
	    error();
	  p1 = atoi(argv[i+1]);
	  i++;
	  flag1 = TRUE;
	  kmeans = FALSE;
	}
	else
	  if(!strcmp(argv[i],"-s")) {
	    if(flag2 == TRUE || i == argc-1)
	      error();
	    c1 = argv[i+1][0];
	    i++;
	    flag2 = TRUE;
	  }
	  else
	    if(!strcmp(argv[i],"-g")) {
	      if(flag3==TRUE || i == argc-1)
		error();
	      c2 = argv[i+1][0];
	      i++;
	      flag3 = TRUE;
	    }
	    else
	      if(!strcmp(argv[i],"-m")) {
		if(flag4 == TRUE || i == argc-1)
		  error();
		c3 = argv[i+1][0];
		i++;
		flag4 = TRUE;
	      }
	      else {
		if(!strcmp(argv[i],"-min")) {
		  if(flag5 == TRUE || i == argc-1)
		    error();
		  min =  (int)atoi(argv[i+1]);
		  i++;
		  flag5 = TRUE;
		}
		else
		  if(!strcmp(argv[i],"-SVD")) {
		    if(flag6 == TRUE || i == argc-1)
		      error();
		    SVD =  (int)atoi(argv[i+1]);
		    i++;
		    flag6 = TRUE;
		  }
		
	      }
  }
  if(flag1 == FALSE || flag0 == FALSE || p1==0)
    error();
  else {
    switch(kmeans) {
    case FALSE:
      switch(c1) {
      case 'S':
	strcpy(str,"./graphclustAntipole_Subdue ");
	strcat(str,data);
	switch(c2) {
	case 'U':
	  strcat(str," u ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E')
	    error();
	  sprintf(app,"%d ",min);
	  strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	case 'D':
	  strcat(str," d ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E')
	    error();
	  sprintf(app,"%d ",min);
          strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	default:
	  error();
	  break;
	}
	break;
      case 'P':
	strcpy(str,"./graphclustAntipole ");
	strcat(str,data);
	switch(c2) {
	case 'U':
	  strcat(str," u ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E')
	    error();
	  sprintf(app,"%d ",min);
	  strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	case 'D':
	  strcat(str," d ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E')
	    error();
	  sprintf(app,"%d ",min);
          strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	default:
	  error();
	  break;
	}
	break;
      default:
	error();
	break;
      }
      break;
    case TRUE:
      switch(c1) {
      case 'S':
	strcpy(str,"./graphclustKmeans_Subdue ");
	strcat(str,data);
	switch(c2) {
	case 'U':
	  strcat(str," u ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E') {
	    error();
	  }
	  sprintf(app,"%d ",min);
          strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	case 'D':
	  strcat(str," d ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E') {
	    error();
	  }
	  sprintf(app,"%d ",min);
	  strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	default:
	  error();
	  break;
	}
	break;
      case 'P':
	strcpy(str,"./graphclustKmeans ");
	strcat(str,data);
	switch(c2) {
	case 'U':
	  strcat(str," u ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E') {
	    error();
	  }
	  sprintf(app,"%d ",min);
          strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	case 'D':
	  strcat(str," d ");
	  sprintf(app,"%d ",p1);
	  strcat(str,app);
	  if(c3!='I' && c3!='E') {
	    error();
	  }
	  sprintf(app,"%d ",min);
	  strcat(str,app);
	  if(flag6==TRUE) {
	    sprintf(app,"%d ",SVD);
	    strcat(str,app);
	  }
	  else {
	    sprintf(app,"NOSVD ");
	    strcat(str,app);
	  }
	  sprintf(app,"%c ",c3);
	  strcat(str,app);
	  system(str);
	  break;
	default:
	  error();
	  break;
	}
	break;
      default:
	error();
	break;
      }
      break;
    }
  }
  return 0;
}

