/*
  BuildKmeans.c. The function Build1() creates the Kmeans data structure
  in the global variable *G
*/

#include "BuildKmeans.h"



/*
  It takes two Objects and swaps them
*/

void Swap(Object *A,Object *B) {
  Object *tmp;
  tmp = (Object *) malloc(sizeof(Object));
  if(!tmp)
    exit(-1);  
  memcpy(tmp,A,sizeof(Object));
  memcpy(A,  B,sizeof(Object));
  memcpy(B,  tmp,sizeof(Object));
  free(tmp);
  return;
}



/*
  It takes two ints and swaps them
*/

void swap(int  *x,int *y) {
  int tmp;
  tmp = *x;
  *x = *y;
  *y = tmp;
}



/*
  It computes the furtest element with Gonzales algorithm
*/

int Gonzales(Object *S,int j) {
  int i,k,idx = -1;
  float temp,t1 = 0,t2 = 0;
  for(i=j;i<n;i++) {
    temp = INFINITY;
    for(k=0;k<j;k++) {
      t1 = Dist(S+i,S+k);
      if(t1 < temp) {
	temp = t1;
      }
    }
    if(temp > t2) {
      t2 = temp;
      idx = i;
    }
  }
  if(idx==-1)
    idx=n-1;
  return idx;
}



/*
  It computes an exact centroid
*/

int Median1(Object *S,int *T,int start,int size) {
  int i,j,ret=-1;
  float dis,ris=INFINITY;
  for(i=start;i<size;i++) {
    dis = 0;
    for(j=start;j<size;j++) {
      dis += Dist(S+T[i],S+T[j]);
    }
    if(dis < ris) {
      ris = dis;
      ret = i;
    }
  }
  return T[ret];
}



/*
  It computes an approximated centroid using randomized tournaments
*/

int Median(int i,int *Elements,int size,Object *S) {
  int j,k,size_T,size_W,i1,i2,ss,start;
  int *T=NULL,*W=NULL;
  T = (int *)malloc(sizeof(int)*size);
  size_T = size;
  for(j=0;j<size-1;j++) {
    T[j] = Elements[j];
  }
  T[size-1] = i;
  
  start = 0;
  
  while(size_T > 8) {
    for(k=start;k<size;k++) {
      i1 = start + rand()%size_T;
      i2 = start + rand()%size_T;
      swap(T+i1,T+i2);
    }
    size_W = 0;

    while(size_T >= 6) {
      start += 3;
      ss = Median1(S,T,start-3,start);
      size_W++;
      W = (int *)realloc(W,sizeof(int)*size_W);
      W[size_W-1] = ss;
      size_T -= 3;
    }
    if(size_T > 0) {
      ss = Median1(S,T,start,size);
      size_T = 1;
      start = size;
      T[--start] = ss;
    }
    
    for(ss = 0; ss < size_W; ss++) {
      T[--start] = W[ss];
      size_T++;
    }
    if(W) {
      free(W);
      W = NULL;
    }
  }
  ss = Median1(S,T,start,size);
  free(T);
  return ss;
}



/*
  It computes the minimum distance from S[i]
*/

int argmin(Object *S,int i,int j,float **m) {
  int k,el=-1;
  float d,min=INFINITY;
  for(k=0;k<j;k++) {
    d = ComputeDist(S[i].X,m[k]);
    if(d < min) {
      min = d;
      el = k;
    }
  }
  return el;
}



/*
  It takes the objects in *S and the number of clusters and
  computes in *G the clustering by using the kmeans algorithm
*/

void Build1(Object *S,int num_clusters) {
  int i,j=0,k,idx=-1,mmm;
  float dis,temp,J=0,J1=0;
  float **m=NULL,*radius;
  int *check=NULL,*size=NULL,cont=0;

  check = (int *)malloc(sizeof(int)*num_clusters);
  size = (int *)malloc(sizeof(int)*num_clusters);
  m = (float **)malloc(sizeof(float *)*num_clusters);
  radius = (float *)malloc(sizeof(float)*num_clusters);
  
  for(i=0;i<num_clusters;i++) {
    m[i] = (float *)malloc(sizeof(float)*SpaceDim);
    check[i]=-1;
    size[i]=0;
    radius[i]=0;
  }
  
  i = (int) (rand()%n);
  G[j].Elements = NULL;
  G[j].Dc = NULL;
  G[j].size = 0;
  G[j].radius = 0;
  G[j].Centroid = j;
  j++;

  Swap(S+j-1,S+i); // first centroid is in S[0]
  S[0].clu = 0;

  // takes the num_clusters centroids
  while(j<num_clusters) {
    i = Gonzales(S,j);
    G[j].Centroid = j;
    G[j].size = 0;
    G[j].radius = 0;
    G[j].Elements = NULL;
    G[j].Dc = NULL;
    j++;
    Swap(S+j-1,S+i);
    S[j-1].clu = j-1;
  }

  // each element is assigned to its closest centroid
  for(i=j;i<n;i++) {
    temp = INFINITY;
    for(k=0;k<j;k++) {
      dis = Dist(S+i,S+k);
      if(dis < temp) {
	temp = dis;
	idx = k;
      }
    }
    if(S[i].clu==-1) {
      S[i].clu = idx;
      S[i].Dc = temp;
      if(temp > radius[idx]) {
      	radius[idx]=temp;
      }
    }
    size[idx]++;
    for(mmm=0;mmm<SpaceDim;mmm++) {
      if(check[idx]==-1) {
    	m[idx][mmm] = S[i].X[mmm];
      }
      else {
    	m[idx][mmm] += S[i].X[mmm];
      }
    }
    check[idx] = 0;
  }
  
  for(i=0;i<j;i++)
    for(mmm=0;mmm<SpaceDim;mmm++)
      m[i][mmm] = m[i][mmm] / size[i];
  
  J=0;
  for(i=0;i<j;i++)
    for(mmm=j;mmm<n;mmm++)
      J+=ComputeDist(S[mmm].X,m[i]);
  
  if(num_clusters > 1)
    do {
      for(i=0;i<n;i++) {
	k = argmin(S,i,j,m);
	if(i!=k && size[S[i].clu]!=0) {
	  size[S[i].clu]--;
	  S[i].clu = k;
	  size[S[i].clu]++;
	}
      }
      memset(check,0,sizeof(int)*num_clusters);
      for(i=0;i<n;i++)
	for(mmm=0;mmm<SpaceDim;mmm++) {
	  if(check[S[i].clu]==0)
	    m[S[i].clu][mmm] = S[i].X[mmm];
	  else
	    m[S[i].clu][mmm] += S[i].X[mmm];
	}
      for(i=0;i<j;i++)
	for(mmm=0;mmm<SpaceDim;mmm++)
	  m[i][mmm] = m[i][mmm]/size[i];
      J1=0;
      for(i=0;i<j;i++)
	for(mmm=j;mmm<n;mmm++)
	  J1+=ComputeDist(S[mmm].X,m[i]);
      cont++;
    }
    while(J1<J && cont<MAX_ITERATIONS);

  for(i=0;i<j;i++) {
    G[i].radius = radius[i];
  }

  for(i=0;i<n;i++) {
    G[S[i].clu].size++;
    G[S[i].clu].Elements = (int *)realloc(G[S[i].clu].Elements,sizeof(int)*(G[S[i].clu].size));
    G[S[i].clu].Dc = (float *)realloc(G[S[i].clu].Dc,sizeof(float)*(G[S[i].clu].size));
    G[S[i].clu].Dc[G[S[i].clu].size-1] = S[i].Dc;
    G[S[i].clu].Elements[G[S[i].clu].size-1] = i;
  }

  for(i=0;i<j;i++) {
    if(G[i].size > 2) {
      k = Median(i,G[i].Elements,G[i].size,S);
      
      Swap(S+G[i].Centroid,S+k);
      G[i].radius = 0;
      for(k=0;k<size[i];k++) {
	dis = Dist(S+G[i].Elements[k],S+G[i].Centroid);
	G[i].Dc[k] = dis;
      	if(dis > G[i].radius)
      	  G[i].radius = dis;
      }
    }
  }
  
  for(i=0;i<num_clusters;i++)
    free(m[i]);
  free(m);
  free(check);
  free(size);
  free(radius);
}
