#include "loadAntipole.h"



/*
  Allocated memory for S
*/

void Allocating_S() {
  int i;
  S = (Object *) malloc(n * sizeof(Object));
  if(!S)
    exit(-1);
  for(i = 0; i < n; i++) {
    S[i].X = (float *) malloc(sizeof(float)*SpaceDim);
    if(!S[i].X)
      exit(-1);
    S[i].index = (int *) malloc(sizeof(int));
    if(!S[i].index)
      exit(-1);
    S[i].idx_CLU = (int *) malloc(sizeof(int));
    if(!S[i].idx_CLU)
      exit(-1);
    S[i].Dv = NULL;
  }
}



/*
  Load 'size' objects of SpaceDim 'dim' from the file *fp in *S
*/

void Load_Data2(Object *S, int size,int dim,FILE *fp) {
  int i,j;
  
  for(i = 0; i < size; i++){
    for(j = 0; j < dim; j++) {
      fscanf(fp,"%f",&S[i].X[j]);
    }
    *S[i].index = i;
    S[i].dvS = 0;
  }
  return;
}



/*
  Free the n data objects saved in S
*/

void Libera_S(int n) {
  int i;
  for(i=0;i<n;i++) {
    free(S[i].idx_CLU);
    S[i].idx_CLU=NULL;
    free(S[i].index);
    S[i].index=NULL;
    free(S[i].X);
    S[i].X=NULL;
    if(S[i].Dv!=NULL) {
      free(S[i].Dv);
    }
  }
  free(S);
  S=NULL;
}



/*
  It returns the distance between two Objects *O1 and O2
*/

float Dist(Object *O1,Object *O2){
  float d;
  d = ComputeDist(O1->X,O2->X);
  return d;
}



/*
  It computes the inner product distance or the Euclidean distance according to choice
*/

float ComputeDist(float *X, float *Y) {
  int i;
  double d = 0;
  switch(choice) {
  case 'I':
    for(i = 0; i < SpaceDim; i++) {
      d += X[i]*Y[i]; // inner product
    }
    return d;
  case 'E':
    for(i = 0; i < SpaceDim; i++)
      d += pow(X[i]-Y[i],2);
    return sqrt(d); // Euclidean
  }
  return -1;
}



/*
  It takes the value [1..4] as range, the list of n k-dimensional vectors, and 
  returns the value for the diameter d of the Antipole in order to create an Antipole Tree
  with the number of clusters according to the range
  [ few clusters for a low value and a lot clusters for high values ]
*/

void Compute_Radius(int range,Object *S,int n,float *d) {
  int i,i1,i2;
  float temp,min=INFINITY,max=0;
  for(i=0;i<n;i++) {
    i1 = rand()%n;
    do {
      i2 = rand()%n;
    }
    while(i1==i2 && n!=1);
    temp = Dist(S+i1,S+i2);
    if(temp < min)
      min = temp;
    if(temp > max)
      max = temp;
  }

  switch(range) {
  case 1:
    (*d) = max;
    break;
  case 2:
    (*d) = max - (max - min) / 3;
    break;
  case 3:
    (*d) = min + (max - min) / 3;
    break;
  case 4:
    (*d) = min;
    break;
  }
}



/*
  Free the memory of the Antipole Tree data structure
*/

void Libera_Tree2(W_Tree *T) {
  if(T!=NULL) {
    if(T->leaf==1) {
      if(T->clust!=NULL) {
        if(T->clust->size!=0)
          free(T->clust->Elements);
        if(T->clust->Centroid!=NULL)
          free(T->clust->Centroid);
        T->clust->neighbor=NULL;
        T->clust->next=NULL;
        T->clust->tree_node=NULL;
        free(T->clust);
      }
      if(T->A!=NULL)
        free(T->A);
      if(T->B!=NULL)
        free(T->B);
      free(T);
    }
    else {
      Libera_Tree2(T->left);
      Libera_Tree2(T->right);
      if(T->A!=NULL)
        free(T->A);
      if(T->B!=NULL)
        free(T->B);
      free(T);
    }
  }
}
