/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.javasound.JSBaseAudioRecordingStream;
import ddf.minim.javasound.JSMinim;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javazoom.spi.mpeg.sampled.convert.DecodedMpegAudioInputStream;
import org.tritonus.share.sampled.AudioUtils;

class JSMPEGAudioRecordingStream
extends JSBaseAudioRecordingStream {
    private AudioMetaData meta;
    private AudioInputStream encAis;

    JSMPEGAudioRecordingStream(JSMinim sys, AudioMetaData mdata, AudioInputStream encStream, AudioInputStream decStream, SourceDataLine sdl, int bufferSize) {
        super(sys, decStream, sdl, bufferSize, mdata.length());
        this.meta = mdata;
        this.encAis = encStream;
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public int getMillisecondLength() {
        return this.meta.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int skip(int millis) {
        this.system.debug("Skipping forward by " + millis + " milliseconds.");
        long toSkip = AudioUtils.millis2BytesFrameAligned(millis, this.format);
        byte[] skipBytes = new byte[(int)toSkip];
        long totalSkipped = 0L;
        try {
            while (totalSkipped < toSkip) {
                int read;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    read = this.ais.read(skipBytes, 0, (int)(toSkip - totalSkipped));
                }
                if (read != -1) {
                    totalSkipped += (long)read;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.system.error("Unable to skip due to read error: " + e.getMessage());
        }
        this.system.debug("Total actually skipped was " + totalSkipped + ", which is " + AudioUtils.bytes2Millis(totalSkipped, this.format) + " milliseconds.");
        return (int)totalSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rewind() {
        AudioInputStream audioInputStream = this.ais;
        synchronized (audioInputStream) {
            try {
                this.ais.close();
            }
            catch (IOException e) {
                this.system.error("Couldn't close the stream for reloading: " + e.getMessage());
            }
            AudioInputStream encIn = this.system.getAudioInputStream(this.meta.fileName());
            this.ais = (DecodedMpegAudioInputStream)this.system.getAudioInputStream(this.format, encIn);
        }
    }
}

