/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PImage;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.sg.SGChannel;
import quicktime.std.sg.SGDeviceList;
import quicktime.std.sg.SGVideoChannel;
import quicktime.std.sg.SequenceGrabber;
import quicktime.std.sg.VideoDigitizer;
import quicktime.util.EndianOrder;
import quicktime.util.RawEncodedImage;

public class Capture
extends PImage
implements Runnable {
    public static final int COMPOSITE = 0;
    public static final int SVIDEO = 1;
    public static final int COMPONENT = 2;
    public static final int TUNER = 6;
    public static final int NTSC = 0;
    public static final int PAL = 1;
    public static final int SECAM = 2;
    Method captureEventMethod;
    String name;
    Thread runner;
    boolean available = false;
    public int[] data;
    public int dataWidth;
    public int dataHeight;
    public int dataRowBytes;
    public boolean crop;
    public int cropX;
    public int cropY;
    public int cropW;
    public int cropH;
    public int frameRate;
    public RawEncodedImage raw;
    public SequenceGrabber capture;
    public SGVideoChannel channel;
    protected QDRect qdrect;

    public Capture(PApplet pApplet, int n, int n2) {
        this(pApplet, n, n2, null, 30);
    }

    public Capture(PApplet pApplet, int n, int n2, int n3) {
        this(pApplet, n, n2, null, n3);
    }

    public Capture(PApplet pApplet, int n, int n2, String string) {
        this(pApplet, n, n2, string, 30);
    }

    public Capture(PApplet pApplet, int n, int n2, String string, int n3) {
        this.init(pApplet, n, n2, string, n3);
    }

    public void init(PApplet pApplet, int n, int n2, String string, int n3) {
        this.parent = pApplet;
        this.name = string;
        this.frameRate = n3;
        try {
            QTSession.open();
        }
        catch (QTException qTException) {
            qTException.printStackTrace(System.out);
            return;
        }
        try {
            this.qdrect = new QDRect(n, n2);
            QDGraphics qDGraphics = null;
            qDGraphics = EndianOrder.isNativeLittleEndian() ? new QDGraphics(1111970369, this.qdrect) : new QDGraphics(QDGraphics.kDefaultPixelFormat, this.qdrect);
            this.capture = new SequenceGrabber();
            this.capture.setGWorld(qDGraphics, null);
            this.channel = new SGVideoChannel(this.capture);
            this.channel.setBounds(this.qdrect);
            this.channel.setUsage(2);
            this.capture.startPreview();
            PixMap pixMap = qDGraphics.getPixMap();
            this.raw = pixMap.getPixelData();
            if (string != null && string.length() > 0) {
                this.channel.setDevice(string);
            }
            this.dataRowBytes = this.raw.getRowBytes();
            this.dataWidth = this.dataRowBytes / 4;
            this.dataHeight = this.raw.getSize() / this.dataRowBytes;
            if (this.dataWidth != n) {
                this.crop = true;
                this.cropX = 0;
                this.cropY = 0;
                this.cropW = n;
                this.cropH = n2;
            }
            super.init(n, n2, 1);
            pApplet.registerDispose(this);
            try {
                this.captureEventMethod = pApplet.getClass().getMethod("captureEvent", Capture.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runner = new Thread(this);
            this.runner.start();
        }
        catch (QTException qTException) {
            int n4 = qTException.errorCode();
            if (n4 == -9405) {
                pApplet.die("No capture could be found, or the VDIG is not installed correctly.", (Exception)((Object)qTException));
            } else {
                pApplet.die("Error while setting up Capture", (Exception)((Object)qTException));
            }
        }
        catch (Exception exception) {
            pApplet.die("Error while setting up Capture", exception);
        }
    }

    public boolean available() {
        return this.available;
    }

    public void crop(int n, int n2, int n3, int n4) {
        this.crop = true;
        this.cropX = Math.max(0, n);
        this.cropY = Math.max(0, n2);
        this.cropW = Math.min(n3, this.dataWidth);
        this.cropH = Math.min(this.dataHeight, n2 + n4) - this.cropY;
        if (this.cropW != this.width || this.cropH != this.height) {
            this.init(n3, n4, 1);
        }
    }

    public void noCrop() {
        this.crop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        this.loadPixels();
        int[] nArray = this.pixels;
        synchronized (this.pixels) {
            if (this.crop) {
                if (this.data == null) {
                    this.data = new int[this.dataWidth * this.dataHeight];
                }
                this.raw.copyToArray(0, this.data, 0, this.dataWidth * this.dataHeight);
                int n = this.cropX + this.cropY * this.dataWidth;
                int n2 = 0;
                for (int i = 0; i < this.cropH; ++i) {
                    System.arraycopy(this.data, n, this.pixels, n2, this.cropW);
                    n += this.dataWidth;
                    n2 += this.width;
                }
            } else {
                this.raw.copyToArray(0, this.pixels, 0, this.width * this.height);
            }
            this.available = false;
            this.updatePixels();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (Thread.currentThread() == this.runner && this.capture != null) {
            try {
                SequenceGrabber sequenceGrabber = this.capture;
                synchronized (sequenceGrabber) {
                    this.capture.idle();
                    this.available = true;
                    if (this.captureEventMethod != null) {
                        try {
                            this.captureEventMethod.invoke((Object)this.parent, this);
                        }
                        catch (Exception exception) {
                            System.err.println("Disabling captureEvent() for " + this.name + " because of an error.");
                            exception.printStackTrace();
                            this.captureEventMethod = null;
                        }
                    }
                }
            }
            catch (QTException qTException) {
                this.errorMessage("run", (Exception)((Object)qTException));
            }
            try {
                Thread.sleep(1000 / this.frameRate);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void frameRate(int n) {
        if (n <= 0) {
            System.err.println("Capture: ignoring bad frameRate of " + n + " fps.");
            return;
        }
        this.frameRate = n;
    }

    public void stop() {
        if (this.capture != null) {
            try {
                this.capture.stop();
            }
            catch (StdQTException stdQTException) {
                stdQTException.printStackTrace();
            }
            this.capture = null;
        }
        this.runner = null;
    }

    public void dispose() {
        this.stop();
        QTSession.close();
    }

    protected void errorMessage(String string, Exception exception) {
        this.parent.die("Error inside Capture." + string + "()", exception);
    }

    public void source(int n) {
        try {
            VideoDigitizer videoDigitizer = this.channel.getDigitizerComponent();
            int n2 = videoDigitizer.getNumberOfInputs();
            for (int i = 0; i < n2; ++i) {
                if (videoDigitizer.getInputFormat(i) != n) continue;
                videoDigitizer.setInput(i);
                return;
            }
            throw new RuntimeException("The specified source() is not available.");
        }
        catch (StdQTException stdQTException) {
            stdQTException.printStackTrace();
            throw new RuntimeException("Could not set the video input source.");
        }
    }

    public void format(int n) {
        try {
            VideoDigitizer videoDigitizer = this.channel.getDigitizerComponent();
            videoDigitizer.setInputStandard(n);
        }
        catch (StdQTException stdQTException) {
            stdQTException.printStackTrace();
        }
    }

    public void settings() {
        block4: {
            try {
                this.capture.stop();
                this.channel.setBounds(this.qdrect);
                this.channel.settingsDialog();
            }
            catch (StdQTException stdQTException) {
                int n = stdQTException.errorCode();
                if (n == -128) break block4;
                stdQTException.printStackTrace();
                throw new RuntimeException("Error inside Capture.settings()");
            }
        }
        try {
            this.capture.startPreview();
        }
        catch (StdQTException stdQTException) {
            stdQTException.printStackTrace();
        }
    }

    public static String[] list() {
        try {
            QTSession.open();
            SequenceGrabber sequenceGrabber = new SequenceGrabber();
            SGVideoChannel sGVideoChannel = new SGVideoChannel(sequenceGrabber);
            SGDeviceList sGDeviceList = sGVideoChannel.getDeviceList(0);
            String[] stringArray = new String[sGDeviceList.getCount()];
            for (int i = 0; i < sGDeviceList.getCount(); ++i) {
                stringArray[i] = sGDeviceList.getDeviceName(i).getName();
            }
            sequenceGrabber.disposeChannel((SGChannel)sGVideoChannel);
            QTSession.close();
            return stringArray;
        }
        catch (QTException qTException) {
            int n = qTException.errorCode();
            if (n == -9405) {
                throw new RuntimeException("Couldn't find any capture devices, read the video reference for more info.");
            }
            qTException.printStackTrace();
            throw new RuntimeException("Problem listing capture devices, read the video reference for more info.");
        }
    }
}

