/*
 * Decompiled with CFR 0.152.
 */
package processing.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;
import processing.core.PStyle;

public class PGraphicsPDF
extends PGraphicsJava2D {
    protected File file;
    protected OutputStream output;
    protected Document document;
    protected PdfWriter writer;
    protected PdfContentByte content;
    protected static DefaultFontMapper mapper;
    protected static String[] fontList;

    public void setPath(String string) {
        this.path = string;
        if (string != null) {
            this.file = new File(string);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsPDF requires an absolute path for the location of the output file.");
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.output = outputStream;
    }

    protected void allocate() {
    }

    public void beginDraw() {
        if (this.document == null) {
            this.document = new Document(new Rectangle(this.width, this.height));
            try {
                if (this.file != null) {
                    this.output = new BufferedOutputStream(new FileOutputStream(this.file), 16384);
                } else if (this.output == null) {
                    throw new RuntimeException("PGraphicsPDF requires a path for the location of the output file.");
                }
                this.writer = PdfWriter.getInstance(this.document, this.output);
                this.document.open();
                this.content = this.writer.getDirectContent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Problem saving the PDF file.");
            }
            this.g2 = this.content.createGraphics(this.width, this.height, PGraphicsPDF.getMapper());
        }
        super.beginDraw();
    }

    protected static DefaultFontMapper getMapper() {
        if (mapper == null) {
            mapper = new DefaultFontMapper();
            if (PApplet.platform == 2) {
                try {
                    String string = System.getProperty("user.home") + "/Library/Fonts";
                    mapper.insertDirectory(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mapper.insertDirectory("/System/Library/Fonts");
                mapper.insertDirectory("/Library/Fonts");
            } else if (PApplet.platform == 1) {
                File[] fileArray = File.listRoots();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].toString().startsWith("A:")) continue;
                    File file = new File(fileArray[i], "WINDOWS/Fonts");
                    if (file.exists()) {
                        mapper.insertDirectory(file.getAbsolutePath());
                        break;
                    }
                    file = new File(fileArray[i], "WINNT/Fonts");
                    if (!file.exists()) continue;
                    mapper.insertDirectory(file.getAbsolutePath());
                    break;
                }
            }
        }
        return mapper;
    }

    public void endDraw() {
    }

    protected static boolean fileExists(File file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "dir", file.getAbsolutePath()});
            boolean bl = false;
            int n = -1;
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            while (!bl) {
                while (inputStream.read() >= 0) {
                }
                while (inputStream2.read() >= 0) {
                }
                try {
                    n = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.sleep(100L);
                }
            }
            return n == 0;
        }
        catch (IOException iOException) {
            System.out.println("Unable to check for file: " + file + " : " + iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Unable to check for file.  Interrupted: " + file + " : " + interruptedException);
            return false;
        }
    }

    public void nextPage() {
        PStyle pStyle = this.getStyle();
        this.g2.dispose();
        try {
            this.document.newPage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.textMode == 5) {
            this.g2 = this.content.createGraphicsShapes(this.width, this.height);
        } else if (this.textMode == 4) {
            this.g2 = this.content.createGraphics(this.width, this.height, mapper);
        }
        this.style(pStyle);
    }

    public void dispose() {
        if (this.document != null) {
            this.g2.dispose();
            this.document.close();
            this.document = null;
        }
    }

    public boolean displayable() {
        return false;
    }

    public void textFont(PFont pFont) {
        super.textFont(pFont);
        if (this.textFont.getFont() == null) {
            throw new RuntimeException("Use createFont() instead of loadFont() when drawing text using the PDF library.");
        }
        if (!this.checkFont(pFont.getName())) {
            System.err.println("Use PGraphicsPDF.listFonts() to get a list of available fonts.");
            throw new RuntimeException("The font \u201c" + pFont.getName() + "\u201d cannot be used with PDF Export.");
        }
    }

    public void textMode(int n) {
        if (this.textMode != n) {
            if (n == 5) {
                this.g2.dispose();
                this.g2 = this.content.createGraphicsShapes(this.width, this.height);
            } else if (n == 4) {
                this.g2.dispose();
                this.g2 = this.content.createGraphics(this.width, this.height, mapper);
            } else {
                if (n == 256) {
                    throw new RuntimeException("textMode(SCREEN) not supported with PDF");
                }
                throw new RuntimeException("That textMode() does not exist");
            }
        }
    }

    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        Font font = this.textFont.getFont();
        if (font == null) {
            throw new RuntimeException("Use createFont() instead of loadFont() when drawing text using the PDF library.");
        }
        if (this.textFont.isStream() && this.textMode != 5) {
            throw new RuntimeException("Use textMode(SHAPE) with when loading .ttf and .otf files with createFont().");
        }
        if (!this.checkFont(this.textFont.getName())) {
            System.err.println("Use PGraphicsPDF.listFonts() to get a list of fonts that can be used with PDF.");
            throw new RuntimeException("The font \u201c" + this.textFont.getName() + "\u201d " + "cannot be used with PDF Export.");
        }
        super.textLineImpl(cArray, n, n2, f, f2);
    }

    public void loadPixels() {
        this.nope("loadPixels");
    }

    public void updatePixels() {
        this.nope("updatePixels");
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        this.nope("updatePixels");
    }

    public int get(int n, int n2) {
        this.nope("get");
        return 0;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        this.nope("get");
        return null;
    }

    public PImage get() {
        this.nope("get");
        return null;
    }

    public void set(int n, int n2, int n3) {
        this.nope("set");
    }

    public void set(int n, int n2, PImage pImage) {
        this.nope("set");
    }

    public void mask(int[] nArray) {
        this.nope("mask");
    }

    public void mask(PImage pImage) {
        this.nope("mask");
    }

    public void filter(int n) {
        this.nope("filter");
    }

    public void filter(int n, float f) {
        this.nope("filter");
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    public void save(String string) {
        this.nope("save");
    }

    public void addFonts(String string) {
        mapper.insertDirectory(string);
    }

    protected boolean checkFont(String string) {
        System.out.println("alias for " + string + " = " + mapper.getAliases().get(string));
        return mapper.getAliases().get(string) != null;
    }

    public static String[] listFonts() {
        if (fontList == null) {
            HashMap hashMap = PGraphicsPDF.getMapper().getAliases();
            fontList = new String[hashMap.size()];
            int n = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                PGraphicsPDF.fontList[n++] = (String)entry.getKey();
            }
            fontList = PApplet.sort(fontList);
        }
        return fontList;
    }

    protected void nope(String string) {
        throw new RuntimeException("No " + string + "() for PGraphicsPDF");
    }
}

