/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.IFRadioButton;

public class IFRadioController
extends GUIComponent {
    private IFRadioButton[] contents;
    private int numItems = 0;
    private int selected = -1;

    public IFRadioController() {
        this.contents = new IFRadioButton[5];
    }

    public IFRadioController(String argLabel) {
        this.setLabel(argLabel);
        this.contents = new IFRadioButton[5];
    }

    public IFRadioController(String argLabel, Object l) {
        this.setLabel(argLabel);
        this.addActionListener(l);
        this.contents = new IFRadioButton[5];
    }

    public void add(IFRadioButton button) {
        if (this.numItems == this.contents.length) {
            IFRadioButton[] temp = this.contents;
            this.contents = new IFRadioButton[this.contents.length * 2];
            System.arraycopy(temp, 0, this.contents, 0, this.numItems);
        }
        this.contents[this.numItems++] = button;
    }

    public void remove(IFRadioButton button) {
        int componentIndex = -1;
        int i = 0;
        while (i < this.numItems) {
            if (button == this.contents[i]) {
                componentIndex = i;
                break;
            }
            ++i;
        }
        if (componentIndex != -1) {
            this.contents[componentIndex] = null;
            if (componentIndex < this.numItems - 1) {
                System.arraycopy(this.contents, componentIndex + 1, this.contents, componentIndex, this.numItems);
            }
            --this.numItems;
        }
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public IFRadioButton getSelected() {
        if (this.selected >= 0 && this.selected < this.numItems) {
            return this.contents[this.selected];
        }
        return null;
    }

    public void selectButton(IFRadioButton button) {
        int i = 0;
        while (i < this.numItems) {
            if (this.contents[i] == button) {
                this.selected = i;
            }
            ++i;
        }
        this.fireEventNotification(button, "Selected");
    }

    public boolean getSelectionStatusForButton(IFRadioButton button) {
        if (this.selected >= 0 && this.selected < this.numItems) {
            return button == this.contents[this.selected];
        }
        return false;
    }

    public void deselectAll() {
        this.selected = -1;
    }

    public void addActionListener(Object arglistener) {
        this.listener = arglistener;
    }
}

