/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IFCheckBox
extends GUIComponent {
    private int currentColor;
    private boolean selected = false;

    public IFCheckBox(String newLabel, int newX, int newY) {
        this.setLabel(newLabel);
        this.setPosition(newX, newY);
        this.setSize(14, 14);
    }

    public void initWithParent() {
        this.controller.parent.registerMouseEvent(this);
        if (this.lookAndFeel == null) {
            return;
        }
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        this.setSize((int)Math.ceil(this.controller.parent.textWidth(this.getLabel())) + this.getHeight() + 5, 14);
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    public void mouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (this.isMouseOver(e.getX(), e.getY())) {
                this.wasClicked = true;
            }
        } else if (e.getID() == 502 && this.wasClicked && this.isMouseOver(e.getX(), e.getY())) {
            if (this.selected) {
                this.fireEventNotification(this, "Unchecked");
                this.selected = false;
            } else {
                this.fireEventNotification(this, "Checked");
                this.selected = true;
            }
            this.wasClicked = false;
        }
    }

    public void keyEvent(KeyEvent e) {
        if (e.getID() == 400 && e.getKeyChar() == ' ') {
            this.fireEventNotification(this, "Selected");
            if (this.selected) {
                this.fireEventNotification(this, "Unchecked");
                this.selected = false;
            } else {
                this.fireEventNotification(this, "Checked");
                this.selected = true;
            }
        }
    }

    public void draw() {
        this.currentColor = this.isMouseOver(this.controller.parent.mouseX, this.controller.parent.mouseY) ? this.lookAndFeel.highlightColor : (this.controller.getFocusStatusForComponent(this) ? this.lookAndFeel.highlightColor : this.lookAndFeel.baseColor);
        int x = this.getX();
        int y = this.getY();
        int hgt = this.getHeight();
        int wid = this.getWidth();
        this.controller.parent.stroke(this.lookAndFeel.borderColor);
        this.controller.parent.fill(this.currentColor);
        this.controller.parent.rect(x, y, hgt, hgt);
        if (this.selected) {
            this.controller.parent.stroke(this.lookAndFeel.darkGrayColor);
            this.controller.parent.line(x + 3, y + 2, hgt + x - 3, hgt + y - 4);
            this.controller.parent.line(x + 3, y + 3, hgt + x - 4, hgt + y - 4);
            this.controller.parent.line(x + 4, y + 2, hgt + x - 3, hgt + y - 5);
            this.controller.parent.line(x + 3, hgt + y - 4, hgt + x - 3, y + 2);
            this.controller.parent.line(x + 4, hgt + y - 4, hgt + x - 3, y + 3);
            this.controller.parent.line(x + 3, hgt + y - 5, hgt + x - 4, y + 2);
        }
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.text(this.getLabel(), (float)(hgt + x + 5), (float)(hgt - 2 + y));
        if (this.controller.showBounds) {
            this.controller.parent.noFill();
            this.controller.parent.stroke(255.0f, 0.0f, 0.0f);
            this.controller.parent.rect(x, y, wid, hgt);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }
}

