/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IFButton
extends GUIComponent {
    private int currentColor;

    public IFButton(String newLabel, int newX, int newY) {
        this(newLabel, newX, newY, 100, 21);
    }

    public IFButton(String newLabel, int newX, int newY, int newWidth) {
        this(newLabel, newX, newY, newWidth, 21);
    }

    public IFButton(String newLabel, int newX, int newY, int newWidth, int newHeight) {
        this.setLabel(newLabel);
        this.setPosition(newX, newY);
        this.setSize(newWidth, newHeight);
    }

    public void initWithParent() {
        this.controller.parent.registerMouseEvent(this);
    }

    public void mouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (this.isMouseOver(e.getX(), e.getY())) {
                this.wasClicked = true;
            }
        } else if (e.getID() == 502 && this.wasClicked && this.isMouseOver(e.getX(), e.getY())) {
            this.fireEventNotification(this, "Clicked");
            this.wasClicked = false;
        }
    }

    public void draw() {
        boolean hasFocus = this.controller.getFocusStatusForComponent(this);
        this.currentColor = this.wasClicked ? this.lookAndFeel.activeColor : (this.isMouseOver(this.controller.parent.mouseX, this.controller.parent.mouseY) || hasFocus ? this.lookAndFeel.highlightColor : this.lookAndFeel.baseColor);
        int x = this.getX();
        int y = this.getY();
        int hgt = this.getHeight();
        int wid = this.getWidth();
        this.controller.parent.stroke(this.lookAndFeel.borderColor);
        this.controller.parent.fill(this.currentColor);
        this.controller.parent.rect(x, y, wid, hgt);
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.textAlign(3);
        this.controller.parent.text(this.getLabel(), (float)x, (float)(y + 3), (float)wid, (float)hgt);
        this.controller.parent.textAlign(37);
        if (this.controller.showBounds) {
            this.controller.parent.noFill();
            this.controller.parent.stroke(255.0f, 0.0f, 0.0f);
            this.controller.parent.rect(x, y, wid, hgt);
        }
    }

    public void keyEvent(KeyEvent e) {
        if (e.getID() == 400 && e.getKeyChar() == ' ') {
            this.fireEventNotification(this, "Selected");
        }
    }
}

