/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.GUIEvent;
import interfascia.IFLookAndFeel;
import interfascia.IFPGraphicsState;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import processing.core.PApplet;

public class GUIController
implements ClipboardOwner {
    private GUIComponent[] contents;
    private int numItems = 0;
    private int focusIndex = -1;
    private boolean visible;
    private IFLookAndFeel lookAndFeel;
    public IFPGraphicsState userState;
    private Clipboard clipboard;
    public PApplet parent;
    public boolean showBounds = false;

    public GUIController(PApplet newParent) {
        this(newParent, true);
    }

    public GUIController(PApplet newParent, boolean newVisible) {
        this.setParent(newParent);
        this.setVisible(newVisible);
        this.contents = new GUIComponent[5];
        this.lookAndFeel = new IFLookAndFeel(this.parent, '\u0001');
        this.userState = new IFPGraphicsState();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkSystemClipboardAccess();
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException e) {
                this.clipboard = new Clipboard("Interfascia Clipboard");
            }
        } else {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.parent.registerKeyEvent(this);
        this.parent.registerDraw(this);
    }

    public void setLookAndFeel(IFLookAndFeel lf) {
        this.lookAndFeel = lf;
    }

    public IFLookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void add(GUIComponent component) {
        if (this.numItems == this.contents.length) {
            GUIComponent[] temp = this.contents;
            this.contents = new GUIComponent[this.contents.length * 2];
            System.arraycopy(temp, 0, this.contents, 0, this.numItems);
        }
        component.setController(this);
        component.setLookAndFeel(this.lookAndFeel);
        this.contents[this.numItems++] = component;
        component.initWithParent();
    }

    public void remove(GUIComponent component) {
        int componentIndex = -1;
        int i = 0;
        while (i < this.numItems) {
            if (component == this.contents[i]) {
                componentIndex = i;
                break;
            }
            ++i;
        }
        if (componentIndex != -1) {
            this.contents[componentIndex] = null;
            if (componentIndex < this.numItems - 1) {
                System.arraycopy(this.contents, componentIndex + 1, this.contents, componentIndex, this.numItems);
            }
            --this.numItems;
        }
    }

    public void setParent(PApplet argParent) {
        this.parent = argParent;
    }

    public PApplet getParent() {
        return this.parent;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void requestFocus(GUIComponent c) {
        int i = 0;
        while (i < this.numItems) {
            if (c == this.contents[i]) {
                this.focusIndex = i;
            }
            ++i;
        }
    }

    public void yieldFocus(GUIComponent c) {
        if (this.focusIndex > -1 && this.focusIndex < this.numItems && this.contents[this.focusIndex] == c) {
            this.focusIndex = -1;
        }
    }

    public GUIComponent getComponentWithFocus() {
        return this.contents[this.focusIndex];
    }

    public boolean getFocusStatusForComponent(GUIComponent c) {
        if (this.focusIndex >= 0 && this.focusIndex < this.numItems) {
            return c == this.contents[this.focusIndex];
        }
        return false;
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
        System.out.println("Lost ownership");
    }

    public void copy(String v) {
        StringSelection fieldContent = new StringSelection(v);
        this.clipboard.setContents(fieldContent, this);
    }

    public String paste() {
        Transferable clipboardContent = this.clipboard.getContents(this);
        if (clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String tempString = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                return tempString;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public void keyEvent(KeyEvent e) {
        if (this.visible) {
            if (e.getID() == 401 && e.getKeyCode() == 9) {
                if (this.focusIndex != -1 && this.contents[this.focusIndex] != null) {
                    this.contents[this.focusIndex].actionPerformed(new GUIEvent(this.contents[this.focusIndex], "Lost Focus"));
                }
                if ((e.getModifiersEx() & 0x40) == 64) {
                    this.giveFocusToPreviousComponent();
                } else {
                    this.giveFocusToNextComponent();
                }
                if (this.focusIndex != -1 && this.contents[this.focusIndex] != null) {
                    this.contents[this.focusIndex].actionPerformed(new GUIEvent(this.contents[this.focusIndex], "Received Focus"));
                }
            } else if (e.getKeyCode() != 9 && this.focusIndex >= 0 && this.focusIndex < this.contents.length) {
                this.contents[this.focusIndex].keyEvent(e);
            }
        }
    }

    private void giveFocusToPreviousComponent() {
        int oldFocus = this.focusIndex;
        this.focusIndex = (this.focusIndex - 1) % this.numItems;
        while (!this.contents[this.focusIndex].canReceiveFocus() && this.focusIndex != oldFocus) {
            this.focusIndex = (this.focusIndex - 1) % this.numItems;
        }
    }

    private void giveFocusToNextComponent() {
        int oldFocus = this.focusIndex;
        this.focusIndex = (this.focusIndex + 1) % this.numItems;
        while (!this.contents[this.focusIndex].canReceiveFocus() && this.focusIndex != oldFocus) {
            this.focusIndex = (this.focusIndex + 1) % this.numItems;
        }
    }

    public void draw() {
        if (this.visible) {
            this.userState.saveSettingsForApplet(this.parent);
            this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.parent);
            int i = 0;
            while (i < this.contents.length) {
                if (this.contents[i] != null) {
                    this.contents[i].draw();
                }
                ++i;
            }
            this.userState.restoreSettingsToApplet(this.parent);
        }
    }
}

