/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIController;
import interfascia.GUIEvent;
import interfascia.IFLookAndFeel;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class GUIComponent {
    private int x;
    private int y;
    private int wid;
    private int hgt;
    private String label;
    protected boolean wasClicked = false;
    protected Object listener;
    protected IFLookAndFeel lookAndFeel;
    protected GUIController controller;
    protected int index;

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public void update(int argX, int argY) {
    }

    public void draw() {
    }

    public void setController(GUIController c) {
        this.controller = c;
    }

    public GUIController getController() {
        return this.controller;
    }

    public void initWithParent() {
    }

    public void setLookAndFeel(IFLookAndFeel lf) {
        this.lookAndFeel = lf;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String argLabel) {
        this.label = argLabel;
    }

    public boolean canReceiveFocus() {
        return true;
    }

    public int getWidth() {
        return this.wid;
    }

    public void setWidth(int newWidth) {
        if (newWidth > 0) {
            this.wid = newWidth;
        }
    }

    public int getHeight() {
        return this.hgt;
    }

    public void setHeight(int newHeight) {
        if (newHeight > 0) {
            this.hgt = newHeight;
        }
    }

    public void addActionListener(Object newListener) {
        this.listener = newListener;
    }

    public void setSize(int newWidth, int newHeight) {
        if (newHeight > 0 && newWidth > 0) {
            this.hgt = newHeight;
            this.wid = newWidth;
        }
    }

    public void setPosition(int newX, int newY) {
        if (newX > 0 && newY > 0) {
            this.x = newX;
            this.y = newY;
        }
    }

    public void setX(int newX) {
        if (newX > 0) {
            this.x = newX;
        }
    }

    public int getX() {
        return this.x;
    }

    public void setY(int newY) {
        if (newY > 0) {
            this.y = newY;
        }
    }

    public int getY() {
        return this.y;
    }

    public void mouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (this.isMouseOver(e.getX(), e.getY())) {
                this.wasClicked = true;
            }
        } else if (e.getID() == 502 && this.wasClicked && this.isMouseOver(e.getX(), e.getY())) {
            this.fireEventNotification(this, "Clicked");
            this.wasClicked = false;
        }
    }

    public void keyEvent(KeyEvent e) {
    }

    public void actionPerformed(GUIEvent e) {
    }

    public void fireEventNotification(GUIComponent argComponent, String argMessage) {
        if (this.listener == null) {
            return;
        }
        try {
            GUIEvent e = new GUIEvent(argComponent, argMessage);
            Method m = this.listener.getClass().getDeclaredMethod("actionPerformed", e.getClass());
            try {
                m.invoke(this.listener, e);
            }
            catch (InvocationTargetException ex) {
                System.out.println(ex.getCause().getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (NoSuchMethodException ex) {
            System.out.println("NoSuchMethodException");
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.wid && mouseY <= this.y + this.hgt;
    }
}

