/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.Triggerable;
import org.tritonus.share.sampled.FloatSampleBuffer;

class SampleSignal
implements AudioSignal,
Triggerable {
    private FloatSampleBuffer buffer;
    private int[] marks;
    private int markAt;

    public SampleSignal(FloatSampleBuffer samps) {
        this.buffer = samps;
        this.marks = new int[20];
        int i = 0;
        while (i < this.marks.length) {
            this.marks[i] = -1;
            ++i;
        }
        this.markAt = 0;
    }

    public void generate(float[] signal) {
        int i = 0;
        while (i < this.marks.length) {
            int begin = this.marks[i];
            if (begin != -1) {
                int j = begin;
                int k = 0;
                while (j < this.buffer.getSampleCount() && k < signal.length) {
                    int n = k++;
                    signal[n] = signal[n] + this.buffer.getChannel(0)[j];
                    ++j;
                }
                this.marks[i] = j < this.buffer.getSampleCount() ? j : -1;
            }
            ++i;
        }
    }

    public void generate(float[] left, float[] right) {
        int i = 0;
        while (i < this.marks.length) {
            int begin = this.marks[i];
            if (begin != -1) {
                int j = begin;
                int k = 0;
                while (j < this.buffer.getSampleCount() && k < left.length) {
                    int n = k;
                    left[n] = left[n] + this.buffer.getChannel(0)[j];
                    int n2 = k++;
                    right[n2] = right[n2] + this.buffer.getChannel(1)[j];
                    ++j;
                }
                this.marks[i] = j < this.buffer.getSampleCount() ? j : -1;
            }
            ++i;
        }
    }

    public void trigger() {
        this.marks[this.markAt] = 0;
        ++this.markAt;
        if (this.markAt == this.marks.length) {
            this.markAt = 0;
        }
    }

    public void stop() {
        int i = 0;
        while (i < this.marks.length) {
            this.marks[i] = -1;
            ++i;
        }
    }

    public float[] getChannel(int channelNumber) {
        if (channelNumber == 1) {
            return this.buffer.getChannel(0);
        }
        if (channelNumber == 2) {
            return this.buffer.getChannel(1);
        }
        Minim.error("getChannel: Illegal channel number " + channelNumber);
        return null;
    }
}

