/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.javasound.JSBaseAudioRecordingStream;
import ddf.minim.javasound.JSMinim;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

class JSPCMAudioRecordingStream
extends JSBaseAudioRecordingStream {
    private AudioMetaData meta;

    JSPCMAudioRecordingStream(JSMinim sys, AudioMetaData mdata, AudioInputStream stream, SourceDataLine sdl, int bufferSize) {
        super(sys, stream, sdl, bufferSize, mdata.length());
        this.meta = mdata;
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public int getMillisecondLength() {
        return this.meta.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rewind() {
        try {
            AudioInputStream audioInputStream = this.ais;
            synchronized (audioInputStream) {
                this.ais.close();
                this.ais = this.system.getAudioInputStream(this.meta.fileName());
            }
        }
        catch (IOException e) {
            this.system.error("Couldn't rewind!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int skip(int millis) {
        long toSkip = AudioUtils.millis2BytesFrameAligned(millis, this.format);
        this.system.debug("Skipping forward by " + millis + " milliseconds, which is " + toSkip + " bytes.");
        byte[] skipBytes = new byte[(int)toSkip];
        long totalSkipped = 0L;
        try {
            while (totalSkipped < toSkip) {
                long read;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    read = this.ais.read(skipBytes, 0, (int)(toSkip - totalSkipped));
                }
                if (read != -1L) {
                    totalSkipped += read;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.system.error("Unable to skip due to read error: " + e.getMessage());
        }
        this.system.debug("Total actually skipped was " + totalSkipped + ", which is " + AudioUtils.bytes2Millis(totalSkipped, this.ais.getFormat()) + " milliseconds.");
        return (int)totalSkipped;
    }
}

