/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.spi.AudioSynthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.FloatSampleBuffer;

final class JSAudioSynthesizer
extends Thread
implements AudioSynthesizer {
    private AudioListener listener;
    private AudioSignal signal;
    private AudioEffect effect;
    private SourceDataLine line;
    private AudioFormat format;
    private FloatSampleBuffer buffer;
    private int bufferSize;
    private boolean finished;
    private byte[] outBytes;

    JSAudioSynthesizer(SourceDataLine sdl, int bufferSize) {
        this.bufferSize = bufferSize;
        this.format = sdl.getFormat();
        this.buffer = new FloatSampleBuffer(this.format.getChannels(), bufferSize, this.format.getSampleRate());
        this.outBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        this.finished = false;
        this.line = sdl;
    }

    public void run() {
        this.line.start();
        while (!this.finished) {
            this.buffer.makeSilence();
            if (this.line.getFormat().getChannels() == 1) {
                if (this.signal != null) {
                    this.signal.generate(this.buffer.getChannel(0));
                }
                this.effect.process(this.buffer.getChannel(0));
                this.listener.samples(this.buffer.getChannel(0));
            } else {
                if (this.signal != null) {
                    this.signal.generate(this.buffer.getChannel(0), this.buffer.getChannel(1));
                }
                this.effect.process(this.buffer.getChannel(0), this.buffer.getChannel(1));
                this.listener.samples(this.buffer.getChannel(0), this.buffer.getChannel(1));
            }
            this.buffer.convertToByteArray(this.outBytes, 0, this.format);
            if (this.line.available() == this.line.getBufferSize()) {
                Minim.error("Likely buffer underrun in AudioOutput.");
            }
            this.line.write(this.outBytes, 0, this.outBytes.length);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.line.drain();
        this.line.stop();
        this.line.close();
        this.line = null;
    }

    public void open() {
        this.start();
    }

    public void close() {
        this.finished = true;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setAudioEffect(AudioEffect effect) {
        this.effect = effect;
    }

    public void setAudioSignal(AudioSignal signal) {
        this.signal = signal;
    }

    public void setAudioListener(AudioListener listener) {
        this.listener = listener;
    }

    public Control[] getControls() {
        return this.line.getControls();
    }
}

