/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.Minim;
import ddf.minim.spi.AudioStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.share.sampled.FloatSampleBuffer;

final class JSAudioStream
extends Thread
implements AudioStream {
    private AudioListener listener;
    private AudioEffect effect;
    private TargetDataLine line;
    private FloatSampleBuffer buffer;
    private int bufferSize;
    private boolean finished;
    private boolean mono;
    private byte[] rawBytes;

    JSAudioStream(TargetDataLine tdl, int bufferSize) {
        this.line = tdl;
        this.bufferSize = bufferSize;
        this.buffer = new FloatSampleBuffer(tdl.getFormat().getChannels(), bufferSize, tdl.getFormat().getSampleRate());
        this.finished = false;
        this.mono = this.buffer.getChannelCount() == 1;
        int byteBufferSize = this.buffer.getByteArrayBufferSize(this.line.getFormat());
        Minim.debug("byteBufferSize is " + byteBufferSize);
        this.rawBytes = new byte[byteBufferSize];
    }

    public void run() {
        this.line.start();
        while (!this.finished) {
            this.line.read(this.rawBytes, 0, this.rawBytes.length);
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.line.getFormat(), 0, this.buffer.getSampleCount());
            if (this.mono) {
                float[] samp = this.buffer.getChannel(0);
                this.effect.process(samp);
                this.listener.samples(samp);
            } else {
                float[] sampL = this.buffer.getChannel(0);
                float[] sampR = this.buffer.getChannel(1);
                this.effect.process(sampL, sampR);
                this.listener.samples(sampL, sampR);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.line.flush();
        this.line.stop();
        this.line.close();
        this.line = null;
    }

    public void open() {
        this.start();
    }

    public void close() {
        this.finished = true;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.line.getFormat();
    }

    public void setAudioEffect(AudioEffect effect) {
        this.effect = effect;
    }

    public void setAudioListener(AudioListener listener) {
        this.listener = listener;
    }

    public Control[] getControls() {
        return this.line.getControls();
    }
}

