/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.AudioSource;
import ddf.minim.Minim;
import ddf.minim.Playable;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;

public class AudioPlayer
extends AudioSource
implements Playable {
    private AudioRecording recording;

    public AudioPlayer(AudioRecordingStream recording) {
        super(recording);
        this.recording = recording;
    }

    public void play() {
        this.recording.play();
    }

    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    public void pause() {
        this.recording.pause();
    }

    public void rewind() {
        this.cue(0);
    }

    public void loop() {
        this.recording.loop(-1);
    }

    public void loop(int n) {
        this.recording.loop(n);
    }

    public int loopCount() {
        return this.recording.getLoopCount();
    }

    public int length() {
        return this.recording.getMillisecondLength();
    }

    public int position() {
        return this.recording.getMillisecondPosition();
    }

    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        } else if (millis > this.length()) {
            millis = this.length();
        }
        this.recording.setMillisecondPosition(millis);
    }

    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        Minim.debug("AudioPlayer.skip: skipping " + millis + " milliseconds, new position is " + pos);
        this.recording.setMillisecondPosition(pos);
    }

    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    public void setLoopPoints(int start, int stop) {
        this.recording.setLoopPoints(start, stop);
    }
}

