/*
 * Decompiled with CFR 0.152.
 */
package datinggamefinalfinal;

import datinggamefinalfinal.Candidate;
import datinggamefinalfinal.Icon;
import datinggamefinalfinal.Matchmaker;
import datinggamefinalfinal.Person;
import datinggamefinalfinal.Rectangle;
import datinggamefinalfinal.Square;
import datinggamefinalfinal.Tab;
import datinggamefinalfinal.menuIcon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import processing.core.PApplet;

public class DatingGameFinalFinal
extends PApplet {
    private static final long serialVersionUID = 7894611403364472258L;
    private boolean gameOver = false;
    private boolean gameSetup = false;
    private boolean menuSetup = false;
    private boolean menuActive = true;
    private boolean gameActive = false;
    private int N = 5;
    private Candidate[] candidateSelection = null;
    private Matchmaker[] matchmaker = null;
    private Person person = null;
    private Tab[] tabs = null;
    private int activeTab = 1;
    private Vector<Double> graphPoints = new Vector();
    int clock = 120;
    int frameCount = 0;
    int numMatchmakers = 1;
    boolean timer = false;
    private menuIcon mOne;
    private menuIcon mTwo;
    private menuIcon easy;
    private menuIcon med;
    private menuIcon hard;
    private menuIcon yes;
    private menuIcon no;
    private Icon next;
    private Icon prev;

    @Override
    public void setup() {
        this.size(1280, 768);
        Icon.pApplet = this;
        Square.pApplet = this;
        Rectangle.pApplet = this;
        Candidate.pApplet = this;
        Tab.pApplet = this;
        Person.pApplet = this;
        Matchmaker.pApplet = this;
        menuIcon.pApplet = this;
        this.initMenuIcon();
    }

    public void initMenuIcon() {
        this.mOne = new menuIcon(550, 280, 32, 255, 0, 0);
        this.mTwo = new menuIcon(550, 320, 32, 0, 0, 255);
        this.easy = new menuIcon(550, 400, 32, 204, 255, 153);
        this.med = new menuIcon(640, 400, 32, 102, 255, 102);
        this.hard = new menuIcon(550, 440, 32, 0, 204, 102);
        this.yes = new menuIcon(550, 520, 32, 102, 255, 204);
        this.no = new menuIcon(640, 520, 32, 102, 204, 204);
    }

    public void initMatchmaker() {
        this.matchmaker = new Matchmaker[this.numMatchmakers];
        int x = 16;
        int y = 280;
        boolean active = false;
        int i = 0;
        while (i < this.numMatchmakers) {
            active = i == 0;
            this.matchmaker[i] = new Matchmaker(x, y, active);
            y += 64;
            ++i;
        }
    }

    public void initGraphPoints() {
        double positive = 1.0;
        int i = 0;
        while (i < 10) {
            this.graphPoints.add(i, positive);
            positive -= 0.1;
            positive = (double)((int)(positive * 100.0)) / 100.0;
            ++i;
        }
        this.graphPoints.add(10, 0.0);
        double negative = -0.1;
        int i2 = 11;
        while (i2 < 21) {
            this.graphPoints.add(i2, negative);
            negative += -0.1;
            negative = (double)((int)(negative * 100.0)) / 100.0;
            ++i2;
        }
    }

    public void initIcons() {
        this.next = new Icon(956, 675, 96, 32, 204, 255, 102);
        this.prev = new Icon(200, 675, 96, 32, 255, 255, 102);
    }

    public void initPerson() {
        double tmp2;
        Random generator = new Random();
        int numPositive = this.N;
        int numNegative = 0;
        double sumPositive = 0.0;
        double sumNegative = 0.0;
        Vector<Double> positive = new Vector<Double>();
        Vector<Double> negative = new Vector<Double>();
        while (numPositive > this.N - 1) {
            numPositive = generator.nextInt(this.N) + 2;
        }
        double tmp = 1.0 / (double)numPositive;
        tmp = (double)((int)(tmp * 100.0)) / 100.0;
        int i = 0;
        while (i < numPositive) {
            positive.add(i, tmp);
            ++i;
        }
        i = 0;
        while (i < numPositive - 1) {
            tmp = (Double)positive.get(i);
            tmp2 = (Double)positive.get(i + 1);
            tmp2 += (tmp /= 2.0);
            tmp = (double)((int)(tmp * 100.0)) / 100.0;
            tmp2 = (double)((int)(tmp2 * 100.0)) / 100.0;
            positive.set(i, tmp);
            positive.set(i + 1, tmp2);
            i += 2;
        }
        i = 0;
        while (i + 2 < numPositive) {
            tmp = (Double)positive.get(i);
            tmp2 = (Double)positive.get(i + 2);
            tmp2 += (tmp /= 2.0);
            tmp = (double)((int)(tmp * 100.0)) / 100.0;
            tmp2 = (double)((int)(tmp2 * 100.0)) / 100.0;
            positive.set(i, tmp);
            positive.set(i + 2, tmp2);
            ++i;
        }
        i = 0;
        while (i < numPositive) {
            sumPositive += ((Double)positive.get(i)).doubleValue();
            ++i;
        }
        if (sumPositive < 1.0) {
            tmp = 1.0 - sumPositive;
            tmp2 = (Double)positive.get(0);
            tmp += tmp2;
            tmp = (double)((int)(tmp * 100.0)) / 100.0;
            positive.set(0, tmp);
        }
        numNegative = this.N - numPositive;
        tmp = -1.0 / (double)numNegative;
        tmp = (double)((int)(tmp * 100.0)) / 100.0;
        i = 0;
        while (i < numNegative) {
            negative.add(i, tmp);
            ++i;
        }
        i = 0;
        while (i < numNegative - 1) {
            tmp = (Double)negative.get(i);
            tmp2 = (Double)negative.get(i + 1);
            tmp2 += (tmp /= 2.0);
            tmp = (double)((int)(tmp * 100.0)) / 100.0;
            tmp2 = (double)((int)(tmp2 * 100.0)) / 100.0;
            negative.set(i, tmp);
            negative.set(i + 1, tmp2);
            i += 2;
        }
        i = 0;
        while (i + 2 < numNegative) {
            tmp = (Double)negative.get(i);
            tmp2 = (Double)negative.get(i + 2);
            tmp2 += (tmp /= 2.0);
            tmp = (double)((int)(tmp * 100.0)) / 100.0;
            tmp2 = (double)((int)(tmp2 * 100.0)) / 100.0;
            negative.set(i, tmp);
            negative.set(i + 2, tmp2);
            ++i;
        }
        i = 0;
        while (i < numNegative) {
            sumNegative += ((Double)negative.get(i)).doubleValue();
            ++i;
        }
        if (sumNegative > -1.0) {
            tmp = sumNegative - -1.0;
            tmp2 = (Double)negative.get(0);
            tmp = tmp2 - tmp;
            tmp = (double)((int)(tmp * 100.0)) / 100.0;
            negative.set(0, tmp);
        }
        this.person = new Person(8, 8);
        i = 0;
        while (i < numPositive) {
            this.person.setAttrVal((Double)positive.get(i), i);
            ++i;
        }
        int k = 0;
        while (k < numNegative) {
            this.person.setAttrVal((Double)negative.get(k), k + numPositive);
            ++k;
        }
        this.person.randomize();
        URL urlF = null;
        try {
            urlF = new URL(this.getCodeBase(), "./data/FNames.txt");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            InputStream is = urlF.openStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(is));
            int offset = generator.nextInt(20) + 1;
            String candidateName = null;
            int line = 0;
            while (line != offset) {
                candidateName = input.readLine();
                ++line;
            }
            this.person.setName(candidateName);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public void initCandidate() {
        Random generator = new Random();
        double value = 0.0;
        this.candidateSelection = new Candidate[50];
        int cCnt = 0;
        URL urlM = null;
        try {
            urlM = new URL(this.getCodeBase(), "./data/MNames.txt");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            InputStream is = urlM.openStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(is));
            int offset = generator.nextInt(50) + 1;
            int line = 0;
            while (line != offset) {
                input.readLine();
                ++line;
            }
            int tb = 0;
            while (tb < 10) {
                int x = 240;
                int y = 150;
                int i = 0;
                while (i < 5) {
                    String candidateName = input.readLine();
                    this.candidateSelection[cCnt] = new Candidate(x, y, tb + 1, candidateName);
                    int k = 0;
                    while (k < this.N) {
                        int temp = (int)(generator.nextDouble() * 100.0);
                        value = (double)temp / 100.0;
                        if (value < 0.5) {
                            this.candidateSelection[cCnt].setAttrVal(0, k);
                        } else {
                            this.candidateSelection[cCnt].setAttrVal(1, k);
                        }
                        ++k;
                    }
                    x += 155;
                    ++cCnt;
                    ++i;
                }
                ++tb;
            }
            double score = 0.0;
            boolean ideal = false;
            int i = 0;
            while (i < 50) {
                score = 0.0;
                int k = 0;
                while (k < this.N) {
                    score += (double)this.candidateSelection[i].attrValue.get(k).intValue() * this.person.attrValue.get(k);
                    ++k;
                }
                score = (double)((int)(score * 100.0)) / 100.0;
                this.candidateSelection[i].setScore(score);
                if (score == 1.0) {
                    ideal = true;
                }
                ++i;
            }
            if (!ideal) {
                int cIdeal = generator.nextInt(50);
                int i2 = 0;
                while (i2 < this.N) {
                    if (this.person.attrValue.get(i2) > 0.0) {
                        this.candidateSelection[cIdeal].resetAttrVal(1, i2);
                    } else {
                        this.candidateSelection[cIdeal].resetAttrVal(0, i2);
                    }
                    ++i2;
                }
                this.candidateSelection[cIdeal].setScore(1.0);
            }
        }
        catch (IOException e) {
            System.out.println("Exception" + e);
        }
    }

    public void initTabs() {
        this.activeTab = 1;
        Random R = new Random();
        Random G = new Random();
        Random B = new Random();
        this.tabs = new Tab[10];
        int x = 200;
        boolean active = false;
        int i = 0;
        while (i < 10) {
            int y;
            if (i == 0) {
                active = true;
                y = 50;
            } else {
                active = false;
                y = 10;
            }
            this.tabs[i] = new Tab(x, y, R.nextInt(255), G.nextInt(255), B.nextInt(255), active);
            x += 80;
            ++i;
        }
    }

    public void initAttrNames() {
        Random generator = new Random();
        URL urlA = null;
        try {
            urlA = new URL(this.getCodeBase(), "./data/Attributes.txt");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            InputStream is = urlA.openStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(is));
            int offset = generator.nextInt(30) + 1;
            Vector<String> attrName = new Vector<String>();
            int line = 0;
            while (line != offset) {
                input.readLine();
                ++line;
            }
            int i = 0;
            while (i < this.N) {
                attrName.add(i, input.readLine());
                this.person.setAttrName((String)attrName.get(i), i);
                ++i;
            }
            i = 0;
            while (i < 50) {
                int k = 0;
                while (k < this.N) {
                    this.candidateSelection[i].setAttrName((String)attrName.get(k), k);
                    ++k;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initTimer() {
        this.frameCount = 0;
        this.clock = 120;
    }

    @Override
    public void draw() {
        if (this.gameActive) {
            if (!this.gameSetup) {
                this.gameOver = false;
                if (this.timer) {
                    this.initTimer();
                }
                this.initIcons();
                this.initPerson();
                this.initCandidate();
                this.initAttrNames();
                this.initTabs();
                this.initGraphPoints();
                this.initMatchmaker();
                this.gameSetup = true;
            }
            this.background(255);
            if (this.timer) {
                this.drawTime();
            }
            this.drawLayout();
            this.drawTabs();
            this.drawCandidates();
            this.drawPlot();
            this.drawPerson();
            this.drawIcons();
            this.drawMatchmaker();
            if (!this.gameOver) {
                if (this.timer) {
                    ++this.frameCount;
                    if (this.frameCount == 45) {
                        --this.clock;
                        this.frameCount = 0;
                        if (this.clock == 0) {
                            this.gameOver = true;
                        }
                    }
                }
                int noMore = 0;
                int i = 0;
                while (i < 50) {
                    if (this.candidateSelection[i].getSel()) {
                        ++noMore;
                    }
                    ++i;
                }
                if (noMore == 50) {
                    this.gameOver = true;
                }
                i = 0;
                while (i < this.numMatchmakers) {
                    if (this.matchmaker[i].getScore() == 1.0) {
                        this.gameOver = true;
                    }
                    ++i;
                }
            }
            if (this.gameOver) {
                this.fill(0.0f, 0.0f, 0.0f);
                this.textSize(16.0f);
                if (this.numMatchmakers == 1) {
                    this.text("GAME OVER! YOUR BEST SCORE: " + this.matchmaker[0].getScore(), 500.0f, 700.0f);
                } else if (this.matchmaker[0].getScore() > this.matchmaker[1].getScore()) {
                    this.text("GAME OVER! MATCHMAKER ONE WINS!!", 500.0f, 700.0f);
                } else if (this.matchmaker[0].getScore() < this.matchmaker[1].getScore()) {
                    this.text("GAME OVER! MATCHMAKER TWO WINS!!", 500.0f, 700.0f);
                } else if (this.matchmaker[0].getCount() < this.matchmaker[1].getCount()) {
                    this.text("GAME OVER! MATCHMAKER ONE WINS!!", 500.0f, 700.0f);
                } else {
                    this.text("GAME OVER! MATCHMAKER TWO WINS!!", 500.0f, 700.0f);
                }
                this.textSize(12.0f);
            } else {
                this.textSize(14.0f);
                int i = 0;
                while (i < this.numMatchmakers) {
                    if (this.matchmaker[i].isActive()) {
                        if (i == 0) {
                            this.fill(255.0f, 0.0f, 0.0f);
                        } else {
                            this.fill(0.0f, 0.0f, 255.0f);
                        }
                        this.text("MATCHMAKER " + (i + 1) + "'s turn", 500.0f, 700.0f);
                    }
                    ++i;
                }
                this.textSize(12.0f);
            }
        }
        if (this.menuActive) {
            if (!this.menuSetup) {
                this.initMenuIcon();
                this.menuSetup = true;
            }
            this.background(0);
            this.drawMenu();
        }
    }

    public void drawMenu() {
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(500.0f, 200.0f, 200.0f, 400.0f);
        this.fill(204.0f, 102.0f, 153.0f);
        this.textSize(36.0f);
        this.text("THE DATING GAME v1.0", 412.0f, 150.0f);
        this.fill(204.0f, 102.0f, 204.0f);
        this.textSize(18.0f);
        this.text("MENU", 575.0f, 220.0f);
        this.fill(0.0f, 0.0f, 0.0f);
        this.textSize(12.0f);
        this.text("SELECT # OF MATCHMAKERS: ", 510.0f, 260.0f);
        this.mOne.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("ONE", 513.0f, 300.0f);
        this.mTwo.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("TWO", 513.0f, 340.0f);
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("SELECT DIFFICULTY LEVEL: ", 510.0f, 380.0f);
        this.easy.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("EASY", 510.0f, 420.0f);
        this.med.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("MED", 605.0f, 420.0f);
        this.hard.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("HARD", 510.0f, 460.0f);
        this.text("TIMER:", 510.0f, 500.0f);
        this.yes.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("YES:", 510.0f, 540.0f);
        this.no.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("NO:", 605.0f, 540.0f);
        this.text("PRESS 'r' TO START ", 575.0f, 590.0f);
        this.fill(255.0f, 204.0f, 0.0f);
        this.textSize(14.0f);
        this.text("ARCHITECT: Anjali Menon (aam465@nyu.edu)", 32.0f, 32.0f);
        this.textSize(12.0f);
    }

    public void drawMatchmaker() {
        int i = 0;
        while (i < this.numMatchmakers) {
            this.matchmaker[i].draw();
            ++i;
        }
    }

    public void drawTime() {
        this.fill(0.0f, 0.0f, 0.0f);
        this.textSize(18.0f);
        this.text("TIME: " + this.clock, 32.0f, 200.0f);
        this.textSize(12.0f);
    }

    public void drawPerson() {
        this.person.draw();
    }

    public void drawPlot() {
        int y = 28;
        int i = 0;
        while (i < 50) {
            if (this.candidateSelection[i].getSel()) {
                if (this.candidateSelection[i].getClaim() == 1.0) {
                    this.fill(255.0f, 0.0f, 0.0f);
                } else {
                    this.fill(0.0f, 0.0f, 255.0f);
                }
                double score = this.candidateSelection[i].getScore();
                score = (double)((int)(score * 10.0)) / 10.0;
                int k = 0;
                while (k < 21) {
                    if (score == this.graphPoints.get(k)) {
                        this.rect(1180.0f, y + 30 * k, 68.0f, 10.0f);
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void drawLayout() {
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("IDEAL CANDIDATE", 1136.0f, 18.0f);
        this.text("TROLL", 1200.0f, 668.0f);
        this.stroke(153);
        this.line(1248.0f, 28.0f, 1248.0f, 658.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(200.0f, 100.0f, 850.0f, 560.0f);
        if (this.numMatchmakers < 2) {
            this.fill(255.0f, 0.0f, 0.0f);
            this.textSize(16.0f);
            this.text("MATCHMAKER ONE", 16.0f, 260.0f);
        } else {
            this.fill(255.0f, 0.0f, 0.0f);
            this.textSize(16.0f);
            this.text("MATCHMAKER ONE", 16.0f, 260.0f);
            this.fill(0.0f, 0.0f, 255.0f);
            this.text("MATCHMAKER TWO", 16.0f, 323.0f);
        }
        this.textSize(12.0f);
    }

    public void drawIcons() {
        this.prev.draw();
        this.textSize(14.0f);
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("PREV", 228.0f, 698.0f);
        this.next.draw();
        this.fill(0.0f, 0.0f, 0.0f);
        this.text("NEXT", 986.0f, 698.0f);
        this.text("CONTROLS:", 8.0f, 564.0f);
        this.textSize(12.0f);
        this.text("* Press 'r' to return to MENU", 8.0f, 600.0f);
        this.text("* Click candidate profile to select", 8.0f, 618.0f);
        this.text("* Click colored tabs above", 8.0f, 636.0f);
        this.text("(OR)", 8.0f, 654.0f);
        this.text("Click PREV or NEXT to ", 8.0f, 672.0f);
        this.text("toggle between candidate ", 8.0f, 690.0f);
        this.text("sets -- >", 8.0f, 708.0f);
    }

    public void drawCandidates() {
        int i = 0;
        while (i < 50) {
            if (this.activeTab == this.candidateSelection[i].tabID) {
                this.candidateSelection[i].draw();
            }
            ++i;
        }
    }

    public void drawTabs() {
        int i = 0;
        while (i < 10) {
            this.tabs[i].draw();
            ++i;
        }
    }

    @Override
    public void mouseClicked() {
        if (this.menuActive) {
            if (this.mOne.isColliding(this.mouseX, this.mouseY)) {
                this.numMatchmakers = 1;
                this.mOne.setSel(true);
                this.mTwo.setSel(false);
            }
            if (this.mTwo.isColliding(this.mouseX, this.mouseY)) {
                this.numMatchmakers = 2;
                this.mTwo.setSel(true);
                this.mOne.setSel(false);
            }
            if (this.easy.isColliding(this.mouseX, this.mouseY)) {
                this.N = 5;
                this.easy.setSel(true);
                this.med.setSel(false);
                this.hard.setSel(false);
            }
            if (this.med.isColliding(this.mouseX, this.mouseY)) {
                this.N = 10;
                this.med.setSel(true);
                this.easy.setSel(false);
                this.hard.setSel(false);
            }
            if (this.hard.isColliding(this.mouseX, this.mouseY)) {
                this.N = 20;
                this.hard.setSel(true);
                this.easy.setSel(false);
                this.med.setSel(false);
            }
            if (this.yes.isColliding(this.mouseX, this.mouseY)) {
                this.yes.setSel(true);
                this.no.setSel(false);
                this.timer = true;
            }
            if (this.no.isColliding(this.mouseX, this.mouseY)) {
                this.no.setSel(true);
                this.yes.setSel(false);
                this.timer = false;
            }
        }
        if (this.gameActive) {
            if (this.next.isColliding(this.mouseX, this.mouseY) && this.activeTab != 10) {
                this.tabs[this.activeTab - 1 + 1].setActive();
                this.tabs[this.activeTab - 1].reset();
                ++this.activeTab;
            }
            if (this.prev.isColliding(this.mouseX, this.mouseY) && this.activeTab != 1) {
                this.tabs[this.activeTab - 1 - 1].setActive();
                this.tabs[this.activeTab - 1].reset();
                --this.activeTab;
            }
            int i = 0;
            while (i < 10) {
                if (this.tabs[i].isColliding(this.mouseX, this.mouseY) && !this.tabs[i].isActive()) {
                    this.tabs[i].setActive();
                    this.tabs[this.activeTab - 1].reset();
                    this.activeTab = i + 1;
                }
                ++i;
            }
            if (!this.gameOver) {
                i = 0;
                while (i < 5) {
                    int k = 0;
                    while (k < 50) {
                        if (this.candidateSelection[k].tabID == this.activeTab && this.candidateSelection[k].isColliding(this.mouseX, this.mouseY) && !this.candidateSelection[k].getSel()) {
                            double score = 0.0;
                            score = this.candidateSelection[k].getScore();
                            this.candidateSelection[k].setSel();
                            int m = 0;
                            while (m < this.numMatchmakers) {
                                if (this.matchmaker[m].isActive()) {
                                    this.matchmaker[m].setCandidateCount();
                                    if (score > this.matchmaker[m].getScore()) {
                                        this.matchmaker[m].setScore(score);
                                    }
                                    if (this.numMatchmakers > 1) {
                                        this.matchmaker[m].setActive(false);
                                    }
                                    this.candidateSelection[k].setClaim(m + 1);
                                } else {
                                    this.matchmaker[m].setActive(true);
                                }
                                ++m;
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void keyPressed() {
        if (this.key == 'r' && this.menuActive) {
            this.gameActive = true;
            this.menuActive = false;
            this.menuSetup = false;
        } else if (this.key == 'r' && this.gameActive) {
            this.gameActive = false;
            this.menuActive = true;
            this.gameSetup = false;
        }
    }
}

