% INIT  initializes the structures X and Z so that:
%       X.s, Z.s:  identity nxn matrices times scalefac
%       X.q, Z.q:  blocks are (1,0,...,0) times scalefac
%       X.l, Z.l:  vectors of all ones times scalefac
%       and y to the zero vector of length m.
%
% The following variables must be available in the Matlab workspace:
%     - blk             block info structure
%     -     blk.s       block info for SD
%     -     blk.q       block info for QC
%     -     blk.l       block info for LP
%     - b               rhs of primal constraints
%
 if isfield(blk,'s')
    n = sum(blk.s);
    if n > 0
       if length(blk.s) > 1
          X.s = scalefac*speye(n);
          Z.s = scalefac*speye(n);
       else
          X.s = scalefac*eye(n);
          Z.s = scalefac*eye(n);
       end
    end
 end
%
 if isfield(blk,'q')
    n = sum(blk.q);
    if n > 0
       X.q = zeros(n,1);
       Z.q = zeros(n,1);
       idx = 1;
       for i = 1:length(blk.q)
          X.q(idx) = scalefac;
          Z.q(idx) = scalefac;
          idx = idx + blk.q(i);
       end
    end
 end
%
 if isfield(blk,'l')
    n = sum(blk.l);
    if n > 0
       X.l = scalefac*ones(n,1);
       Z.l = scalefac*ones(n,1);
    end
 end
%
 y = zeros(length(b),1);
%
 clear n
